/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BinaryTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TableData;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ColumnTable;

public class BinaryTableHDU
extends TableHDU {
    private BinaryTable table;
    private String[] keyStems = new String[]{"TTYPE", "TFORM", "TUNIT", "TNULL", "TSCAL", "TZERO", "TDISP", "TDIM"};

    public BinaryTableHDU(Header hdr, Data datum) {
        super((TableData)((Object)datum));
        this.myHeader = hdr;
        this.myData = datum;
        this.table = (BinaryTable)datum;
    }

    public static Data manufactureData(Header header) throws FitsException {
        return new BinaryTable(header);
    }

    public Data manufactureData() throws FitsException {
        return BinaryTableHDU.manufactureData(this.myHeader);
    }

    public static Header manufactureHeader(Data data) throws FitsException {
        Header hdr = new Header();
        data.fillHeader(hdr);
        return hdr;
    }

    public static Data encapsulate(Object o) throws FitsException {
        if (o instanceof ColumnTable) {
            return new BinaryTable((ColumnTable)o);
        }
        if (o instanceof Object[][]) {
            return new BinaryTable((Object[][])o);
        }
        if (o instanceof Object[]) {
            return new BinaryTable((Object[])o);
        }
        throw new FitsException("Unable to encapsulate object of type:" + o.getClass().getName() + " as BinaryTable");
    }

    public static boolean isHeader(Header header) {
        String xten = header.getStringValue("XTENSION");
        if (xten == null) {
            return false;
        }
        return (xten = xten.trim()).equals("BINTABLE") || xten.equals("A3DTABLE");
    }

    public boolean isHeader() {
        return BinaryTableHDU.isHeader(this.myHeader);
    }

    public static boolean isData(Object o) {
        return o instanceof ColumnTable || o instanceof Object[][] || o instanceof Object[];
    }

    public int addColumn(Object data) throws FitsException {
        int col = this.table.addColumn(data);
        this.table.pointToColumn(this.getNCols() - 1, this.myHeader);
        return col;
    }

    public void write(ArrayDataOutput ado) throws FitsException {
        int oldSize = this.myHeader.getIntValue("PCOUNT");
        if (oldSize != this.table.getHeapSize()) {
            this.myHeader.addValue("PCOUNT", this.table.getHeapSize(), "Includes Heap");
        }
        if (this.myHeader.getIntValue("PCOUNT") == 0) {
            this.myHeader.deleteKey("THEAP");
        } else {
            this.myHeader.getIntValue("TFIELDS");
            int offset = this.myHeader.getIntValue("NAXIS1") * this.myHeader.getIntValue("NAXIS2") + this.table.getHeapOffset();
            this.myHeader.addValue("THEAP", offset, "");
        }
        super.write(ado);
    }

    private void prtField(String type, String field) {
        String val = this.myHeader.getStringValue(field);
        if (val != null) {
            System.out.print(type + '=' + val + "; ");
        }
    }

    public void info() {
        BinaryTable myData = (BinaryTable)this.myData;
        System.out.println("  Binary Table");
        System.out.println("      Header Information:");
        int nhcol = this.myHeader.getIntValue("TFIELDS", -1);
        int nrow = this.myHeader.getIntValue("NAXIS2", -1);
        int rowsize = this.myHeader.getIntValue("NAXIS1", -1);
        System.out.print("          " + nhcol + " fields");
        System.out.println(", " + nrow + " rows of length " + rowsize);
        for (int i = 1; i <= nhcol; ++i) {
            System.out.print("           " + i + ":");
            this.prtField("Name", "TTYPE" + i);
            this.prtField("Format", "TFORM" + i);
            this.prtField("Dimens", "TDIM" + i);
            System.out.println("");
        }
        System.out.println("      Data Information:");
        if (myData == null || this.table.getNRows() == 0 || this.table.getNCols() == 0) {
            System.out.println("         No data present");
            if (this.table.getHeapSize() > 0) {
                System.out.println("         Heap size is: " + this.table.getHeapSize() + " bytes");
            }
        } else {
            System.out.println("          Number of rows=" + this.table.getNRows());
            System.out.println("          Number of columns=" + this.table.getNCols());
            if (this.table.getHeapSize() > 0) {
                System.out.println("          Heap size is: " + this.table.getHeapSize() + " bytes");
            }
            Object[] cols = this.table.getFlatColumns();
            for (int i = 0; i < cols.length; ++i) {
                System.out.println("           " + i + ":" + ArrayFuncs.arrayDescription(cols[i]));
            }
        }
    }

    public String[] columnKeyStems() {
        return this.keyStems;
    }
}

