/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table;

import alma.acs.logging.dialogs.LoadURLDlg;
import alma.acs.logging.io.IOLogsHelper;
import alma.acs.logging.io.LoadFileChooser;
import alma.acs.logging.io.SaveFileChooser;
import alma.acs.logging.table.LogEntryTableModelBase;
import com.cosylab.logging.LoggingClient;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class LogTableDataModel
extends LogEntryTableModelBase {
    public File currentDir = null;
    private boolean isSuspended = true;
    private IOLogsHelper ioHelper = null;
    private volatile long timeFrame = 0L;

    public final boolean getSuspended() {
        return this.isSuspended;
    }

    public LogTableDataModel(LoggingClient client) throws Exception {
        super(client);
    }

    public void setTimeFrame(long timeframe) {
        if (timeframe < 0L) {
            throw new IllegalArgumentException("Impossible to set the time frame to " + timeframe);
        }
        this.timeFrame = timeframe;
        this.checkTimeFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromURL() {
        LoadURLDlg urlDlg = new LoadURLDlg("http://websqa.hq.eso.org/alma/snapshotRHE/ACS-Reports/TestCoverage-Linux/ACS/LGPL/CommonSoftware/jcont/test/tmp/all_logs.xml", this.loggingClient);
        urlDlg.setVisible(true);
        URL url = urlDlg.getURL();
        if (url == null) {
            return;
        }
        System.out.println("Loading from URL: " + url.toString());
        try {
            this.isSuspended = true;
            this.clearAll();
            this.getIOHelper().loadLogsFromUrl(url, this.loggingClient, this.loggingClient);
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showInternalMessageDialog(this.loggingClient.getContentPane(), "Exception reading " + t.getMessage(), "Error reading " + url.toString(), 0);
        }
        finally {
            this.isSuspended = false;
        }
    }

    public void loadFromFile(String fileName) {
        File f;
        if (fileName == null) {
            String[] filter = new String[]{".gz", ".xml"};
            LoadFileChooser fc = new LoadFileChooser(this.currentDir, "Load", filter, this.loggingClient);
            f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            fileName = f.getAbsolutePath();
            this.currentDir = fc.getCurrentDirectory();
            fc.execute();
        }
        BufferedReader br = null;
        int len = 0;
        try {
            br = this.getIOHelper().getIoHelper().getBufferedReader(fileName);
            f = new File(fileName);
            len = fileName.toLowerCase().endsWith(".gz") ? 0 : (int)f.length();
            this.isSuspended = true;
            this.getIOHelper().loadLogs(br, this.loggingClient, this.loggingClient, len);
        }
        catch (Throwable fnfe) {
            JOptionPane.showInternalMessageDialog(this.loggingClient.getContentPane(), fnfe.getMessage(), "Error opening " + fileName, 0);
        }
    }

    public void saveFile() {
        SaveFileChooser fc = new SaveFileChooser("Save", this.currentDir, this.loggingClient);
        if (fc.getSelectedFile() != null) {
            try {
                Object filename = fc.getSelectedFile().getAbsolutePath();
                this.currentDir = fc.getCurrentDirectory();
                if (fc.mustBeCompressed() && !((String)filename).toLowerCase().endsWith(".gz")) {
                    filename = (String)filename + ".gz";
                } else if (!fc.mustBeCompressed() && !((String)filename).toLowerCase().endsWith(".xml")) {
                    filename = (String)filename + ".xml";
                }
                File fileToSave = new File((String)filename);
                if (fileToSave.exists()) {
                    int act = JOptionPane.showInternalConfirmDialog(this.loggingClient.getContentPane(), "<HTML><BODY><CODE>" + (String)filename + "</CODE> already exists.<BR>Overwrite?");
                    while (act == 1) {
                        fc = new SaveFileChooser("Save", this.currentDir, this.loggingClient);
                        act = JOptionPane.showInternalConfirmDialog(this.loggingClient.getContentPane(), "<HTML><BODY><CODE>" + (String)filename + "</CODE> already exists.<BR>Overwrite?");
                    }
                    if (act == 2) {
                        filename = null;
                        this.isSuspended = false;
                        return;
                    }
                }
                this.isSuspended = true;
                this.saveFile((String)filename, fc.mustBeCompressed(), fc.getCompressionLevel());
            }
            catch (Exception e) {
                System.out.println("Exception " + e.getMessage());
                e.printStackTrace(System.err);
            }
        } else {
            this.isSuspended = false;
        }
    }

    private void saveFile(String fileName, boolean compress, int level) {
        try {
            this.getIOHelper().saveLogs(fileName, compress, level, this.allLogs);
        }
        catch (Exception e) {
            JOptionPane.showInternalMessageDialog(this.loggingClient.getContentPane(), "Exception saving the file: " + e.getMessage(), "Error saving " + fileName, 0);
        }
    }

    public boolean IOInProgress() {
        if (this.ioHelper == null) {
            return false;
        }
        return this.ioHelper.isPerformingIO();
    }

    private IOLogsHelper getIOHelper() throws Exception {
        if (this.ioHelper == null) {
            this.ioHelper = new IOLogsHelper(this.loggingClient);
        }
        return this.ioHelper;
    }

    private void checkTimeFrame() {
        if (this.timeFrame == 0L) {
            return;
        }
        Collection<Integer> logsToDelete = this.allLogs.getLogExceedingTimeFrame(this.timeFrame);
        Collections.sort((List)logsToDelete);
        Collections.reverse((List)logsToDelete);
        if (logsToDelete != null && logsToDelete.size() > 0) {
            for (Integer n : logsToDelete) {
            }
        }
    }

    @Override
    public void close(boolean sync) {
        if (this.ioHelper != null) {
            this.ioHelper.done(sync);
            this.ioHelper = null;
        }
        super.close(sync);
    }

    @Override
    public void start() {
        super.start();
    }

    public int getFieldSortNumber() {
        return 0;
    }

    public boolean sortedAscending() {
        return true;
    }

    public void setSortComparator(int index, boolean ascending) {
    }
}

