/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.AbstractFigure;
import diva.canvas.Site;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorEnd;
import diva.canvas.toolbox.LabelFigure;
import diva.util.java2d.ShapeUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class AbstractConnector
extends AbstractFigure
implements Connector {
    private ConnectorEnd _headEnd = null;
    private ConnectorEnd _tailEnd = null;
    private Site _headSite = null;
    private Site _tailSite = null;
    private LabelFigure _labelFigure;
    private Shape _shape;
    private Stroke _stroke;
    private Paint _paint;

    public AbstractConnector(Site tail, Site head) {
        this._tailSite = tail;
        this._headSite = head;
        this._stroke = ShapeUtilities.getStroke(1);
        this._paint = Color.black;
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = ShapeUtilities.computeStrokedBounds(this._shape, this._stroke);
        if (this._headEnd != null) {
            Rectangle2D.union(bounds, this._headEnd.getBounds(), bounds);
        }
        if (this._tailEnd != null) {
            Rectangle2D.union(bounds, this._tailEnd.getBounds(), bounds);
        }
        if (this._labelFigure != null) {
            Rectangle2D.union(bounds, this._labelFigure.getBounds(), bounds);
        }
        return bounds;
    }

    public float[] getDashArray() {
        if (this._stroke instanceof BasicStroke) {
            return ((BasicStroke)this._stroke).getDashArray();
        }
        return null;
    }

    public ConnectorEnd getHeadEnd() {
        return this._headEnd;
    }

    public Site getHeadSite() {
        return this._headSite;
    }

    public LabelFigure getLabelFigure() {
        return this._labelFigure;
    }

    public float getLineWidth() {
        if (this._stroke instanceof BasicStroke) {
            return ((BasicStroke)this._stroke).getLineWidth();
        }
        return 1.0f;
    }

    public ConnectorEnd getTailEnd() {
        return this._tailEnd;
    }

    public Shape getShape() {
        return this._shape;
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public Paint getStrokePaint() {
        return this._paint;
    }

    public Site getTailSite() {
        return this._tailSite;
    }

    public void headMoved() {
        this.repaint();
        this.reroute();
        this.repaint();
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        boolean hit = ShapeUtilities.intersectsOutline(r, this._shape);
        if (this._labelFigure != null) {
            boolean bl = hit = hit || this._labelFigure.hit(r);
        }
        if (this._headEnd != null) {
            boolean bl = hit = hit || r.intersects(this._headEnd.getBounds());
        }
        if (this._tailEnd != null) {
            hit = hit || r.intersects(this._tailEnd.getBounds());
        }
        return hit;
    }

    public boolean intersects(Rectangle2D r) {
        boolean hit = ShapeUtilities.intersectsOutline(r, this._shape);
        if (this._labelFigure != null) {
            boolean bl = hit = hit || this._labelFigure.intersects(r);
        }
        if (this._headEnd != null) {
            boolean bl = hit = hit || r.intersects(this._headEnd.getBounds());
        }
        if (this._tailEnd != null) {
            hit = hit || r.intersects(this._tailEnd.getBounds());
        }
        return hit;
    }

    public void paint(Graphics2D g) {
        g.setStroke(this._stroke);
        g.setPaint(this._paint);
        g.draw(this._shape);
        if (this._headEnd != null) {
            this._headEnd.paint(g);
        }
        if (this._tailEnd != null) {
            this._tailEnd.paint(g);
        }
        if (this._labelFigure != null) {
            this._labelFigure.paint(g);
        }
    }

    public abstract void repositionLabel();

    public void reroute() {
        this.route();
    }

    public abstract void route();

    public void setDashArray(float[] dashArray) {
        this.repaint();
        this._stroke = this._stroke instanceof BasicStroke ? new BasicStroke(((BasicStroke)this._stroke).getLineWidth(), ((BasicStroke)this._stroke).getEndCap(), ((BasicStroke)this._stroke).getLineJoin(), ((BasicStroke)this._stroke).getMiterLimit(), dashArray, 0.0f) : new BasicStroke(1.0f, 2, 0, 10.0f, dashArray, 0.0f);
        this.repaint();
    }

    public void setHeadEnd(ConnectorEnd e) {
        this.repaint();
        this._headEnd = e;
        this.repaint();
        this.reroute();
    }

    public void setHeadSite(Site s) {
        this._headSite = s;
        this.headMoved();
    }

    public void setLabelFigure(LabelFigure label) {
        this._labelFigure = label;
        this.repositionLabel();
    }

    public void setLineWidth(float lineWidth) {
        this.repaint();
        if (this._stroke instanceof BasicStroke) {
            this._stroke = new BasicStroke(lineWidth, ((BasicStroke)this._stroke).getEndCap(), ((BasicStroke)this._stroke).getLineJoin(), ((BasicStroke)this._stroke).getMiterLimit(), ((BasicStroke)this._stroke).getDashArray(), 0.0f);
        } else {
            new BasicStroke(lineWidth, 2, 0, 10.0f, null, 0.0f);
        }
        this.repaint();
    }

    protected void setShape(Shape s) {
        this._shape = s;
    }

    public void setStroke(Stroke s) {
        this.repaint();
        this._stroke = s;
        this.repaint();
    }

    public void setStrokePaint(Paint p) {
        this.repaint();
        this._paint = p;
        this.repaint();
    }

    public void setTailEnd(ConnectorEnd e) {
        this.repaint();
        this._tailEnd = e;
        this.repaint();
        this.reroute();
    }

    public void setTailSite(Site s) {
        this._tailSite = s;
        this.tailMoved();
    }

    public void tailMoved() {
        this.repaint();
        this.reroute();
        this.repaint();
    }

    public void transform(AffineTransform at) {
    }

    public abstract void translate(double var1, double var3);
}

