/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasComponent;
import diva.canvas.CanvasLayer;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class SwingWrapper
extends AbstractFigure {
    private JComponent _component;

    public SwingWrapper(JComponent c) {
        this.setComponent(c);
    }

    public Rectangle2D getBounds() {
        return this._component.getBounds();
    }

    public JComponent getComponent() {
        return this._component;
    }

    public Shape getShape() {
        return this.getBounds();
    }

    public void paint(Graphics2D g) {
        if (this.isVisible()) {
            this._component.paint(g);
        }
    }

    public void setComponent(JComponent c) {
        this._component = c;
        c.setSize(c.getPreferredSize());
        CanvasLayer layer = this.getLayer();
        if (layer != null) {
            layer.getCanvasPane().getCanvas().add(this._component);
        }
        this.repaint();
    }

    public void setParent(CanvasComponent fc) {
        super.setParent(fc);
        if (this._component.getParent() == null) {
            CanvasLayer layer = this.getLayer();
            layer.getCanvasPane().getCanvas().setLayout(null);
            layer.getCanvasPane().getCanvas().add(this._component);
        }
    }

    public void transform(AffineTransform at) {
        throw new UnsupportedOperationException("FIXME");
    }

    public void translate(double x, double y) {
        this.repaint();
        if (this._component != null) {
            Point p = this._component.getLocation();
            this._component.setLocation(p.x + (int)x, p.y + (int)y);
        }
        this.repaint();
    }
}

