/*
 * Decompiled with CFR 0.152.
 */
package diva.util.xml;

import com.microstar.xml.XmlException;
import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import diva.resource.DefaultBundle;
import diva.util.LoggableOp;
import diva.util.xml.XmlDocument;
import diva.util.xml.XmlElement;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class XmlReader
extends LoggableOp {
    private XmlParser _parser = null;
    private XmlDocument _document = null;
    private XmlElement _root;

    public int getLineNumber() {
        return this._parser.getLineNumber();
    }

    public void parse(XmlDocument document) throws Exception {
        URL url = document.getURL();
        if (url != null) {
            this.parse(document, url, null, null, null, null);
        } else {
            File file = document.getFile();
            if (file == null) {
                throw new XmlException("Document contains no URL or File", "", 0, 0);
            }
            FileReader in = new FileReader(file);
            this.parse(document, in);
        }
    }

    public void parse(XmlDocument document, InputStream in) throws Exception {
        URL url = document.getURL();
        this.parse(document, url, null, null, in, null);
    }

    public void parse(XmlDocument document, Reader in) throws Exception {
        URL url = document.getURL();
        this.parse(document, url, null, in, null, null);
    }

    public String printEntityType(String name) {
        int type = this._parser.getEntityType(name);
        switch (type) {
            case 1: {
                return "ENTITY_INTERNAL";
            }
            case 2: {
                return "ENTITY_NDATA";
            }
            case 3: {
                return "ENTITY_TEXT";
            }
            case 0: {
                return "ENTITY_DECLARED";
            }
        }
        return "Unknown entity type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(XmlDocument document, URL systemId, URL publicId, Reader reader, InputStream stream, String encoding) throws Exception {
        String sysString = systemId != null ? systemId.toString() : "";
        String pubString = publicId != null ? publicId.toString() : "";
        this._document = document;
        this._root = null;
        this._document._parser = this._parser = new XmlParser();
        this.reset();
        try {
            this._parser.setHandler((XmlHandler)new Handler());
            if (reader != null) {
                this._parser.parse(sysString, pubString, reader);
            } else if (stream != null) {
                this._parser.parse(sysString, pubString, stream, encoding);
            } else {
                this._parser.parse(sysString, pubString, encoding);
            }
        }
        finally {
            document.setRoot(this._root);
        }
    }

    public class Handler
    implements XmlHandler {
        private TreeMap _attributes = new TreeMap();
        private XmlElement _currentElement;
        private List _externalEntities = new ArrayList();

        public void attribute(String name, String value, boolean specified) throws Exception {
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.logInfo("attr", name + "=\"" + value + "\" (" + specified + ")");
            }
            if (name == null) {
                XmlReader.this.logError("Attribute has no name");
            } else {
                this._attributes.put(name, value);
            }
        }

        public void charData(char[] c, int offset, int length) throws Exception {
            String s = new String(c, offset, length);
            if (XmlReader.this.isVerbose()) {
                String x = s.length() > 40 ? s.substring(0, 40) + "..." : s;
                XmlReader.this.logInfo("cdata", "[" + offset + "," + length + "] " + x);
            }
            this._currentElement.appendPCData(s);
        }

        public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.logInfo("doctype", name + " \"" + publicId + "\" \"" + systemId + "\"");
            }
            XmlReader.this._document.setDocType(name);
            XmlReader.this._document.setDTDPublicID(publicId);
            XmlReader.this._document.setDTDSystemID(systemId);
        }

        public void endDocument() throws Exception {
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.unindent();
                XmlReader.this.logInfo("end", "");
            }
        }

        public void endElement(String name) throws Exception {
            XmlElement parent;
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.unindent();
                XmlReader.this.logInfo("end", "</" + name + ">");
            }
            this._currentElement = parent = this._currentElement.getParent();
        }

        public void endExternalEntity(String URI2) throws Exception {
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.logInfo("end ext", URI2);
            }
            this._externalEntities.remove(0);
        }

        public void error(String message, String sysid, int line, int column) throws Exception {
            if (sysid != null) {
                XmlReader.this.logError("[" + sysid + "] " + message);
            } else {
                XmlReader.this.logError(message);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws Exception {
        }

        public void processingInstruction(String target, String data) throws Exception {
        }

        public Object resolveEntity(String pubID, String sysID) throws Exception {
            String dtd;
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.logInfo("resolve", "\"" + pubID + "\" \"" + sysID + "\"");
            }
            Object result = sysID;
            if (pubID != null && pubID.equals(XmlReader.this._document.getDTDPublicID()) && (dtd = XmlReader.this._document.getDTD()) != null) {
                return new StringReader(dtd);
            }
            if (pubID != null && !pubID.equals("")) {
                DefaultBundle resources = new DefaultBundle();
                try {
                    InputStream str = resources.getResourceAsStream(pubID);
                    if (str != null) {
                        result = str;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.logInfo("resolve", "=> " + result);
            }
            return result;
        }

        public void startDocument() {
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.logInfo("start", "");
                XmlReader.this.indent();
            }
            this._attributes.clear();
            XmlReader.this._root = null;
        }

        public void startElement(String name) {
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.logInfo("start", "<" + name + "> (" + XmlReader.this.printEntityType(name) + ")");
                XmlReader.this.indent();
            }
            XmlElement e = new XmlElement(name, this._attributes);
            e.setParent(this._currentElement);
            if (this._currentElement == null) {
                XmlReader.this._root = e;
            } else {
                this._currentElement.addElement(e);
            }
            this._currentElement = e;
            this._attributes.clear();
        }

        public void startExternalEntity(String URI2) throws Exception {
            if (XmlReader.this.isVerbose()) {
                XmlReader.this.logInfo("start ext", URI2);
            }
            this._externalEntities.add(0, URI2);
        }

        protected String _currentExternalEntity() {
            return (String)this._externalEntities.get(0);
        }
    }
}

