<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
		
<!--Two significant sets of changes, plus some minor ones.
    Major 1: Change to schemaversioning, modify the top level and the entity
    Major 2: Significant structural changes to the SpectralSpec item for total power work
    Minors: Add uniDirectionalScan to HolographyParameters
-->

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<!-- This forms the basis of the project document transform, ensuring that the information is copied.
     All other templates will override this to do something else -->

<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<!-- Remove SpectralSpec integration time - no longer needed -->
<xsl:template match="id:SpectralSpec/id:integrationTime"></xsl:template>

<!--  Remove rectangle scan velocity - no longer needed -->
  <xsl:template match="id:FieldSource/id:RectanglePattern/id:scanVelocity"></xsl:template>


<xsl:template match="id:SchedBlock">
<SchedBlock xmlns="Alma/ObsPrep/SchedBlock">
  <xsl:attribute name="schemaVersion">8</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="@revision"/></xsl:attribute>
  <xsl:attribute name="xsi:type">SchedBlock</xsl:attribute>
  <xsl:apply-templates select="node()"/> 
  <xsl:comment>Converted to V8 by SchedBlock7-8.xslt</xsl:comment>
</SchedBlock>
</xsl:template>

<xsl:template match="id:SchedBlockEntity">
<SchedBlockEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="schemaVersion">8</xsl:attribute>
</SchedBlockEntity>
</xsl:template>

<!--  Change PHASE_SWITCHING_SEPARATION to PHASE_SWITCH_SEPARATION -->
<xsl:template match="id:SpectralSpec/id:FrequencySetup/id:BaseBandSpecification">
<BaseBandSpecification>
  <xsl:apply-templates select="@entityPartId"/>
  <xsl:apply-templates select="@baseBandName"/>
   <xsl:choose>
      <xsl:when test="./@sideBandSeparationMode = 'PHASE_SWITCHING_SEPARATION'">
         <xsl:attribute name="sideBandSeparationMode">PHASE_SWITCH_SEPARATION</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="@sideBandSeparationMode"/></xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</BaseBandSpecification>
</xsl:template>

<!--  Change cam values from ALMA_whatever to just whatever -->
<xsl:template match="id:SpectralSpec/id:BLCorrelatorConfiguration/id:BLBaseBandConfig">
<BLBaseBandConfig>
  <xsl:apply-templates select="@dataProducts"/>
   <xsl:choose>
      <xsl:when test="./@cAM = 'ALMA_NORMAL'">
         <xsl:attribute name="cAM">NORMAL</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="cAM">FAST</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</BLBaseBandConfig>
</xsl:template>

<!--  Change cam values from ALMA_whatever to just whatever -->
<xsl:template match="id:SpectralSpec/id:ACACorrelatorConfiguration/id:ACABaseBandConfig">
<ACABaseBandConfig>
  <xsl:apply-templates select="@dataProducts"/>
  <xsl:apply-templates select="@polarizationMode"/>
    <xsl:choose>
      <xsl:when test="./@cAM = 'ALMA_NORMAL'">
         <xsl:attribute name="cAM">NORMAL</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="cAM">FAST</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</ACABaseBandConfig>
</xsl:template>

<!-- Replace any aPCDataSets value of AP_MIXED with both -->
<xsl:template match="id:SpectralSpec/id:BLCorrelatorConfiguration">
<BLCorrelatorConfiguration>
   <xsl:choose>
      <xsl:when test="./@aPCDataSets = 'AP_MIXED'">
         <xsl:attribute name="aPCDataSets">AP_CORRECTED+AP_UNCORRECTED</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="aPCDataSets"><xsl:value-of select="@aPCDataSets"/></xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</BLCorrelatorConfiguration>
</xsl:template>

<!-- Replace any aPCDataSets value of AP_MIXED with both -->
<xsl:template match="id:SpectralSpec/id:ACACorrelatorConfiguration">
<ACACorrelatorConfiguration>
   <xsl:choose>
      <xsl:when test="./@aPCDataSets = 'AP_MIXED'">
         <xsl:attribute name="aPCDataSets">AP_CORRECTED+AP_UNCORRECTED</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="aPCDataSets"><xsl:value-of select="@aPCDataSets"/></xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</ACACorrelatorConfiguration>
</xsl:template>

<!-- Ensure dopplercalctype is set in velocities, assume optical -->
  <xsl:template match="id:sourceVelocity">
    <sourceVelocity>
    <xsl:attribute name="dopplerCalcType">OPTICAL</xsl:attribute>
      <xsl:attribute name="referenceSystem"><xsl:value-of select="@referenceSystem"/></xsl:attribute>
    <xsl:apply-templates/>
      </sourceVelocity>
  </xsl:template>

<!--  Change PointCalParameter pointingMethod values -->
<xsl:template match="id:PointingCalParameters">
<PointingCalParameters>
<xsl:apply-templates select="@entityPartId"/>
<xsl:choose>
   <xsl:when test="./@pointingMethod = 'fivepoints'">
      <xsl:attribute name="pointingMethod">FIVE_POINT</xsl:attribute>
   </xsl:when>
   <xsl:when test="./@pointingMethod = 'fourpoints'">
      <xsl:attribute name="pointingMethod">FOUR_POINT</xsl:attribute>
   </xsl:when>
      <xsl:when test="./@pointingMethod = 'threepoints'">
      <xsl:attribute name="pointingMethod">THREE_POINT</xsl:attribute>
   </xsl:when>
      <xsl:when test="./@pointingMethod = 'cross'">
      <xsl:attribute name="pointingMethod">CROSS</xsl:attribute>
   </xsl:when>
   <xsl:otherwise>
      <xsl:attribute name="pointingMethod">CIRCLE</xsl:attribute>
   </xsl:otherwise>
</xsl:choose>
<xsl:apply-templates/>
</PointingCalParameters>
</xsl:template>

<!-- Correct the ObsProjectRef -->
  <xsl:template match="op:ObsProjectRef">
    <ObsProjectRef>
    <xsl:choose>
      <xsl:when test="entity-id">
        <xsl:attribute name="entityId"><xsl:value-of select="entity-id"/></xsl:attribute>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="entity-type-name">
        <xsl:attribute name="entityTypeName"><xsl:value-of select="entity-type-name"/></xsl:attribute>
      </xsl:when>
    </xsl:choose>
    <xsl:attribute name="documentVersion">1</xsl:attribute>
      <!-- Just in case this Ref was correctly formed to start with -->
      <xsl:apply-templates select="./@entityId"></xsl:apply-templates>
      <xsl:apply-templates select="./@entityTypeName"></xsl:apply-templates>
      </ObsProjectRef>
  </xsl:template>
  
<!--  Change format of entitypartids -->
 <xsl:template match="@partId">
   <xsl:attribute name="partId">X<xsl:value-of select="translate(.,'/ ','--')"/>
     </xsl:attribute>
 </xsl:template>
  <xsl:template match="@entityPartId">
    <xsl:attribute name="entityPartId">X<xsl:value-of select="translate(.,'/ ','--')"/>
    </xsl:attribute>
  </xsl:template>
</xsl:stylesheet>
