#*******************************************************************************
# ALMA - Atacama Large Millimeter Array
# Copyright (c) ESO - European Southern Observatory, 2011
# (in the framework of the ALMA collaboration).
# All rights reserved.
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#*******************************************************************************
#!/usr/env/python
#
# This script is designed to standardize the routine observations made
# at the OSF using the Total Power Square Law Detectors.  The
# functionality is as follows:

import Control
import Observation.SchedulingBlock
import sys
from CCL.Global import *
from CCL.ObservingModeBase import SBOutOfTime

# Get the SB and create phaseCal and observingTargets.
sb = Observation.SchedulingBlock.SchedulingBlock()

# Get reference to the array and start the exec block
array = getArray()
array.beginExecution()


if sb.usesCorrelator():
    obsmode = array.getInterferometryObservingMode()
elif sb.usesSquareLawDetector():
    obsmode = array.getSingleDishObservingMode()
else:
    array.endExecution(Control.FAIL,
                       "Mixed Mode Observations not supporte (yet)")
    sys.exit(-1)
    

groupList = sb.getGroupList()


# For each group we want to loop over the targets doing all
# pointing targets first, then all focus, and finally all science targets
for group in groupList:
    for pointingCal in group.getPointingCalTargetList():
        pointingCal.execute(obsmode)
        result = pointingCal.checkResult(array)
        pointingCal.applyResult(obsmode, result)
    for focusCal in group.getFocusCalTargetList():
        focusCal.execute(obsmode)
        result = focusCal.checkResult(array)
        focusCal.applyResult(obsmode, result)
    for scienceTarget in group.getScienceTargetList():
        scienceTarget.execute(obsmode)

array.endExecution(Control.SUCCESS, "AIV TP Detector Script Completed.")
