/*
 * Decompiled with CFR 0.152.
 */
package alma.Control.LOSolutions;

class FreqRange {
    double low;
    double high;

    FreqRange(double low, double high) {
        this.low = low;
        this.high = high;
    }

    FreqRange(double f) {
        this.low = f;
        this.high = f;
    }

    FreqRange() {
        this.low = 1.0E20;
        this.high = 0.0;
    }

    void add(double f) {
        if (f < this.low) {
            this.low = f;
        }
        if (f > this.high) {
            this.high = f;
        }
    }

    boolean isWithin(double f) {
        if (f < this.low) {
            return false;
        }
        return !(f > this.high);
    }

    double span() {
        return this.high - this.low;
    }

    FreqRange intersection(FreqRange other) {
        double low = Math.max(this.low, other.low);
        double high = Math.min(this.high, other.high);
        return new FreqRange(low, high);
    }

    boolean isValidIntersection() {
        return !(this.span() < 0.0);
    }

    public String toString() {
        return this.toString(3);
    }

    public String toString(int precision) {
        String fmt1 = String.format("%%%d.%df", 4 + precision, precision);
        String fmt2 = String.format("[%s, %s]", fmt1, fmt1);
        return String.format(fmt2, this.low * 1.0E-9, this.high * 1.0E-9);
    }
}

