/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.entityutil;

import alma.acs.entityutil.EntityException;
import alma.entities.commonentity.EntityT;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class EntityTFinder {
    private Logger m_logger;
    private boolean m_verbose = false;

    public EntityTFinder(Logger logger) {
        this.m_logger = logger;
    }

    public Method getEntityTMethod(Class entityClass) throws EntityException {
        Method entityTMethod = null;
        try {
            Method[] methods = entityClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType = methods[i].getReturnType();
                if (!EntityT.class.isAssignableFrom(retType)) continue;
                entityTMethod = methods[i];
                break;
            }
        }
        catch (Exception ex) {
            String msg = "failed to extract getter method for child object EntityT from '" + entityClass.getName() + "'.";
            throw new EntityException(msg, ex);
        }
        if (entityTMethod == null) {
            String msg = "Class '" + entityClass.getName() + "' does not have getter method for child object EntityT.";
            throw new EntityException(msg);
        }
        if (this.m_verbose) {
            this.m_logger.finer("entity method '" + entityTMethod.getName() + "' found in class '" + entityClass.getName() + "'.");
        }
        return entityTMethod;
    }

    public EntityT extractEntityT(Object entityObj) throws EntityException {
        Method entityTMethod = this.getEntityTMethod(entityObj.getClass());
        EntityT entityT = null;
        try {
            entityT = (EntityT)entityTMethod.invoke(entityObj, (Object[])null);
        }
        catch (Exception e) {
            String msg = "failed to retrieve EntityT child object from binding class '" + entityObj.getClass() + ".";
            throw new EntityException(msg);
        }
        if (entityT != null) {
            if (this.m_verbose) {
                this.m_logger.finer("EntityT with id='" + entityT.getEntityId() + "' extracted from object of Class '" + entityObj.getClass().getName() + "'.");
            }
        } else {
            this.m_logger.finer("Method " + entityObj.getClass().getName() + "#" + entityTMethod.getName() + " returned null as the " + entityTMethod.getReturnType().getName() + " object");
        }
        return entityT;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }
}

