/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import uk.ac.starlink.util.FileDataSource;

public class TemporaryFileDataSource
extends FileDataSource {
    private File tempFile;

    public TemporaryFileDataSource(InputStream baseStream, String name) throws IOException {
        super(TemporaryFileDataSource.makeTempFile(baseStream, "StreamDataSource", null, null));
        this.setName(name);
    }

    public TemporaryFileDataSource(InputStream baseStream, String name, String prefix, String suffix, File directory) throws IOException {
        super(TemporaryFileDataSource.makeTempFile(baseStream, prefix, suffix, directory));
        this.setName(name);
    }

    public URL getURL() {
        return null;
    }

    public void finalize() {
        this.tempFile.delete();
    }

    private static File makeTempFile(InputStream istrm, String prefix, String suffix, File directory) throws IOException {
        File file = File.createTempFile(prefix, suffix, directory);
        try {
            int n;
            file.deleteOnExit();
            FileOutputStream ostrm = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            while ((n = istrm.read(buf)) >= 0) {
                ((OutputStream)ostrm).write(buf, 0, n);
            }
            istrm.close();
            ((OutputStream)ostrm).close();
            return file;
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
    }
}

