/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.mock;

import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.interfaces.UserManager;
import alma.archive.database.mock.MockSchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import oracle.jdbc.OracleConnection;
import org.apache.commons.io.FileUtils;

public class MockInternalIF
implements InternalIF {
    private static final Logger LOG = Logger.getLogger("MockInternalIf");
    public static final String GENERIC_SCHEMA_UID = "uid://fake_schema_uid/is_not_important/for_tests";
    private final Path tempDir = Path.of(System.getProperty("java.io.tmpdir"), "archive-test-storage-area");

    public MockInternalIF() throws DatabaseException {
        LOG.log(Level.INFO, "archive XML files can be found under {0}", this.tempDir.toAbsolutePath());
    }

    public Path getTemporaryDirectory() {
        return this.tempDir;
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public void close() throws DatabaseException, ModuleCriticalException {
        LOG.fine("close");
    }

    @Override
    public void init() throws DatabaseException, ModuleCriticalException {
        LOG.info("init");
    }

    @Override
    public OracleConnection openConnection() throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(URI uid, String xml, String schemaName, String owner, Permissions permissions, String user, boolean newEntity, OracleConnection conn) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeAll(URI[] uid, String[] xml, String[] schemaName, String[] owner, Permissions[] permissions, String user, boolean[] newEntity) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commit(OracleConnection conn) throws ArchiveException {
        LOG.info("commit");
    }

    @Override
    public String getSchemaOfUid(URI uid) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(URI uid, String xml, URI schema, String schemaName, String owner, Permissions permissions, String user, boolean emitLogs) throws ArchiveException {
        this.store(uid.toString(), xml, schemaName, emitLogs);
    }

    @Override
    public void store(String uid, String xml, String schemaName, boolean emitLogs) throws ArchiveException {
        LOG.log(Level.INFO, "store({}, xml, {}, {}", new Object[]{uid, schemaName, emitLogs});
        try {
            FileUtils.write((File)Paths.get(this.tempDir.toString(), MockInternalIF.sanitise(uid)).toFile(), (CharSequence)xml);
        }
        catch (IOException e) {
            throw new DatabaseException("could not store xml document", e);
        }
    }

    private static String sanitise(String uid) {
        return uid.replaceAll("[:\\/]", "_");
    }

    @Override
    public void storeLog(String message, int level, String attributeValue, String attributeValue2, String attributeValue3, String attributeValue4, String attributeValue5, String attributeValue6, String attributeValue7, String attributeValue8, String attributeValue9, String attributeValue10, String attributeValue11, String attributeValue12, String attributeValue13, String attributeValue14, String attributeValue15, String[] dataStrings, String xml, boolean commit, String steEnv) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(URI uid, ArchiveTimeStamp timeStamp, String xml, URI schema, boolean force, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(URI uid, ArchiveTimeStamp timeStamp, String xml, URI schema, boolean force, String user, OracleConnection conn) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateXML(URI uid, String schema, String newChild) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteElement(URI uid, String schemaName, String xPath, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String get(URI uid, String user) throws ArchiveException {
        LOG.log(Level.INFO, "get({}, {}", new Object[]{uid, user});
        try {
            return FileUtils.readFileToString((File)Paths.get(this.tempDir.toString(), MockInternalIF.sanitise(uid.toString())).toFile());
        }
        catch (IOException e) {
            throw new DatabaseException("failed to read XML", e);
        }
    }

    @Override
    public String get(URI uid, String schema, String user) throws ArchiveException {
        return this.get(uid, "");
    }

    @Override
    public String[] get(URI uid, String xpath, Map<String, String> namespaces, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] get(URI uid, String schema, String xpath, Map<String, String> namespaces, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDirty(URI uid, String user) throws ArchiveException {
        return "0";
    }

    @Override
    public String getDirty(URI uid, String schema, String user) throws ArchiveException {
        return "0";
    }

    @Override
    public void delete(URI uid, String user) throws ArchiveException {
        LOG.log(Level.INFO, "delete({}, {}", new Object[]{uid, user});
        try {
            Files.delete(Paths.get(this.tempDir.toString(), MockInternalIF.sanitise(uid.toString())));
        }
        catch (IOException e) {
            throw new DatabaseException("failed to delete XML", e);
        }
    }

    @Override
    public void delete(URI uid, String schema, String user) throws ArchiveException {
        this.delete(uid, "");
    }

    @Override
    public void undelete(URI uid, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void undelete(URI uid, String schema, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dirty(URI uid, String user) throws ArchiveException {
        LOG.log(Level.INFO, "dirty({}, {}", new Object[]{uid, user});
        LOG.log(Level.WARNING, "this is a no-op.  data cannot be marked as dirty in the mock components");
    }

    @Override
    public void dirty(URI uid, String schema, String user) throws ArchiveException {
        this.dirty(uid, user);
    }

    @Override
    public void clean(URI uid, String user) throws ArchiveException {
        LOG.log(Level.INFO, "clean({}, {}", new Object[]{uid, user});
        LOG.log(Level.WARNING, "this is a no-op.");
    }

    @Override
    public void clean(URI uid, String schema, String user) throws ArchiveException {
        this.clean(uid, user);
    }

    @Override
    public void hidden(URI uid, String user) throws ArchiveException {
        LOG.log(Level.INFO, "hidden({}, {}", new Object[]{uid, user});
        LOG.log(Level.WARNING, "this is a no-op.  data cannot be marked as hidden in the mock components");
    }

    @Override
    public void hidden(URI uid, String schema, String user) throws ArchiveException {
        this.hidden(uid, user);
    }

    @Override
    public void visible(URI uid, String user) throws ArchiveException {
        LOG.log(Level.INFO, "visible({}, {}", new Object[]{uid, user});
        LOG.log(Level.WARNING, "this is a no-op.  data cannot be marked as visible in the mock components");
    }

    @Override
    public void visible(URI uid, String schema, String user) throws ArchiveException {
        this.visible(uid, user);
    }

    @Override
    public void setVirtual(URI uid, String user, boolean virtual) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVirtual(URI uid, String schema, String user, boolean virtual) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentData status(URI uid, String user) throws ArchiveException {
        DocumentData documentData;
        try {
            documentData = new DocumentData(new ArchiveTimeStamp(), new URI(GENERIC_SCHEMA_UID), "ownder", null, false, false, false, false, "admin");
        }
        catch (URISyntaxException e) {
            throw new ArchiveException("failed to create a fake schema URI. This is impossible....");
        }
        return documentData;
    }

    @Override
    public DocumentData status(URI uid, String schema, String user) throws ArchiveException {
        return this.status(uid, user);
    }

    @Override
    public URI[] queryInterval(ArchiveTimeStamp timeFrom, ArchiveTimeStamp timeTo, String schema, String XPathQuery, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI[] queryRecent(ArchiveTimeStamp timestamp, String schema, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayList<String[]> querySubmissions(short fieldID, String searchString, boolean caseSensitive, boolean containsQuery, String piCoiFilter) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBCursor query(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBCursor queryContent(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getLog(String timeFrom, String timeTo, int minType, int maxType, String routine, String source, String process, int maxRow) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI[] queryIDs(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI[] queryIDsAll(String query, String schema, Map<String, String> namespaces, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFlag(URI uid, String flagName, boolean flagValue, String user) throws ArchiveException {
        LOG.log(Level.INFO, "setFlag({}, {}, {}, {}", new Object[]{uid, flagName, flagValue, user});
        LOG.log(Level.WARNING, "this is a no-op.  flags cannot be used in the mock components");
    }

    @Override
    public void setFlag(URI uid, String schema, String flagName, boolean flagValue, String user) throws ArchiveException {
        this.setFlag(uid, flagName, flagValue, user);
    }

    @Override
    public void changeOwner(URI uid, String newOwner, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeOwner(URI uid, String schema, String newOwner, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaManager getSchemaManager(String user) throws ArchiveException {
        return new MockSchemaManager();
    }

    @Override
    public UserManager getUserManager(String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(URI uid, boolean keepHead, String user) throws ArchiveException {
        this.delete(uid, "");
    }

    @Override
    public void remove(URI uid, String schema, String user) throws ArchiveException {
        this.delete(uid, "");
    }

    @Override
    public void setPermission(URI uid, Permissions permissions, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPermission(URI uid, String schema, Permissions permissions, String user) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanTestArea(String user) throws ArchiveException {
        try (Stream<Path> pathStream = Files.walk(this.tempDir, new FileVisitOption[0]);){
            pathStream.filter(f -> !Files.isDirectory(f, new LinkOption[0])).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new DatabaseException("failed to clean the test area", e);
        }
    }

    @Override
    public void notifyConfigChange() throws ArchiveException {
        LOG.warning("notify config cahnges is  a no-op");
    }
}

