/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogFactory;
import jsky.catalog.QueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.gui.CatalogNavigator;
import jsky.catalog.gui.CatalogNavigatorMenuBar;
import jsky.catalog.gui.CatalogNavigatorOpener;
import jsky.catalog.gui.CatalogTreeCellRenderer;
import jsky.util.gui.DialogUtil;

public class CatalogHistoryItem
implements Action,
Serializable {
    private String _urlStr;
    private String _name;
    private String _type;
    private transient JComponent _queryComponent;
    private transient AbstractAction _action;

    public CatalogHistoryItem(String name, URL url, JComponent queryComponent) {
        this._name = name;
        Catalog catalog = CatalogFactory.getCatalogByName((String)name);
        if (catalog != null) {
            this._type = catalog.getType();
        }
        if (url != null) {
            this._urlStr = url.toString();
        }
        this._queryComponent = queryComponent;
        this._initAction();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._initAction();
    }

    private void _initAction() {
        this._action = new AbstractAction(this._name){
            {
                this.putValue("SmallIcon", CatalogHistoryItem.this._getIcon(CatalogHistoryItem.this._type));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CatalogNavigator navigator = CatalogNavigatorMenuBar.getCurrentCatalogNavigator();
                    URL url = null;
                    if (CatalogHistoryItem.this._urlStr != null) {
                        url = new URL(CatalogHistoryItem.this._urlStr);
                    }
                    if (CatalogHistoryItem.this._queryComponent != null) {
                        navigator.setOrigURL(url);
                        navigator.setQueryComponent(CatalogHistoryItem.this._queryComponent);
                    } else if (url != null) {
                        navigator.setQueryResult((QueryResult)new URLQueryResult(url));
                    } else if (navigator instanceof CatalogNavigatorOpener) {
                        ((CatalogNavigatorOpener)((Object)navigator)).openCatalogWindow(CatalogHistoryItem.this._name);
                    } else {
                        DialogUtil.error((String)"Don't know how to display catalog");
                    }
                }
                catch (Exception e) {
                    DialogUtil.error((Exception)e);
                }
            }
        };
    }

    private Icon _getIcon(String type) {
        if (type != null) {
            if (type.equals("catalog")) {
                return CatalogTreeCellRenderer.CATALOG_ICON;
            }
            if (type.equals("archive")) {
                return CatalogTreeCellRenderer.ARCHIVE_ICON;
            }
            if (type.equals("namesvr")) {
                return CatalogTreeCellRenderer.NAME_SERVER_ICON;
            }
            if (type.equals("imagesvr")) {
                return CatalogTreeCellRenderer.IMAGE_SERVER_ICON;
            }
        }
        return CatalogTreeCellRenderer.CATALOG_ICON;
    }

    public String getURLStr() {
        return this._urlStr;
    }

    public URL getUrl() {
        try {
            return this._urlStr == null ? null : new URL(this._urlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getName() {
        return this._name;
    }

    public JComponent getQueryComponent() {
        return this._queryComponent;
    }

    @Override
    public Object getValue(String key) {
        return this._action.getValue(key);
    }

    @Override
    public void putValue(String key, Object value) {
        this._action.putValue(key, value);
    }

    @Override
    public void setEnabled(boolean b) {
        this._action.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this._action.isEnabled();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._action.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._action.removePropertyChangeListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._action.actionPerformed(e);
    }
}

