/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasUtilities;
import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.FigureDecorator;
import diva.util.Filter;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public abstract class AbstractFigureContainer
extends AbstractFigure
implements FigureContainer {
    public void decorate(Figure child, FigureDecorator decorator) {
        if (child.getParent() != this) {
            throw new IllegalArgumentException("The object " + child + " is not a child of " + this);
        }
        child.repaint();
        decorator.setParent(this);
        decorator.setChild(child);
        this.replaceChild(child, decorator);
        decorator.repaint();
    }

    public abstract boolean contains(Figure var1);

    public abstract Iterator figures();

    public abstract Iterator figuresFromBack();

    public abstract Iterator figuresFromFront();

    public abstract int getFigureCount();

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        Iterator i = this.figuresFromBack();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.paint(g);
        }
    }

    public Figure pick(Rectangle2D region) {
        return CanvasUtilities.pick(this.figuresFromFront(), region);
    }

    public Figure pick(Rectangle2D region, Filter filter) {
        return CanvasUtilities.pick(this.figuresFromFront(), region, filter);
    }

    public void repaint(DamageRegion d) {
        if (this.getParent() != null) {
            this.getParent().repaint(d);
        }
    }

    protected abstract void replaceChild(Figure var1, Figure var2);

    public void transform(AffineTransform at) {
        this.repaint();
        Iterator i = this.figures();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.transform(at);
        }
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        Iterator i = this.figures();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.translate(x, y);
        }
        this.repaint();
    }

    public void undecorate(FigureDecorator decorator) {
        if (decorator.getParent() != this) {
            throw new IllegalArgumentException("The object " + decorator + " is not a child of " + this);
        }
        decorator.repaint();
        Figure child = decorator.getChild();
        this.replaceChild(decorator, child);
        decorator.setChild(null);
        decorator.setParent(null);
        child.setParent(this);
        this.repaint();
    }
}

