/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasLayer;
import diva.canvas.CanvasPane;
import diva.canvas.FigureLayer;
import diva.canvas.OverlayLayer;
import diva.canvas.event.EventLayer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GraphicsPane
extends CanvasPane {
    protected CanvasLayer[] _layers;
    protected EventLayer _foregroundEventLayer;
    protected OverlayLayer _overlayLayer;
    protected FigureLayer _foregroundLayer;
    protected CanvasLayer _backgroundLayer;
    protected EventLayer _backgroundEventLayer = new EventLayer();

    public GraphicsPane() {
        this(new FigureLayer());
    }

    public GraphicsPane(FigureLayer foregroundLayer) {
        this._backgroundEventLayer.setEnabled(true);
        this._backgroundLayer = new FigureLayer();
        ((FigureLayer)this._backgroundLayer).setVisible(false);
        ((FigureLayer)this._backgroundLayer).setEnabled(false);
        this._foregroundLayer = foregroundLayer;
        this._overlayLayer = new OverlayLayer();
        this._foregroundEventLayer = new EventLayer();
        this._foregroundEventLayer.setEnabled(false);
        this._initNewLayer(this._backgroundEventLayer);
        this._initNewLayer(this._backgroundLayer);
        this._initNewLayer(this._foregroundLayer);
        this._initNewLayer(this._overlayLayer);
        this._initNewLayer(this._foregroundEventLayer);
        this._rebuildLayerArray();
    }

    public EventLayer getBackgroundEventLayer() {
        return this._backgroundEventLayer;
    }

    public CanvasLayer getBackgroundLayer() {
        return this._backgroundLayer;
    }

    public FigureLayer getForegroundLayer() {
        return this._foregroundLayer;
    }

    public OverlayLayer getOverlayLayer() {
        return this._overlayLayer;
    }

    public EventLayer getForegroundEventLayer() {
        return this._foregroundEventLayer;
    }

    public Iterator layersFromFront() {
        return new Iterator(){
            int cursor = 0;

            public boolean hasNext() {
                return this.cursor < GraphicsPane.this._layers.length;
            }

            public Object next() throws NoSuchElementException {
                if (this.cursor > GraphicsPane.this._layers.length) {
                    throw new NoSuchElementException();
                }
                return GraphicsPane.this._layers[this.cursor++];
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot delete layer from graphics pane");
            }
        };
    }

    public Iterator layersFromBack() {
        return new Iterator(){
            int cursor;
            {
                this.cursor = GraphicsPane.this._layers.length - 1;
            }

            public boolean hasNext() {
                return this.cursor >= 0;
            }

            public Object next() throws NoSuchElementException {
                if (this.cursor < 0) {
                    throw new NoSuchElementException();
                }
                return GraphicsPane.this._layers[this.cursor--];
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot delete layer from graphics pane");
            }
        };
    }

    public void setBackgroundEventLayer(EventLayer l) {
        this._nullifyLayer(this._backgroundEventLayer);
        this._backgroundEventLayer = l;
        this._initNewLayer(l);
        this._rebuildLayerArray();
    }

    public void setBackgroundLayer(CanvasLayer l) {
        this._nullifyLayer(this._backgroundLayer);
        this._backgroundLayer = l;
        this._initNewLayer(l);
        this._rebuildLayerArray();
    }

    public void setForegroundLayer(FigureLayer l) {
        this._nullifyLayer(this._foregroundLayer);
        this._foregroundLayer = l;
        this._initNewLayer(l);
        this._rebuildLayerArray();
    }

    public void setOverlayLayer(OverlayLayer l) {
        this._nullifyLayer(this._overlayLayer);
        this._overlayLayer = l;
        this._initNewLayer(l);
        this._rebuildLayerArray();
    }

    public void setForegroundEventLayer(EventLayer l) {
        this._nullifyLayer(this._foregroundEventLayer);
        this._foregroundEventLayer = l;
        this._initNewLayer(l);
        this._rebuildLayerArray();
    }

    protected void _rebuildLayerArray() {
        this._layers = new CanvasLayer[5];
        int cursor = 0;
        this._layers[cursor++] = this._foregroundEventLayer;
        this._layers[cursor++] = this._overlayLayer;
        this._layers[cursor++] = this._foregroundLayer;
        this._layers[cursor++] = this._backgroundLayer;
        this._layers[cursor++] = this._backgroundEventLayer;
    }
}

