/*
 * Decompiled with CFR 0.152.
 */
package diva.gui.toolbox;

import diva.gui.BasicFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JShadePane
extends JPanel {
    private int _selectedIndex = -1;
    private ArrayList _shades = new ArrayList();

    public void addShade(String title, Component shade) {
        this.addShade(title, null, shade);
    }

    public void addShade(String title, Icon icon, Component shade) {
        this.insertShade(title, icon, shade, null, this.getShadeCount());
    }

    public void addShade(String title, Icon icon, Component shade, String tip) {
        this.insertShade(title, icon, shade, tip, this.getShadeCount());
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getShadeCount() {
        return this._shades.size();
    }

    public String getTitleAt(int index) {
        return ((Shade)this._shades.get((int)index))._button.getText();
    }

    public Icon getIconAt(int index) {
        return ((Shade)this._shades.get((int)index))._button.getIcon();
    }

    public Icon getDisabledIconAt(int index) {
        return ((Shade)this._shades.get((int)index))._button.getDisabledIcon();
    }

    public Color getBackgroundAt(int index) {
        return ((Shade)this._shades.get(index)).getBackground();
    }

    public Color getForegroundAt(int index) {
        return ((Shade)this._shades.get(index)).getForeground();
    }

    public boolean isEnabledAt(int index) {
        return ((Shade)this._shades.get(index)).isEnabled();
    }

    public Component getComponentAt(int index) {
        return ((Shade)this._shades.get((int)index))._component;
    }

    public int indexOfShade(String title) {
        for (int i = 0; i < this.getShadeCount(); ++i) {
            if (!this.getTitleAt(i).equals(title == null ? "" : title)) continue;
            return i;
        }
        return -1;
    }

    public void insertShade(String title, Icon icon, Component component, String tip, int index) {
        if (icon != null && icon instanceof ImageIcon) {
            new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
        JButton button = new JButton(title, icon);
        final String titleHandle = title;
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = JShadePane.this.indexOfShade(titleHandle);
                JShadePane.this.setSelectedIndex(i);
            }
        });
        button.setToolTipText(tip);
        this._shades.add(index, new Shade(this, button, component));
        if (this._shades.size() == 1) {
            this._selectedIndex = 0;
        }
        this.refresh();
    }

    protected void refresh() {
        Shade p;
        int i;
        super.removeAll();
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        for (i = 0; i <= this._selectedIndex; ++i) {
            p = (Shade)this._shades.get(i);
            gbl.setConstraints(p._button, gbc);
            this.add(p._button);
        }
        if (this._selectedIndex >= 0) {
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            Shade p2 = (Shade)this._shades.get(this._selectedIndex);
            gbl.setConstraints(p2._component, gbc);
            this.add(p2._component);
        }
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        for (i = this._selectedIndex + 1; i < this.getShadeCount(); ++i) {
            p = (Shade)this._shades.get(i);
            gbl.setConstraints(p._button, gbc);
            this.add(p._button);
        }
        this.validate();
        this.repaint();
    }

    public void removeAll() {
        this._shades.clear();
        this.setSelectedIndex(-1);
    }

    public void removeShadeAt(int index) {
        this._shades.remove(index);
        int shadeCount = this.getShadeCount();
        if (this.getSelectedIndex() >= shadeCount) {
            this.setSelectedIndex(shadeCount - 1);
        } else {
            this.refresh();
        }
    }

    public void setBackgroundAt(int index, Color background) {
        Shade p = (Shade)this._shades.get(index);
        p._button.setBackground(background);
    }

    public void setDisabledIconAt(int index, Icon icon) {
        Shade p = (Shade)this._shades.get(index);
        p._button.setDisabledIcon(icon);
    }

    public void setEnabledAt(int index, boolean enabled) {
        Shade p = (Shade)this._shades.get(index);
        p._button.setEnabled(enabled);
    }

    public void setForegroundAt(int index, Color foreground) {
        Shade p = (Shade)this._shades.get(index);
        p._button.setForeground(foreground);
    }

    public void setIconAt(int index, Icon icon) {
        Shade p = (Shade)this._shades.get(index);
        p._button.setIcon(icon);
    }

    public void setSelectedIndex(int index) {
        if (index != this._selectedIndex) {
            System.out.println("SELECTING: " + this._selectedIndex);
            this._selectedIndex = index;
        }
        this.refresh();
    }

    public void setTitleAt(int index, String title) {
        Shade p = (Shade)this._shades.get(index);
        p._button.setText(title);
    }

    public static void main(String[] argv) {
        try {
            Runnable doActions = new Runnable(){

                public void run() {
                    try {
                        final JShadePane sp = new JShadePane();
                        sp.addShade("Foo", new JLabel("foo's component"));
                        sp.addShade("Bar", new JLabel("bar's component"));
                        sp.addShade("Baz", new JLabel("baz's component"));
                        sp.addShade("Moo", new JLabel("moo's component"));
                        BasicFrame f = new BasicFrame("Shade test");
                        f.getContentPane().add("Center", sp);
                        JPanel btns = new JPanel();
                        f.getContentPane().add("South", btns);
                        JButton b1 = new JButton("rm sel");
                        b1.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                int i = sp.getSelectedIndex();
                                if (i >= 0) {
                                    sp.removeShadeAt(i);
                                }
                            }
                        });
                        btns.add(b1);
                        JButton b2 = new JButton("rm sel-1");
                        b2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                int i = sp.getSelectedIndex() - 1;
                                if (i >= 0) {
                                    sp.removeShadeAt(i);
                                }
                            }
                        });
                        btns.add(b2);
                        JButton b3 = new JButton("rm sel+1");
                        b3.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                int i = sp.getSelectedIndex() + 1;
                                if (i >= 1 && i < sp.getShadeCount()) {
                                    sp.removeShadeAt(i);
                                }
                            }
                        });
                        btns.add(b3);
                        JButton b4 = new JButton("rm all");
                        b4.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                sp.removeAll();
                            }
                        });
                        btns.add(b4);
                        JButton b5 = new JButton("toggle sel");
                        b5.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                int i = sp.getSelectedIndex();
                                if (i >= 0) {
                                    boolean en = sp.isEnabledAt(i);
                                    sp.setEnabledAt(i, !en);
                                }
                            }
                        });
                        btns.add(b5);
                        JButton b6 = new JButton("toggle sel-1");
                        b6.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                int i = sp.getSelectedIndex() - 1;
                                if (i >= 0) {
                                    boolean en = sp.isEnabledAt(i);
                                    sp.setEnabledAt(i, !en);
                                }
                            }
                        });
                        btns.add(b6);
                        f.setSize(600, 400);
                        ((Window)f).setVisible(true);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                        ex.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
    }

    private static class Shade
    extends AccessibleContext
    implements Serializable,
    Accessible,
    AccessibleComponent {
        JShadePane _parent;
        JButton _button;
        Component _component;

        Shade(JShadePane parent, JButton button, Component component) {
            AccessibleContext ac;
            this._button = button;
            this._parent = parent;
            this.setAccessibleParent(this._parent);
            this._component = component;
            if (this._component instanceof Accessible && (ac = ((Accessible)((Object)this._component)).getAccessibleContext()) != null) {
                ac.setAccessibleParent(this);
            }
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            return this._button.getText();
        }

        public String getAccessibleDescription() {
            return this._button.getToolTipText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = this._parent.getAccessibleContext().getAccessibleStateSet();
            states.add(AccessibleState.SELECTABLE);
            int i = this._parent.indexOfShade(this._button.getText());
            if (i == this._parent.getSelectedIndex()) {
                states.add(AccessibleState.SELECTED);
            }
            return states;
        }

        public int getAccessibleIndexInParent() {
            return this._parent.indexOfShade(this._button.getText());
        }

        public int getAccessibleChildrenCount() {
            return this._component instanceof Accessible ? 1 : 0;
        }

        public Accessible getAccessibleChild(int i) {
            return this._component instanceof Accessible ? (Accessible)((Object)this._component) : null;
        }

        public Locale getLocale() {
            return this._parent.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public void addFocusListener(FocusListener l) {
            throw new UnsupportedOperationException("FIXME");
        }

        public Color getBackground() {
            return this._button.getBackground();
        }

        public void setBackground(Color c) {
            this._button.setBackground(c);
        }

        public Color getForeground() {
            return this._button.getForeground();
        }

        public void setForeground(Color c) {
            this._button.setForeground(c);
        }

        public Cursor getCursor() {
            return this._parent.getCursor();
        }

        public void setCursor(Cursor c) {
            this._parent.setCursor(c);
        }

        public Font getFont() {
            return this._parent.getFont();
        }

        public void setFont(Font f) {
            this._parent.setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return this._parent.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return this._button.isEnabled();
        }

        public void setEnabled(boolean b) {
            this._button.setEnabled(b);
        }

        public boolean isVisible() {
            return this._parent.isVisible();
        }

        public void setVisible(boolean b) {
            this._parent.setVisible(b);
        }

        public boolean isShowing() {
            return this._parent.isShowing();
        }

        public boolean contains(Point p) {
            Rectangle r = this.getBounds();
            return r.contains(p);
        }

        public Point getLocationOnScreen() {
            Point parentLocation = this._parent.getLocationOnScreen();
            Point componentLocation = this.getLocation();
            componentLocation.translate(parentLocation.x, parentLocation.y);
            return componentLocation;
        }

        public Point getLocation() {
            Rectangle r = this.getBounds();
            return new Point(r.x, r.y);
        }

        public void setLocation(Point p) {
            throw new UnsupportedOperationException("FIXME");
        }

        public Rectangle getBounds() {
            return this._button.getBounds();
        }

        public void setBounds(Rectangle r) {
            throw new UnsupportedOperationException("FIXME");
        }

        public Dimension getSize() {
            Rectangle r = this.getBounds();
            return new Dimension(r.width, r.height);
        }

        public void setSize(Dimension d) {
            throw new UnsupportedOperationException("FIXME");
        }

        public Accessible getAccessibleAt(Point p) {
            return this._component instanceof Accessible ? (Accessible)((Object)this._component) : null;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
            throw new UnsupportedOperationException("FIXME");
        }

        public void removeFocusListener(FocusListener l) {
            throw new UnsupportedOperationException("FIXME");
        }
    }
}

