/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.CatalogueStatDao;
import alma.sourcecat.model.CatalogueStat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public final class CatalogueStatDaoImpl
implements CatalogueStatDao {
    private static final String GET_STATS_SQL = "SELECT     catalogue_id, catalogue_name, COALESCE(sources, 0) AS sources,     COALESCE(measurements, 0) AS measurements,     COALESCE(valid, 0) AS valid FROM catalogues LEFT JOIN (     SELECT catalogue_id, count(source_id) AS sources     FROM (         SELECT catalogue_id, source_id         FROM sources         JOIN measurements USING (source_id)         GROUP BY catalogue_id, source_id     )     GROUP BY catalogue_id ) USING (catalogue_id) LEFT JOIN (     SELECT          catalogue_id, count(measurement_id) AS measurements,         count(CASE WHEN valid = 1 THEN 1 ELSE NULL END) AS valid     FROM measurements     GROUP BY catalogue_id ) USING (catalogue_id) ORDER BY catalogue_name";
    private JdbcTemplate jdbcTemplate;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public List<CatalogueStat> cataloguesStat() {
        return this.jdbcTemplate.query(GET_STATS_SQL, (RowMapper)new RowMapper<CatalogueStat>(){

            public CatalogueStat mapRow(ResultSet result, int rowNum) throws SQLException {
                return new CatalogueStat(result.getInt("catalogue_id"), result.getString("catalogue_name"), result.getInt("sources"), result.getInt("measurements"), result.getInt("valid"));
            }
        });
    }
}

