/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class LineSequence {
    private final InputStream in_;
    private final StringBuffer sbuf_;
    private final List readyLines_;

    public LineSequence(InputStream in) {
        this.in_ = in;
        this.sbuf_ = new StringBuffer();
        this.readyLines_ = new ArrayList();
    }

    public String nextLine() throws IOException {
        int v;
        if (this.readyLines_.size() > 0) {
            return (String)this.readyLines_.remove(0);
        }
        this.sbuf_.setLength(0);
        while ((v = this.in_.read()) >= 0) {
            char c = (char)v;
            if (c == '\n') {
                return this.sbuf_.toString();
            }
            this.sbuf_.append(c);
        }
        if (this.sbuf_.length() > 0) {
            return this.sbuf_.toString();
        }
        return null;
    }

    public void replaceLine(String line) {
        this.readyLines_.add(line);
    }
}

