/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import uk.ac.starlink.ttools.plot.AxisLabeller;
import uk.ac.starlink.ttools.plot.Corner;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Plot3D;
import uk.ac.starlink.ttools.plot.Plot3DState;
import uk.ac.starlink.ttools.plot.PlotVolume;

public class CartesianPlot3D
extends Plot3D {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Plot3D.RangeChecker configureRanges(Plot3DState state) {
        this.loBounds_ = new double[3];
        this.hiBounds_ = new double[3];
        this.loBoundsG_ = new double[3];
        this.hiBoundsG_ = new double[3];
        for (int i = 0; i < 3; ++i) {
            double lo = state.getRanges()[i][0];
            double hi = state.getRanges()[i][1];
            this.loBounds_[i] = lo;
            this.hiBounds_[i] = hi;
            boolean log = state.getLogFlags()[i];
            boolean flip = state.getFlipFlags()[i];
            double gLo = log ? Math.log(lo) : lo;
            double gHi = log ? Math.log(hi) : hi;
            this.loBoundsG_[i] = flip ? gHi : gLo;
            this.hiBoundsG_[i] = flip ? gLo : gHi;
        }
        return new Plot3D.RangeChecker(){

            boolean inRange(double[] coords) {
                return coords[0] >= CartesianPlot3D.this.loBounds_[0] && coords[1] >= CartesianPlot3D.this.loBounds_[1] && coords[2] >= CartesianPlot3D.this.loBounds_[2] && coords[0] <= CartesianPlot3D.this.hiBounds_[0] && coords[1] <= CartesianPlot3D.this.hiBounds_[1] && coords[2] <= CartesianPlot3D.this.hiBounds_[2];
            }
        };
    }

    protected double getPadding(Plot3DState state, Graphics g, int[] padBorders) {
        padBorders[0] = 2;
        padBorders[1] = 2;
        padBorders[2] = 2;
        padBorders[3] = 2;
        return Math.sqrt(3.0);
    }

    protected boolean frontOnly(Plot3DState state) {
        return false;
    }

    protected boolean[] get3DLogFlags() {
        return this.getState().getLogFlags();
    }

    protected void plotAxes(Plot3DState state, Graphics g, Plot3D.Transformer3D trans, PlotVolume vol, boolean front) {
        Color col = g.getColor();
        boolean[] flipFlags = this.getState().getFlipFlags();
        for (int i0 = 0; i0 < 8; ++i0) {
            Corner c0 = Corner.getCorner(i0);
            boolean[] flags0 = c0.getFlags();
            Corner[] friends = c0.getAdjacent();
            for (int i1 = 0; i1 < friends.length; ++i1) {
                Corner c1 = friends[i1];
                boolean[] flags1 = c1.getFlags();
                if (c1.compareTo(c0) <= 0) continue;
                double[] mid = new double[3];
                for (int j = 0; j < 3; ++j) {
                    mid[j] = 0.5 * ((flags0[j] ? this.hiBoundsG_[j] : this.loBoundsG_[j]) + (flags1[j] ? this.hiBoundsG_[j] : this.loBoundsG_[j]));
                }
                trans.transform(mid);
                if (mid[2] > 0.5 == front) continue;
                double[] p0 = new double[3];
                double[] p1 = new double[3];
                for (int j = 0; j < 3; ++j) {
                    p0[j] = flags0[j] ^ flipFlags[j] ? this.hiBounds_[j] : this.loBounds_[j];
                    p1[j] = flags1[j] ^ flipFlags[j] ? this.hiBounds_[j] : this.loBounds_[j];
                }
                if (!$assertionsDisabled && c1 == Corner.ORIGIN) {
                    throw new AssertionError();
                }
                if (c0 == Corner.ORIGIN) {
                    this.drawBoxAxis(state, g, trans, vol, p0, p1);
                    continue;
                }
                this.drawBoxLine(state, g, trans, vol, p0, p1);
            }
        }
        g.setColor(col);
    }

    private void drawBoxLine(Plot3DState state, Graphics g, Plot3D.Transformer3D trans, PlotVolume vol, double[] p0, double[] p1) {
        Color col = g.getColor();
        boolean[] logFlags = state.getLogFlags();
        for (int i = 0; i < 3; ++i) {
            if (!logFlags[i]) continue;
            p0[i] = Math.log(p0[i]);
            p1[i] = Math.log(p1[i]);
        }
        trans.transform(p0);
        trans.transform(p1);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(vol.projectX(p0[0]), vol.projectY(p0[1]), vol.projectX(p1[0]), vol.projectY(p1[1]));
        g.setColor(col);
    }

    private void drawBoxAxis(Plot3DState state, Graphics g1, Plot3D.Transformer3D trans, PlotVolume vol, double[] p0, double[] p1) {
        int scale;
        Graphics2D g2 = (Graphics2D)g1.create();
        g2.setColor(Color.BLACK);
        boolean[] logFlags = state.getLogFlags();
        for (int i = 0; i < 3; ++i) {
            if (!logFlags[i]) continue;
            p0[i] = Math.log(p0[i]);
            p1[i] = Math.log(p1[i]);
        }
        double[] d0 = (double[])p0.clone();
        double[] d1 = (double[])p1.clone();
        trans.transform(d0);
        trans.transform(d1);
        int xp0 = vol.projectX(d0[0]);
        int yp0 = vol.projectY(d0[1]);
        int xp1 = vol.projectX(d1[0]);
        int yp1 = vol.projectY(d1[1]);
        g2.drawLine(xp0, yp0, xp1, yp1);
        int iaxis = -1;
        for (int i = 0; i < 3; ++i) {
            if (p0[i] == p1[i]) continue;
            if (!$assertionsDisabled && iaxis != -1) {
                throw new AssertionError();
            }
            iaxis = i;
        }
        if (!($assertionsDisabled || iaxis >= 0 && iaxis < 3)) {
            throw new AssertionError();
        }
        double[] up = Matrices.normalise(Matrices.cross(trans.getDepthVector(), Matrices.unit(iaxis)));
        boolean forward = true;
        int fontHeight = g2.getFontMetrics().getHeight();
        int sx = scale = vol.getScale();
        int sy = fontHeight;
        AffineTransform atf = null;
        int itry = 0;
        while (atf == null) {
            boolean stopFiddling = itry > 5;
            double[] s00 = new double[]{0.0, 0.0};
            double[] s10 = new double[]{sx, 0.0};
            double[] s01 = new double[]{0.0, sy};
            double[] p00 = new double[3];
            double[] p10 = new double[3];
            double[] p01 = new double[3];
            for (int i = 0; i < 3; ++i) {
                p00[i] = forward ? p0[i] : p1[i];
                p10[i] = forward ? p1[i] : p0[i];
                p01[i] = p00[i] + (this.hiBoundsG_[i] - this.loBoundsG_[i]) * (double)fontHeight / (double)scale * up[i];
            }
            trans.transform(p00);
            trans.transform(p10);
            trans.transform(p01);
            int[] a00 = new int[]{vol.projectX(p00[0]), vol.projectY(p00[1])};
            int[] a10 = new int[]{vol.projectX(p10[0]), vol.projectY(p10[1])};
            int[] a01 = new int[]{vol.projectX(p01[0]), vol.projectY(p01[1])};
            if (a01[1] < a00[1] && !stopFiddling) {
                up = Matrices.mult(up, -1.0);
            } else {
                double[] a = new double[]{a00[0], a10[0], a01[0], a00[1], a10[1], a01[1], 1.0, 1.0, 1.0};
                double[] s = new double[]{s00[0], s10[0], s01[0], s00[1], s10[1], s01[1], 1.0, 1.0, 1.0};
                double[] m = Matrices.mmMult(a, Matrices.invert(s));
                double m00 = m[0];
                double m01 = m[1];
                double m02 = m[2];
                double m10 = m[3];
                double m11 = m[4];
                double m12 = m[5];
                if (!$assertionsDisabled && !(Math.abs(m[6] - 0.0) < 1.0E-6)) {
                    throw new AssertionError(m[6]);
                }
                if (!$assertionsDisabled && !(Math.abs(m[7] - 0.0) < 1.0E-6)) {
                    throw new AssertionError(m[7]);
                }
                if (!$assertionsDisabled && !(Math.abs(m[8] - 1.0) < 1.0E-6)) {
                    throw new AssertionError(m[8]);
                }
                if (m00 * m11 - m01 * m10 < 0.0 && !stopFiddling) {
                    forward = !forward;
                } else {
                    atf = new AffineTransform(m00, m10, m01, m11, m02, m12);
                }
            }
            ++itry;
        }
        if (atf.getDeterminant() == 0.0) {
            return;
        }
        g2.transform(atf);
        new AxisLabeller(state.getAxisLabels()[iaxis], this.loBounds_[iaxis], this.hiBounds_[iaxis], sx, logFlags[iaxis], !forward ^ state.getFlipFlags()[iaxis], g2.getFontMetrics(), AxisLabeller.X, 4, 24, 24).annotateAxis(g2);
    }

    static {
        $assertionsDisabled = !CartesianPlot3D.class.desiredAssertionStatus();
    }
}

