/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot.ArrayPlotData;
import uk.ac.starlink.ttools.plot.AxisLabeller;
import uk.ac.starlink.ttools.plot.DataBounds;
import uk.ac.starlink.ttools.plot.GraphSurface;
import uk.ac.starlink.ttools.plot.LinesPlotState;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotEvent;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PointData;
import uk.ac.starlink.ttools.plot.PointIterator;
import uk.ac.starlink.ttools.plot.PointPlacer;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.ScatterPlot;
import uk.ac.starlink.ttools.plot.TablePlot;

public class LinesPlot
extends TablePlot {
    private PlotSurface[] surfaces_ = new PlotSurface[0];
    private PlotData rawData_;
    private PlotData sortedData_;
    private int[] sequence_;
    private Rectangle plotRegion_;
    private int[][] work_ = new int[2][10240];
    private final int axPad_ = 16;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$plot$LinesPlot;

    public void setState(PlotState state) {
        super.setState(state);
        PlotData data = state.getPlotData();
        if (this.sortedData_ == null || !data.equals(this.rawData_)) {
            this.rawData_ = data;
            this.sortedData_ = LinesPlot.sortX(data);
        }
    }

    public PlotSurface[] getSurfaces() {
        return this.surfaces_;
    }

    private void drawData(Graphics g, Component c) {
        GraphSurface graph;
        MarkStyle style;
        int iset;
        LinesPlotState state = (LinesPlotState)this.getState();
        PlotData data = this.sortedData_;
        if (data == null || state == null || !state.getValid()) {
            return;
        }
        boolean grid = state.getGrid();
        boolean xLogFlag = state.getLogFlags()[0];
        boolean xFlipFlag = state.getFlipFlags()[0];
        boolean[] yLogFlags = state.getYLogFlags();
        boolean[] yFlipFlags = state.getYFlipFlags();
        ValueInfo[] yInfos = state.getYAxes();
        int ngraph = yInfos.length;
        double[] xRange = state.getRanges()[0];
        double[][] yRanges = state.getYRanges();
        FontMetrics fm = g.getFontMetrics();
        int height = this.getSize().height;
        int width = this.getSize().width;
        Insets border = this.getInsets();
        ++border.top;
        ++border.right;
        int approxWidth = width - border.left - border.right;
        border.bottom += new AxisLabeller(state.getAxisLabels()[0], xRange[0], xRange[1], approxWidth, state.getLogFlags()[0], state.getFlipFlags()[0], fm, AxisLabeller.X, 10, 16, 16).getAnnotationHeight();
        int yInc = (height - border.bottom - border.top) / ngraph;
        border.top = height - border.bottom - yInc * ngraph;
        GraphSurface[] graphs = new GraphSurface[ngraph];
        AxisLabeller[] yAxes = new AxisLabeller[ngraph];
        for (int igraph = 0; igraph < ngraph; ++igraph) {
            double ylo = yRanges[igraph][0];
            double yhi = yRanges[igraph][1];
            graphs[igraph] = new GraphSurface(this, xLogFlag, yLogFlags[igraph], xFlipFlag, yFlipFlags[igraph]);
            graphs[igraph].setDataRange(xRange[0], ylo, xRange[1], yhi);
            yAxes[igraph] = new AxisLabeller(state.getYAxisLabels()[igraph], ylo, yhi, yInc, yLogFlags[igraph], yFlipFlags[igraph], fm, AxisLabeller.Y, 6, 16, 16);
            int left = yAxes[igraph].getAnnotationHeight();
            border.left = Math.max(border.left, yAxes[igraph].getAnnotationHeight());
        }
        int xInc = width - border.left - border.right;
        int xPos = border.left;
        int yPos = height - border.bottom - yInc;
        AxisLabeller xAxis = new AxisLabeller(state.getAxisLabels()[0], xRange[0], xRange[1], xInc, state.getLogFlags()[0], state.getFlipFlags()[0], fm, AxisLabeller.X, 10, 16, 16);
        for (int igraph = 0; igraph < ngraph; ++igraph) {
            GraphSurface graph2 = graphs[igraph];
            Rectangle displayBox = new Rectangle(xPos, yPos, xInc, yInc);
            graph2.setBounds(displayBox);
            Color textColor = Color.BLACK;
            Color gridColor = Color.LIGHT_GRAY;
            Graphics g1 = g.create();
            graph2.paintSurface(g1);
            g1.setColor(Color.WHITE);
            g1.fillRect(xPos, yPos, xInc, yInc);
            Graphics gx = g1.create();
            gx.translate(xPos, yPos + yInc);
            xAxis.setDrawText(igraph == 0);
            if (grid) {
                gx.setColor(gridColor);
                xAxis.drawGridLines(gx, 0, -yInc);
            }
            gx.setColor(textColor);
            xAxis.annotateAxis(gx);
            gx.dispose();
            Graphics2D gy = (Graphics2D)g1.create();
            gy.translate(xPos, yPos + yInc);
            gy.rotate(-1.5707963267948966);
            if (grid) {
                gy.setColor(gridColor);
                yAxes[igraph].drawGridLines(gy, 0, xInc);
            }
            if (state.getYZeroFlag() && yRanges[igraph][0] < 0.0 && yRanges[igraph][1] > 0.0) {
                gy.setColor(gridColor);
                yAxes[igraph].drawGridLine(gy, 0, xInc, 0.0);
            }
            gy.setColor(textColor);
            yAxes[igraph].annotateAxis(gy);
            gy.dispose();
            g1.setColor(textColor);
            g1.drawRect(xPos, yPos, xInc, yInc);
            g1.dispose();
            yPos -= yInc;
        }
        int[] graphIndices = state.getGraphIndices();
        int nerr = data.getNerror();
        int[] xoffs = new int[nerr];
        int[] yoffs = new int[nerr];
        int nset = data.getSetCount();
        for (iset = 0; iset < nset; ++iset) {
            style = (MarkStyle)data.getSetStyle(iset);
            graph = graphs[graphIndices[iset]];
            boolean noLines = style.getLine() != MarkStyle.DOT_TO_DOT;
            boolean hasErrors = MarkStyle.hasErrors(style, data);
            Rectangle graphClip = graph.getClip().getBounds();
            if (!g.hitClip(graphClip.x, graphClip.y, graphClip.width, graphClip.height)) continue;
            Graphics g1 = g.create();
            g1.clipRect(graphClip.x, graphClip.y, graphClip.width, graphClip.height);
            PointPlotter plotter = new PointPlotter(g1, style, state.getAntialias(), hasErrors, this.work_[0], this.work_[1]);
            PointSequence pseq = data.getPointSequence();
            while (pseq.next()) {
                double[][] errors;
                double[] coords;
                Point point;
                if (!pseq.isIncluded(iset) || (point = graph.dataToGraphics((coords = pseq.getPoint())[0], coords[1], noLines)) == null) continue;
                if (hasErrors && ScatterPlot.transformErrors(point, coords, errors = pseq.getErrors(), graph, xoffs, yoffs)) {
                    plotter.errors(point, xoffs, yoffs);
                }
                plotter.point(point);
            }
            pseq.close();
            plotter.flush();
            plotter.dispose();
            g1.dispose();
        }
        if (data.hasLabels()) {
            for (iset = 0; iset < nset; ++iset) {
                style = (MarkStyle)data.getSetStyle(iset);
                graph = graphs[graphIndices[iset]];
                Rectangle graphClip = graph.getClip().getBounds();
                if (!g.hitClip(graphClip.x, graphClip.y, graphClip.width, graphClip.height)) continue;
                PointSequence pseq = data.getPointSequence();
                while (pseq.next()) {
                    double[] coords;
                    Point point;
                    String label = pseq.getLabel();
                    if (label == null || label.trim().length() <= 0 || !pseq.isIncluded(iset) || (point = graph.dataToGraphics((coords = pseq.getPoint())[0], coords[1], true)) == null) continue;
                    style.drawLabel(g, point.x, point.y, label);
                }
                pseq.close();
            }
        }
        this.surfaces_ = graphs;
        this.plotRegion_ = graphs.length > 0 ? graphs[0].getClip().getBounds() : new Rectangle();
        for (int i = 0; i < graphs.length; ++i) {
            this.plotRegion_.add(graphs[i].getClip().getBounds());
        }
        this.firePlotChangedLater(new PlotEvent(this, state, -1, -1, -1));
    }

    public DataBounds calculateBounds(PlotData data, PlotState state, double[] xLimits) {
        LinesPlotState lState = (LinesPlotState)state;
        int ngraph = lState.getGraphCount();
        int[] graphIndices = lState.getGraphIndices();
        double xlo = xLimits == null ? -1.7976931348623157E308 : xLimits[0];
        double xhi = xLimits == null ? Double.MAX_VALUE : xLimits[1];
        Range xRange = new Range();
        Range[] yRanges = new Range[ngraph];
        for (int ig = 0; ig < ngraph; ++ig) {
            yRanges[ig] = new Range();
        }
        int nset = data.getSetCount();
        int ip = 0;
        int[] npoints = new int[nset];
        PointSequence pseq = data.getPointSequence();
        while (pseq.next()) {
            double[] coords = pseq.getPoint();
            double x = coords[0];
            double y = coords[1];
            if (x >= xlo && x <= xhi) {
                boolean isUsed = false;
                for (int iset = 0; iset < nset; ++iset) {
                    if (!pseq.isIncluded(iset)) continue;
                    int n = iset;
                    npoints[n] = npoints[n] + 1;
                    isUsed = true;
                    int igraph = graphIndices[iset];
                    yRanges[igraph].submit(y);
                }
                if (isUsed) {
                    xRange.submit(x);
                }
            }
            ++ip;
        }
        pseq.close();
        Range[] ranges = new Range[ngraph + 1];
        ranges[0] = xRange;
        System.arraycopy(yRanges, 0, ranges, 1, ngraph);
        return new DataBounds(ranges, ip, npoints);
    }

    public BitSet getPointsInRange() {
        LinesPlotState state = (LinesPlotState)this.getState();
        double xlo = state.getRanges()[0][0];
        double xhi = state.getRanges()[0][1];
        PlotData data = this.rawData_;
        int nset = data.getSetCount();
        BitSet inRange = new BitSet();
        PointSequence pseq = data.getPointSequence();
        int ip = 0;
        while (pseq.next()) {
            double[] coords;
            double x;
            boolean use = false;
            for (int is = 0; is < nset && !use; ++is) {
                use = use || pseq.isIncluded(is);
            }
            if (use && (x = (coords = pseq.getPoint())[0]) >= xlo && x <= xhi) {
                inRange.set(ip);
            }
            ++ip;
        }
        return inRange;
    }

    public PointIterator getPlottedPointIterator() {
        LinesPlotState state = (LinesPlotState)this.getState();
        if (!state.getValid()) {
            return PointIterator.EMPTY;
        }
        final PlotData data = this.rawData_;
        final int nset = data.getSetCount();
        final PlotSurface[] setSurfaces = new PlotSurface[nset];
        int[] graphIndices = state.getGraphIndices();
        for (int iset = 0; iset < nset; ++iset) {
            setSurfaces[iset] = this.surfaces_[graphIndices[iset]];
        }
        return new PointIterator(){
            private int ip_ = -1;
            private int is_ = -1;
            private double[] coords_;
            private PointSequence pseq_ = data.getPointSequence();
            private final int[] point_ = new int[3];

            protected int[] nextPoint() {
                while (this.pseq_ != null) {
                    if (this.coords_ == null) {
                        if (this.pseq_.next()) {
                            this.coords_ = this.pseq_.getPoint();
                            ++this.ip_;
                            this.is_ = -1;
                            continue;
                        }
                        this.pseq_.close();
                        this.pseq_ = null;
                        continue;
                    }
                    if (++this.is_ < nset) {
                        Point xy;
                        if (!this.pseq_.isIncluded(this.is_) || (xy = setSurfaces[this.is_].dataToGraphics(this.coords_[0], this.coords_[1], true)) == null) continue;
                        this.point_[0] = this.ip_;
                        this.point_[1] = xy.x;
                        this.point_[2] = xy.y;
                        return this.point_;
                    }
                    this.coords_ = null;
                }
                return null;
            }
        };
    }

    public PointPlacer[] getPointPlacers() {
        int ngraph = this.surfaces_.length;
        PointPlacer[] placers = new PointPlacer[ngraph];
        for (int igraph = 0; igraph < ngraph; ++igraph) {
            final PlotSurface surface = this.surfaces_[igraph];
            placers[igraph] = new PointPlacer(){

                public Point getXY(double[] coords) {
                    return surface.dataToGraphics(coords[0], coords[1], true);
                }
            };
        }
        return placers;
    }

    public Rectangle getPlotBounds() {
        return this.plotRegion_ == null ? this.getBounds() : this.plotRegion_;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(color);
        }
        this.drawData(g, this);
    }

    private static PlotData sortX(PlotData rawData) {
        boolean sorted = true;
        PointSequence pseq = rawData.getPointSequence();
        int np = 0;
        double lastX = Double.NEGATIVE_INFINITY;
        while (pseq.next()) {
            if (sorted) {
                double x = pseq.getPoint()[0];
                if (x >= lastX) {
                    lastX = x;
                } else {
                    sorted = false;
                }
            }
            ++np;
        }
        pseq.close();
        if (np == 0) {
            return null;
        }
        if (sorted) {
            return rawData;
        }
        ArrayPlotData sortData = ArrayPlotData.copyPlotData(rawData);
        Arrays.sort(sortData.getPoints(), new Comparator(){

            public int compare(Object o1, Object o2) {
                return LinesPlot.compareByX((PointData)o1, (PointData)o2);
            }
        });
        return sortData;
    }

    private static int compareByX(PointData p1, PointData p2) {
        double x2;
        double x1 = p1.getPoint()[0];
        if (x1 < (x2 = p2.getPoint()[0])) {
            return -1;
        }
        if (x1 > x2) {
            return 1;
        }
        return p2.hashCode() - p1.hashCode();
    }

    private static class PointPlotter {
        private final MarkStyle style_;
        private final Graphics pointGraphics_;
        private final Graphics lineGraphics_;
        private final Rectangle pointBounds_;
        private final int huge_;
        private final boolean hasLines_;
        private final boolean hasMarks_;
        private final boolean hasErrors_;
        private int xLo_;
        private int xHi_;
        private Point lastPoint_;
        private boolean lastInclude_;
        private int[] xWork_;
        private int[] yWork_;
        private int nWork_;
        private int iLine_;
        static final /* synthetic */ boolean $assertionsDisabled;

        PointPlotter(Graphics g, MarkStyle style, boolean antialiasLines, boolean hasErrors, int[] work1, int[] work2) {
            this.style_ = style;
            this.xWork_ = work1;
            this.yWork_ = work2;
            this.nWork_ = Math.min(this.xWork_.length, this.yWork_.length);
            this.hasLines_ = style.getLine() == MarkStyle.DOT_TO_DOT;
            this.hasMarks_ = !style.getHidePoints();
            this.hasErrors_ = hasErrors;
            Graphics graphics = this.pointGraphics_ = this.hasMarks_ || this.hasErrors_ ? g.create() : null;
            if (this.hasLines_) {
                this.lineGraphics_ = g.create();
                this.lineGraphics_.setColor(style.getColor());
                if (this.lineGraphics_ instanceof Graphics2D) {
                    Graphics2D lg2 = (Graphics2D)this.lineGraphics_;
                    lg2.setStroke(style.getStroke(0, 1));
                    lg2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasLines ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            } else {
                this.lineGraphics_ = null;
            }
            Rectangle gClip = g.getClipBounds();
            int maxr = style.getMaximumRadius();
            this.pointBounds_ = new Rectangle(gClip.x - maxr, gClip.y - maxr, gClip.width + maxr * 2, gClip.height + maxr * 2);
            this.xLo_ = gClip.x;
            this.xHi_ = gClip.x + gClip.width;
            this.huge_ = Math.max(gClip.height, gClip.width) * 100;
        }

        void point(Point point) {
            if (!point.equals(this.lastPoint_)) {
                if (this.hasMarks_ && this.pointBounds_.contains(point)) {
                    this.style_.drawMarker(this.pointGraphics_, point.x, point.y);
                }
                if (this.hasLines_) {
                    boolean include;
                    boolean bl = include = point.x >= this.xLo_ && point.x <= this.xHi_;
                    if (include && !this.lastInclude_ && this.lastPoint_ != null) {
                        this.addLineVertex(this.lastPoint_.x, this.lastPoint_.y);
                    }
                    if (include || this.lastInclude_) {
                        this.addLineVertex(point.x, point.y);
                    }
                    this.lastInclude_ = include;
                }
                if (!$assertionsDisabled && this.lastPoint_ == point) {
                    throw new AssertionError((Object)"PlotSurface keeps returning same mutable Point object?");
                }
                this.lastPoint_ = point;
            }
        }

        void errors(Point point, int[] xoffs, int[] yoffs) {
            if (this.hasErrors_) {
                this.style_.drawErrors(this.pointGraphics_, point.x, point.y, xoffs, yoffs);
            }
        }

        private void addLineVertex(int x, int y) {
            if (this.iLine_ >= this.nWork_) {
                this.flush();
            }
            x = Math.max(-this.huge_, Math.min(this.huge_, x));
            y = Math.max(-this.huge_, Math.min(this.huge_, y));
            this.xWork_[this.iLine_] = x;
            this.yWork_[this.iLine_] = y;
            ++this.iLine_;
        }

        void flush() {
            if (this.iLine_ > 1) {
                this.lineGraphics_.drawPolyline(this.xWork_, this.yWork_, this.iLine_);
                this.xWork_[0] = this.xWork_[this.iLine_ - 1];
                this.yWork_[0] = this.yWork_[this.iLine_ - 1];
                this.iLine_ = 1;
            }
        }

        void dispose() {
            this.flush();
            if (this.pointGraphics_ != null) {
                this.pointGraphics_.dispose();
            }
            if (this.lineGraphics_ != null) {
                this.lineGraphics_.dispose();
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ttools$plot$LinesPlot == null ? (class$uk$ac$starlink$ttools$plot$LinesPlot = LinesPlot.class$("uk.ac.starlink.ttools.plot.LinesPlot")) : class$uk$ac$starlink$ttools$plot$LinesPlot).desiredAssertionStatus();
        }
    }
}

