/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldFormat;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.util.NameValue;

public class FieldDescAdapter
implements FieldDesc,
Serializable {
    private static final long serialVersionUID = -6640872773507074012L;
    private String _id;
    private String _name;
    private String _displayName;
    private Object _defaultValue;
    private String _description;
    private Class _fieldClass = String.class;
    private boolean _minFlag = false;
    private boolean _maxFlag = false;
    private NameValue[] _options;
    private String _type;
    private String _ucd;
    private String _units;
    private String _format;
    private boolean _idFlag = false;
    private boolean _raFlag = false;
    private boolean _decFlag = false;
    private Boolean _raMainFlag = null;
    private Boolean _decMainFlag = null;

    public FieldDescAdapter() {
    }

    public FieldDescAdapter(String name) {
        this._name = name;
    }

    public void setId(String id) {
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this._displayName != null ? this._displayName : this.getName();
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getUCD() {
        return this._ucd;
    }

    public void setUCD(String ucd) {
        this._ucd = ucd;
    }

    public void setUnits(String units) {
        this._units = units;
    }

    @Override
    public String getUnits() {
        return this._units;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    @Override
    public String getFormat() {
        return this._format;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setFieldClass(Class fieldClass) {
        this._fieldClass = fieldClass;
    }

    @Override
    public Class getFieldClass() {
        return this._fieldClass;
    }

    @Override
    public Object getValue(String s) {
        return FieldFormat.getValue(this, s);
    }

    @Override
    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(Object v) {
        this._defaultValue = v;
    }

    public void setOptions(NameValue[] options) {
        this._options = options;
    }

    @Override
    public int getNumOptions() {
        if (this._options == null) {
            return 0;
        }
        return this._options.length;
    }

    @Override
    public int getDefaultOptionIndex() {
        return 0;
    }

    @Override
    public String getOptionName(int i) {
        if (this._options == null) {
            return null;
        }
        return this._options[i].getName();
    }

    @Override
    public Object getOptionValue(int i) {
        if (this._options == null) {
            return null;
        }
        return this._options[i].getValue();
    }

    @Override
    public boolean isValid(Object value) {
        return true;
    }

    @Override
    public URL getDocURL() {
        return null;
    }

    @Override
    public boolean hasLink() {
        String name = this.getName();
        return name.equals("PREVIEW") || name.equals("MORE");
    }

    @Override
    public String getLinkText(TableQueryResult tableQueryResult, Object value, int row, int column) {
        String name = this.getName();
        if (name.equals("PREVIEW")) {
            return "Preview";
        }
        if (name.equals("MORE")) {
            return "More Info";
        }
        throw new RuntimeException("Bad table link: " + name);
    }

    @Override
    public String getLinkFormat(TableQueryResult tableQueryResult, int row) {
        return null;
    }

    @Override
    public URLQueryResult getLinkValue(TableQueryResult tableQueryResult, Object value, int row) throws MalformedURLException {
        if (value instanceof String) {
            String s = (String)value;
            if (s.startsWith("M=") || s.startsWith("P=")) {
                s = s.substring(2);
            }
            return new URLQueryResult(new URL(s));
        }
        throw new RuntimeException("Invalid table link: " + value);
    }

    @Override
    public boolean isId() {
        return this._idFlag;
    }

    public void setIsId(boolean flag) {
        this._idFlag = flag;
    }

    @Override
    public boolean isRA() {
        return this._raFlag || this._raMainFlag != null && this._raMainFlag != false;
    }

    public void setIsRA(boolean flag) {
        this._raFlag = flag;
    }

    @Override
    public boolean isDec() {
        return this._decFlag || this._decMainFlag != null && this._decMainFlag != false;
    }

    public void setIsDec(boolean flag) {
        this._decFlag = flag;
    }

    @Override
    public boolean isDecMain() {
        return this._decMainFlag != null ? this._decMainFlag : this._decFlag;
    }

    public void setIsDecMain(boolean flag) {
        this._decMainFlag = flag;
    }

    @Override
    public boolean isRaMain() {
        return this._raMainFlag != null ? this._raMainFlag : this._raFlag;
    }

    public void setIsRAMain(boolean flag) {
        this._raMainFlag = flag;
    }

    @Override
    public boolean isMin() {
        return this._minFlag;
    }

    public void setIsMin(boolean b) {
        this._minFlag = b;
    }

    @Override
    public boolean isMax() {
        return this._maxFlag;
    }

    public void setIsMax(boolean b) {
        this._maxFlag = b;
    }
}

