/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import jsky.catalog.FieldDesc;
import jsky.catalog.ValueRange;
import jsky.coords.DMS;
import jsky.coords.HMS;
import jsky.util.StringUtil;
import jsky.util.gui.DialogUtil;

public class FieldFormat {
    public static Object getValue(FieldDesc fieldDesc, String s) {
        Class c = fieldDesc.getFieldClass();
        s = s.trim();
        if (c == String.class) {
            return s;
        }
        if (s.equals("")) {
            return null;
        }
        if (c == Double.class || c == Float.class) {
            if (fieldDesc.isRA()) {
                HMS hms = new HMS(s);
                if (c == Double.class) {
                    return hms.getVal();
                }
                return new Float(hms.getVal());
            }
            if (fieldDesc.isDec()) {
                DMS dms = new DMS(s);
                if (c == Double.class) {
                    return dms.getVal();
                }
                return new Float(dms.getVal());
            }
        }
        try {
            if (c == Double.class) {
                return new Double(s);
            }
            if (c == Float.class) {
                return new Float(s);
            }
            if (c == Integer.class) {
                return new Integer(s);
            }
            if (c == Boolean.class) {
                return Boolean.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            DialogUtil.error((String)("Invalid query syntax: " + s + ", expected a single value"));
        }
        return null;
    }

    public static ValueRange getValueRange(FieldDesc fieldDesc, String s) {
        Class c = fieldDesc.getFieldClass();
        s = s.trim();
        if (c == String.class) {
            return new ValueRange((Comparable)((Object)s));
        }
        String[] ar = StringUtil.split((String)s, (int)32);
        boolean oneVal = false;
        if (ar == null) {
            ar = new String[2];
            ar[0] = ar[1] = s;
            oneVal = true;
        }
        boolean[] inclusive = new boolean[2];
        boolean insertMin = false;
        boolean insertMax = false;
        for (int i = 0; i < 2; ++i) {
            inclusive[i] = true;
            if (ar[i].startsWith(">")) {
                if (ar[i].startsWith(">=")) {
                    ar[i] = ar[i].substring(2);
                } else {
                    inclusive[i] = false;
                    ar[i] = ar[i].substring(1);
                }
                if (!oneVal) continue;
                insertMax = true;
                break;
            }
            if (!ar[i].startsWith("<")) continue;
            if (ar[i].startsWith("<=")) {
                ar[i] = ar[i].substring(2);
            } else {
                inclusive[i] = false;
                ar[i] = ar[i].substring(1);
            }
            if (!oneVal) continue;
            insertMin = true;
            ar[1] = ar[0];
            break;
        }
        try {
            if (c == Double.class) {
                if (insertMin) {
                    ar[0] = Double.toString(Double.MIN_VALUE);
                } else if (insertMax) {
                    ar[1] = Double.toString(Double.MAX_VALUE);
                }
                return new ValueRange(new Double(ar[0]), inclusive[0], new Double(ar[1]), inclusive[1]);
            }
            if (c == Float.class) {
                if (insertMin) {
                    ar[0] = Float.toString(Float.MIN_VALUE);
                } else if (insertMax) {
                    ar[1] = Float.toString(Float.MAX_VALUE);
                }
                return new ValueRange(new Float(ar[0]), inclusive[0], new Float(ar[1]), inclusive[1]);
            }
            if (c == Integer.class) {
                if (insertMin) {
                    ar[0] = Integer.toString(Integer.MIN_VALUE);
                } else if (insertMax) {
                    ar[1] = Integer.toString(Integer.MAX_VALUE);
                }
                return new ValueRange(new Integer(ar[0]), inclusive[0], new Integer(ar[1]), inclusive[1]);
            }
        }
        catch (NumberFormatException e) {
            DialogUtil.error((String)("Invalid query syntax: " + s + ", expected: a value or value range expression (min max, >min, <=max, ...)"));
        }
        return null;
    }
}

