/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.gui;

import alma.acs.commandcenter.app.ProjectRunModel;
import alma.acs.commandcenter.engine.Executor;
import alma.acs.commandcenter.gui.CommandCenterGui;
import alma.acs.commandcenter.gui.thirdparty.SpringUtilities;
import alma.acs.commandcenter.trace.DefaultChecklistPanel;
import alma.acs.commandcenter.trace.Flow;
import alma.acs.commandcenter.trace.FlowListener;
import alma.entity.xmlbinding.acscommandcenterproject.ContainerT;
import alma.entity.xmlbinding.acscommandcenterproject.ContainersT;
import alma.entity.xmlbinding.acscommandcenterproject.types.ModeType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class TabPanel
extends JPanel {
    CommandCenterGui master;
    DefaultChecklistPanel remoteFlowPanel;
    DefaultChecklistPanel localJavaFlowPanel;
    DefaultChecklistPanel localScriptFlowPanel;
    DefaultChecklistPanel singleStepFlowPanel;
    DefaultChecklistPanel remoteServicesDaemonFlowPanel;
    DefaultChecklistPanel remoteContainerDaemonFlowPanel;
    CommandCenterGui.BackgroundAction actStartAcs;
    CommandCenterGui.BackgroundAction actStopAcs;
    CommandCenterGui.BackgroundAction actKillAcs;
    CommandCenterGui.BackgroundAction actStartServices;
    CommandCenterGui.BackgroundAction actStopServices;
    CommandCenterGui.BackgroundAction actStartManager;
    CommandCenterGui.BackgroundAction actStopManager;
    CommandCenterGui.BackgroundAction actShowAdvanced;
    CommandCenterGui.BackgroundAction actStartContainer;
    CommandCenterGui.BackgroundAction actStopContainer;
    CommandCenterGui.BackgroundAction actConfigureContainer;
    CommandCenterGui.BackgroundAction actStartAllContainers;
    CommandCenterGui.BackgroundAction actStopAllContainers;
    FlowDialog flowDialog;
    FixSizeScrollPane scp;
    JPanel controlsPanel;
    JPanel buttonPanel;
    JPanel panelAdvanced;
    JPanel buttonPanelAdvanced;
    JToggleButton btnShowAdvanced;
    JButton btnStartServices;
    JButton btnStopServices;
    JButton btnStartManager;
    JButton btnStopManager;
    JButton btnKillAcs;
    JButton btnStopAcs;
    JButton btnStartAcs;
    JButton btnStartAllContainers;
    JButton btnStopAllContainers;
    JButton btnMoreContainers;
    JButton btnLessContainers;
    JButton btnContainersAgainstManager;
    JButton btnMoveContainerUp;
    JButton btnMoveContainerDown;
    MyRadioButton chkLocalScript = new MyRadioButton("Localhost (single-machine project)");
    MyRadioButton chkRemoteScript = new MyRadioButton("Remote (distributed project)");
    MyRadioButton chkRemoteBuiltin = new MyRadioButton("Use built-in ssh");
    MyRadioButton chkRemoteDaemons = new MyRadioButton("Use Acs Daemons");
    MyRadioButton chkRemoteNative = new MyRadioButton("Use native ssh");
    JPanel containerPanel;
    JPanel containerLinePanel;
    ButtonGroup buttonGroup1 = new ButtonGroup();
    ButtonGroup buttonGroup3 = new ButtonGroup();
    ButtonGroup buttonGroup2 = new ButtonGroup();
    JLabel acsinstanceL;
    JLabel hostL;
    JLabel accountL;
    JLabel passwordL;
    JLabel cdbrootL;
    JLabel lblF;
    JLabel lblG;
    JTextField acsinstanceF = new JTextField(5);
    JTextField hostF = new JTextField(20);
    JTextField accountF = new JTextField(10);
    JTextField passwordF = new JPasswordField(10);
    JTextField cdbrootF = new JTextField(20);
    FocusListener focusListener = new MyFocusListener();
    protected Disenabler disenabler;
    protected Vector<ContainerLine> containerLines = new Vector();
    protected Vector<ButtonPair> buttonPairs = new Vector();

    protected TabPanel(CommandCenterGui master) {
        this.master = master;
        this.flowDialog = new FlowDialog();
        Icon okIcon = master.icons.getOkIcon();
        Icon errIcon = master.icons.getErrIcon();
        this.remoteFlowPanel = new DefaultChecklistPanel(Executor.remoteFlow, null, null, null, okIcon, null, errIcon);
        this.localJavaFlowPanel = new DefaultChecklistPanel(Executor.localInProcFlow, null, null, null, okIcon, null, errIcon);
        this.localScriptFlowPanel = new DefaultChecklistPanel(Executor.localOutProcFlow, null, null, null, okIcon, null, errIcon);
        this.singleStepFlowPanel = new DefaultChecklistPanel(Executor.singleStepFlow, null, null, null, okIcon, null, errIcon);
        this.remoteServicesDaemonFlowPanel = new DefaultChecklistPanel(Executor.remoteServicesDaemonFlow, null, null, null, okIcon, null, errIcon);
        this.remoteContainerDaemonFlowPanel = new DefaultChecklistPanel(Executor.remoteContainerDaemonFlow, null, null, null, okIcon, null, errIcon);
        this.init();
    }

    protected void init() {
        this.buttonGroup1.add(this.chkLocalScript);
        this.buttonGroup1.add(this.chkRemoteScript);
        this.chkLocalScript.setToolTipText("Run all of Acs on a single machine (localhost)");
        this.chkRemoteScript.setToolTipText("Run a distributed Acs on multiple hosts");
        this.chkLocalScript.setName("chk_Local");
        this.chkRemoteScript.setName("chk_Remote");
        this.chkLocalScript.setMnemonic(76);
        this.chkRemoteScript.setMnemonic(82);
        this.btnMoreContainers = new JButton(new ActionMoreContainers());
        this.btnLessContainers = new JButton(new ActionLessContainers());
        this.btnContainersAgainstManager = new JButton(new ActionConfigureAllContainers());
        this.btnMoveContainerUp = new JButton(new ActionMoveContainerUp());
        this.btnMoveContainerDown = new JButton(new ActionMoveContainerDown());
        Insets margin = new Insets(1, 0, 1, 0);
        this.btnMoreContainers.setMargin(margin);
        this.btnLessContainers.setMargin(margin);
        this.btnContainersAgainstManager.setMargin(margin);
        this.btnMoveContainerUp.setMargin(margin);
        this.btnMoveContainerDown.setMargin(margin);
        this.setLayout(new BorderLayout());
        JPanel generalTab = new JPanel(new BorderLayout());
        JPanel n = new JPanel(new SpringLayout());
        this.acsinstanceL = new JLabel("Acs Instance");
        n.add(this.acsinstanceL);
        n.add(this.acsinstanceF);
        this.acsinstanceL.setLabelFor(this.acsinstanceF);
        this.acsinstanceF.addFocusListener(this.focusListener);
        this.acsinstanceF.setToolTipText("The desired Acs instance between 0 and 9)");
        this.acsinstanceL.setDisplayedMnemonic(73);
        this.cdbrootL = new JLabel("Cdb Root Dir");
        n.add(this.cdbrootL);
        n.add(this.cdbrootF);
        this.cdbrootL.setLabelFor(this.cdbrootF);
        this.cdbrootF.addFocusListener(this.focusListener);
        this.cdbrootL.setToolTipText("The Cdb describing all components");
        SpringUtilities.makeCompactGrid(n, 2, 0);
        generalTab.add(n);
        this.acsinstanceF.setName("txt_AcsInstance");
        this.cdbrootF.setName("txt_CdbRoot");
        JPanel localScriptTab = new JPanel(new BorderLayout());
        JPanel h = new JPanel(new BorderLayout());
        h.add((Component)this.chkLocalScript, "North");
        this.chkLocalScript.addFocusListener(this.focusListener);
        localScriptTab.add(h);
        JPanel remoteTab = new JPanel(new BorderLayout());
        JPanel j = new JPanel(new BorderLayout());
        j.add((Component)this.chkRemoteScript, "North");
        JPanel k = new JPanel(new GridBagLayout());
        this.buttonGroup3.add(this.chkRemoteBuiltin);
        this.buttonGroup3.add(this.chkRemoteNative);
        this.buttonGroup3.add(this.chkRemoteDaemons);
        this.chkRemoteBuiltin.setToolTipText("Run Acs using built-in ssh client");
        k.add((Component)this.chkRemoteBuiltin, this.gridbagpos(0, 0).width(2).gapy(1));
        this.chkRemoteNative.setToolTipText("Run Acs using the local ssh program");
        k.add((Component)this.chkRemoteNative, this.gridbagpos(0, 2).width(2).gapy(1));
        this.chkRemoteDaemons.setToolTipText("Run Acs using Daemons");
        k.add((Component)this.chkRemoteDaemons, this.gridbagpos(1, 0).width(2).gapy(1));
        this.hostL = new JLabel("Host");
        k.add((Component)this.hostL, this.gridbagpos(2, 0));
        k.add((Component)this.hostF, this.gridbagpos(2, 1).width(3));
        this.chkRemoteScript.addFocusListener(this.focusListener);
        this.chkRemoteBuiltin.addFocusListener(this.focusListener);
        this.chkRemoteNative.addFocusListener(this.focusListener);
        this.chkRemoteDaemons.addFocusListener(this.focusListener);
        this.hostF.addFocusListener(this.focusListener);
        this.accountL = new JLabel("User");
        k.add((Component)this.accountL, this.gridbagpos(3, 0));
        k.add((Component)this.accountF, this.gridbagpos(3, 1));
        this.accountL.setLabelFor(this.accountF);
        this.accountF.addFocusListener(this.focusListener);
        this.passwordL = new JLabel("Pwd");
        k.add((Component)this.passwordL, this.gridbagpos(3, 2));
        k.add((Component)this.passwordF, this.gridbagpos(3, 3).weightx(0.2));
        this.passwordL.setLabelFor(this.passwordF);
        this.passwordF.addFocusListener(this.focusListener);
        k.setBorder(new EmptyBorder(0, 30, 0, 5));
        j.add((Component)k, "Center");
        remoteTab.add(j);
        this.hostF.setName("txt_RemoteHost");
        this.accountF.setName("txt_RemoteUser");
        this.passwordF.setName("txt_RemotePassword");
        this.actStartContainer = new ActionStartContainer();
        this.actStopContainer = new ActionStopContainer();
        this.actConfigureContainer = new ActionConfigureContainer();
        this.actStartAcs = new ActionStartAcs();
        this.btnStartAcs = new JButton(this.actStartAcs);
        this.actStopAcs = new ActionStopAcs();
        this.btnStopAcs = new JButton(this.actStopAcs);
        this.actKillAcs = new ActionKillAcs();
        this.btnKillAcs = new JButton(this.actKillAcs);
        this.actStartServices = new ActionStartServices();
        this.btnStartServices = new JButton(this.actStartServices);
        this.actStopServices = new ActionStopServices();
        this.btnStopServices = new JButton(this.actStopServices);
        this.actStartManager = new ActionStartManager();
        this.btnStartManager = new JButton(this.actStartManager);
        this.actStopManager = new ActionStopManager();
        this.btnStopManager = new JButton(this.actStopManager);
        this.actShowAdvanced = new ActionShowAdvanced();
        this.btnShowAdvanced = new MyCheckBox(this.actShowAdvanced);
        this.actStartAllContainers = new ActionStartAllContainers();
        this.btnStartAllContainers = new JButton(this.actStartAllContainers);
        this.actStopAllContainers = new ActionStopAllContainers();
        this.btnStopAllContainers = new JButton(this.actStopAllContainers);
        this.btnStartServices.setToolTipText("Start Services with the specified Common Settings");
        this.btnStopServices.setToolTipText("Stop the specified Services");
        this.btnStartManager.setToolTipText("Start a Manager with the specified Common Settings");
        this.btnStopManager.setToolTipText("Stop the specified Manager");
        this.btnStopAcs.setToolTipText("Stop Services and Manager AND Containers");
        this.btnKillAcs.setToolTipText("Terminate Everything related to Acs");
        this.btnStartAcs.setToolTipText("Start Services and Manager with the specified Common Settings");
        this.btnShowAdvanced.setToolTipText("Enable/Disable Advanced Controls");
        this.btnStartServices.setName("btn_Start_Services");
        this.btnStopServices.setName("btn_Stop_Services");
        this.btnStartManager.setName("btn_Start_Manager");
        this.btnStopManager.setName("btn_Stop_Manager");
        this.btnStopAcs.setName("btn_Stop_Acs");
        this.btnKillAcs.setName("btn_Kill_Acs");
        this.btnStartAcs.setName("btn_Start_Acs");
        this.btnShowAdvanced.setName("btn_Show_Advanced");
        this.btnStartAcs.setMnemonic(65);
        this.btnStopAcs.setMnemonic(83);
        this.btnKillAcs.setMnemonic(75);
        this.btnShowAdvanced.setMnemonic(86);
        margin = new Insets(1, 1, 1, 1);
        this.btnStartServices.setMargin(margin);
        this.btnStopServices.setMargin(margin);
        this.btnStartManager.setMargin(margin);
        this.btnStopManager.setMargin(margin);
        this.btnShowAdvanced.setMargin(margin);
        margin = new Insets(1, 3, 1, 3);
        this.btnStartAllContainers.setMargin(margin);
        this.btnStopAllContainers.setMargin(margin);
        this.controlsPanel = new JPanel();
        this.controlsPanel.setBorder(this.master.createTitledBorder(" Acs Suite "));
        this.buttonPanel = new JPanel(new SpringLayout());
        this.buttonPanel.add(this.btnStartAcs);
        this.flowDialog.disenable(this.btnStartAcs);
        this.buttonPanel.add(this.btnStopAcs);
        this.flowDialog.disenable(this.btnStopAcs);
        this.buttonPanel.add(Box.createVerticalStrut(1));
        this.buttonPanel.add(new FixSizeSeparator(0, new Dimension(10, 3)));
        this.buttonPanel.add(this.btnKillAcs);
        this.flowDialog.disenable(this.btnKillAcs);
        this.buttonPanel.add(this.btnShowAdvanced);
        this.flowDialog.disenable(this.btnShowAdvanced);
        SpringUtilities.makeCompactGrid(this.buttonPanel, 0, 1);
        this.panelAdvanced = new JPanel(new BorderLayout());
        this.buttonPanelAdvanced = new JPanel(new SpringLayout());
        this.buttonPanelAdvanced.add(new JLabel("Srv"));
        this.buttonPanelAdvanced.add(this.btnStartServices);
        this.flowDialog.disenable(this.btnStartServices);
        this.buttonPanelAdvanced.add(this.btnStopServices);
        this.flowDialog.disenable(this.btnStopServices);
        this.buttonPanelAdvanced.add(new JLabel("Mgr"));
        this.buttonPanelAdvanced.add(this.btnStartManager);
        this.flowDialog.disenable(this.btnStartManager);
        this.buttonPanelAdvanced.add(this.btnStopManager);
        this.flowDialog.disenable(this.btnStopManager);
        SpringUtilities.makeCompactGrid(this.buttonPanelAdvanced, 2, 0);
        this.panelAdvanced.add((Component)this.buttonPanelAdvanced, "Center");
        this.controlsPanel.setLayout(new BoxLayout(this.controlsPanel, 1));
        this.controlsPanel.add(this.buttonPanel);
        this.controlsPanel.add(this.panelAdvanced);
        this.makeButtonPair(this.btnStartAcs, this.btnStopAcs);
        this.makeButtonPair(this.btnStartServices, this.btnStopServices);
        this.makeButtonPair(this.btnStartManager, this.btnStopManager);
        this.containerPanel = new JPanel(new BorderLayout());
        this.containerPanel.setBorder(this.master.createTitledBorder(" Containers "));
        JPanel a = new JPanel(new GridLayout(1, 0));
        a.add(new JLabel("Name", 0));
        a.add(new JLabel("Type", 0));
        a.add(new JLabel("Remote Host", 0));
        a.add(new JLabel());
        this.containerPanel.add((Component)a, "North");
        this.containerLinePanel = new JPanel();
        JPanel q = new JPanel(new SpringLayout());
        JPanel scpRoot = new JPanel(new BorderLayout());
        this.containerLinePanel.setLayout(new GridLayout(0, 1));
        scpRoot.add((Component)this.containerLinePanel, "North");
        q.add(scpRoot);
        SpringUtilities.makeCompactGrid(q, 1, 1);
        this.scp = new FixSizeScrollPane(q, 22, 31);
        this.containerPanel.add((Component)this.scp, "Center");
        ContainerLine filler = new ContainerLine();
        this.scp.validate();
        int scrollbarWidth = 25;
        int nLines = 5;
        this.scp.freezeSize(filler.getPreferredSize().width + scrollbarWidth, (filler.getPreferredSize().height + 2) * nLines + 2);
        this.btnMoreContainers.setToolTipText("More Containers");
        this.btnLessContainers.setToolTipText("Less Containers (removes Last from List)");
        this.btnContainersAgainstManager.setToolTipText("Choose Manager and Services to Run Containers Against");
        this.btnMoveContainerUp.setToolTipText("Move Selected Container Up in List");
        this.btnMoveContainerDown.setToolTipText("Move Selected Container Down in List");
        this.btnStartAllContainers.setToolTipText("Start all Containers");
        this.btnStopAllContainers.setToolTipText("Stop all Containers");
        this.btnMoreContainers.setName("btn_More_Containers");
        this.btnLessContainers.setName("btn_Less_Containers");
        this.btnContainersAgainstManager.setName("btn_Containers_Against_Manager");
        this.btnMoveContainerUp.setName("btn_Move_Container_Up");
        this.btnMoveContainerDown.setName("btn_Move_Container_Down");
        this.btnStartAllContainers.setName("btn_Start_All_Containers");
        this.btnStopAllContainers.setName("btn_Stop_All_Containers");
        this.btnMoreContainers.setMnemonic(40);
        this.btnLessContainers.setMnemonic(38);
        this.btnContainersAgainstManager.setMnemonic(67);
        this.makeButtonPair(this.btnStartAllContainers, this.btnStopAllContainers);
        this.flowDialog.disenable(this.btnLessContainers);
        this.flowDialog.disenable(this.btnStartAllContainers);
        this.flowDialog.disenable(this.btnStopAllContainers);
        this.flowDialog.disenable(this.btnMoveContainerUp);
        this.flowDialog.disenable(this.btnMoveContainerDown);
        this.flowDialog.disenable(this.btnContainersAgainstManager);
        JPanel southwest = new JPanel();
        southwest.setLayout(new SpringLayout());
        southwest.add(this.btnMoreContainers);
        southwest.add(this.btnLessContainers);
        southwest.add(this.btnMoveContainerUp);
        southwest.add(this.btnMoveContainerDown);
        southwest.add(new FixSizeSeparator(1, new Dimension(4, 10)));
        southwest.add(this.btnContainersAgainstManager);
        SpringUtilities.makeCompactGrid(southwest, 1, 0);
        JPanel southeast = new JPanel(new SpringLayout());
        southeast.add(this.btnStartAllContainers);
        southeast.add(this.btnStopAllContainers);
        SpringUtilities.makeCompactGrid(southeast, 1, 0);
        JPanel south = new JPanel();
        south.setLayout(new BoxLayout(south, 0));
        south.add(southwest);
        south.add(Box.createHorizontalGlue());
        south.add(southeast);
        this.containerPanel.add((Component)south, "South");
        Box commonSettingsPanel = new Box(1);
        commonSettingsPanel.add(generalTab);
        commonSettingsPanel.add(Box.createVerticalStrut(10));
        commonSettingsPanel.add(localScriptTab);
        commonSettingsPanel.add(Box.createVerticalStrut(10));
        commonSettingsPanel.add(remoteTab);
        commonSettingsPanel.add(Box.createVerticalStrut(10));
        commonSettingsPanel.setBorder(this.master.createTitledBorder(" Common Settings "));
        JPanel tabbedPanelLeft = new JPanel(new BorderLayout());
        tabbedPanelLeft.add((Component)commonSettingsPanel, "North");
        Box tabbedPane1Right = new Box(1);
        tabbedPane1Right.add(this.controlsPanel);
        tabbedPane1Right.add(Box.createVerticalStrut(10));
        tabbedPane1Right.add(this.containerPanel);
        Box tabbedPane1 = Box.createHorizontalBox();
        tabbedPane1.add(tabbedPanelLeft);
        tabbedPane1.add(tabbedPane1Right);
        this.setLayout(new GridBagLayout());
        this.add((Component)commonSettingsPanel, this.gridbagpos(0, 0).weightx(0.2).align(12));
        this.add((Component)this.controlsPanel, this.gridbagpos(0, 1).align(12));
        this.add((Component)this.containerPanel, this.gridbagpos(1, 0).width(2).align(12));
        this.disenabler = new Disenabler();
        this.chkRemoteBuiltin.setSelected(true);
        this.chkLocalScript.setSelected(true);
        this.btnShowAdvanced.setSelected(false);
    }

    protected ContainerLine addEmptyContainerLine() {
        ContainerLine containerLine = new ContainerLine();
        this.containerLinePanel.add(containerLine);
        this.containerLines.add(containerLine);
        int index = this.containerLines.size() - 1;
        this.setMnemonicForContainerLine(index);
        containerLine.setName("pnl_ContainerLine#" + index);
        containerLine.btnStart.setName("btn_Start_Container#" + index);
        containerLine.btnStop.setName("btn_Stop_Container#" + index);
        containerLine.btnConfigure.setName("btn_Edit_Container#" + index);
        containerLine.nameF.setName("txt_ContainerName#" + index);
        containerLine.typeF.setName("txt_ContainerType#" + index);
        containerLine.hostF.setName("txt_ContainerHost#" + index);
        containerLine.nameF.addFocusListener(this.focusListener);
        containerLine.typeF.addFocusListener(this.focusListener);
        containerLine.hostF.addFocusListener(this.focusListener);
        this.containerPanel.validate();
        this.scp.revalidate();
        return containerLine;
    }

    protected void setMnemonicForContainerLine(int index) {
        if (0 <= index && index < 10) {
            ContainerLine containerLine = this.containerLines.get(index);
            index = index == 9 ? 0 : index + 1;
            containerLine.lblMnemomic.setText(String.valueOf(index));
            containerLine.lblMnemomic.setDisplayedMnemonic(48 + index);
            containerLine.lblMnemomic.setLabelFor(containerLine.nameF);
        }
    }

    protected void moveContainerLine(int index, boolean upwards) {
        boolean err;
        boolean bl = upwards ? index == 0 : (err = index >= this.containerLines.size() - 1);
        if (!err) {
            int newIndex = upwards ? index - 1 : index + 1;
            ContainerLine containerLine = this.containerLines.remove(index);
            this.containerLines.add(newIndex, containerLine);
            this.containerLinePanel.remove(containerLine);
            this.containerLinePanel.add((Component)containerLine, newIndex);
            for (int i = 0; i < this.containerLines.size(); ++i) {
                this.setMnemonicForContainerLine(i);
            }
            this.containerPanel.validate();
        }
    }

    protected void lessContainerLines() {
        if (this.containerLines.size() == 0) {
            return;
        }
        ContainerLine containerLine = this.containerLines.get(this.containerLines.size() - 1);
        if (containerLine.selectB.isSelected() && this.containerLines.size() > 1) {
            this.containerLines.get((int)(this.containerLines.indexOf((Object)containerLine) - 1)).selectB.setSelected(true);
        }
        containerLine.nameF.removeFocusListener(this.focusListener);
        containerLine.typeF.removeFocusListener(this.focusListener);
        containerLine.hostF.removeFocusListener(this.focusListener);
        this.containerLines.remove(containerLine);
        this.containerLinePanel.remove(containerLine);
        this.containerPanel.validate();
    }

    protected void setAdvancedVisible(boolean b) {
        this.buttonPanelAdvanced.setVisible(b);
        this.validate();
    }

    protected void managerStarted() {
        this.master.managerStarted();
    }

    protected void managerStopped() {
        this.master.managerStopped();
    }

    protected boolean confirmKillAcs() {
        int res = JOptionPane.showConfirmDialog(this.master.frame, "This is recommended in severe cases only\nand may kill the Acs Command Center as well.\nAre you sure?", "Warning", 0);
        return res == 0;
    }

    protected boolean confirmStartJavaOnlyAcs() {
        String msg = "Please note the following restrictions:\n\n* Only one Manager can be started\n* That Manager may be stopped but cannot be restarted afterwards\n\n* Only one Container can be started\n* That Container may be stopped but cannot be restarted afterwards\n\nIf you need more, launch another instance of Acs Command Center.\nDo you want to continue?\n";
        int res = JOptionPane.showConfirmDialog(this.master.frame, msg, "Restrictions of Java-only Acs", 0);
        return res == 0;
    }

    protected int getMode() {
        ModeType mode = this.master.controller.project.getMode();
        return mode.getType();
    }

    public void validateAfterProgrammaticUpdate(JComponent trg) {
        FocusEvent evt = new FocusEvent(trg, 1005);
        FocusListener[] lis = trg.getFocusListeners();
        for (int i = 0; i < lis.length; ++i) {
            lis[i].focusLost(evt);
        }
    }

    protected void makeButtonPair(JButton on, JButton off) {
        this.buttonPairs.add(new ButtonPair(this, on, off));
    }

    protected GridBag gridbagpos(int y, int x) {
        GridBag ret = new GridBag();
        ret.pos(y, x);
        ret.gapx(2).gapy(2);
        ret.fill(1);
        ret.align(17);
        return ret;
    }

    protected class MyRadioButton
    extends JRadioButton {
        MyRadioButton(String text) {
            super(text);
        }

        @Override
        public void setSelected(boolean b) {
            ActionEvent e = new ActionEvent(this, 0, "");
            super.fireActionPerformed(e);
            super.setSelected(b);
        }
    }

    protected class MyFocusListener
    extends FocusAdapter {
        protected MyFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            TabPanel.this.master.writeFrontPanelToModel();
        }
    }

    protected class FlowDialog
    extends JInternalFrame
    implements FlowListener {
        DefaultChecklistPanel currentFlowUI;
        JButton flowDialogOk;
        WeakHashMap<JComponent, Object> disenable = new WeakHashMap();

        protected FlowDialog() {
            this.getContentPane().setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
            this.setFrameIcon(TabPanel.this.master.icons.getConfigIcon());
            this.flowDialogOk = new JButton("Close");
            this.flowDialogOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FlowDialog.this.close();
                }
            });
            this.getRootPane().setDefaultButton(this.flowDialogOk);
            this.flowDialogOk.setName("btn_Close_FlowDialog");
        }

        protected void prepareShow(final String title, final DefaultChecklistPanel content) throws InterruptedException, InvocationTargetException {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FlowDialog.this.setTitle(title + " - please wait");
                    FlowDialog.this.getContentPane().removeAll();
                    FlowDialog.this.getContentPane().add((Component)content, "Center");
                    FlowDialog.this.getContentPane().add((Component)FlowDialog.this.flowDialogOk, "South");
                    FlowDialog.this.validate();
                    FlowDialog.this.pack();
                    FlowDialog.this.setLayer(JLayeredPane.MODAL_LAYER);
                    FlowDialog.this.currentFlowUI = content;
                    FlowDialog.this.currentFlowUI.getFlow().addListener(FlowDialog.this);
                    for (JComponent c : FlowDialog.this.disenable.keySet()) {
                        c.setEnabled(false);
                    }
                    FlowDialog.this.setVisible(true);
                    TabPanel.this.master.desktop.add(FlowDialog.this);
                    Dimension dialogSize = FlowDialog.this.getPreferredSize();
                    Dimension desktopSize = TabPanel.this.master.desktop.getSize();
                    FlowDialog.this.setBounds((desktopSize.width - dialogSize.width) / 2, (desktopSize.height - dialogSize.height) / 2, dialogSize.width, dialogSize.height);
                    TabPanel.this.master.desktop.validate();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }

        public void close() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FlowDialog.this.setVisible(false);
                    TabPanel.this.master.desktop.remove(FlowDialog.this);
                    TabPanel.this.master.desktop.validate();
                    if (FlowDialog.this.isSelected()) {
                        try {
                            FlowDialog.this.setSelected(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                    if (FlowDialog.this.currentFlowUI != null) {
                        FlowDialog.this.currentFlowUI.getFlow().removeListener(FlowDialog.this);
                    }
                    for (JComponent c : FlowDialog.this.disenable.keySet()) {
                        c.setEnabled(true);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }

        protected void disenable(JComponent c) {
        }

        @Override
        public void completion(Flow f) {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.close();
        }

        @Override
        public void reset(Flow f, Object info) {
        }

        @Override
        public void trying(Flow f, String s) {
        }

        @Override
        public void success(Flow f, String s) {
        }

        @Override
        public void failure(Flow f, String s, Object o) {
        }
    }

    protected class ActionMoreContainers
    extends CommandCenterGui.BackgroundAction {
        protected ActionMoreContainers() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getPlusIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            TabPanel.this.addEmptyContainerLine();
            TabPanel.this.master.controller.moreContainers();
            TabPanel.this.disenabler.actionPerformed(null);
        }
    }

    protected class ActionLessContainers
    extends CommandCenterGui.BackgroundAction {
        protected ActionLessContainers() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getMinusIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            TabPanel.this.master.controller.lessContainers();
            TabPanel.this.lessContainerLines();
        }
    }

    protected class ActionConfigureAllContainers
    extends CommandCenterGui.BackgroundAction {
        protected ActionConfigureAllContainers() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getConfigIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            TabPanel.this.master.showManagerLocationForContainersDialog();
        }
    }

    protected class ActionMoveContainerUp
    extends CommandCenterGui.BackgroundAction {
        protected ActionMoveContainerUp() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getUpIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            int contNumber = (int)TabPanel.this.master.controller.project.getContainers().getSelect();
            if (contNumber > 0) {
                ContainerT cont = TabPanel.this.master.controller.removeContainer(contNumber);
                TabPanel.this.master.controller.insertContainer(cont, contNumber - 1);
                TabPanel.this.moveContainerLine(contNumber, true);
                TabPanel.this.master.controller.project.getContainers().setSelect((long)(contNumber - 1));
            }
        }
    }

    protected class ActionMoveContainerDown
    extends CommandCenterGui.BackgroundAction {
        protected ActionMoveContainerDown() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getDownIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            int lastIndex;
            int contNumber = (int)TabPanel.this.master.controller.project.getContainers().getSelect();
            if (contNumber < (lastIndex = TabPanel.this.master.controller.project.getContainers().getContainerCount() - 1)) {
                ContainerT cont = TabPanel.this.master.controller.removeContainer(contNumber);
                TabPanel.this.master.controller.insertContainer(cont, contNumber + 1);
                TabPanel.this.moveContainerLine(contNumber, false);
                TabPanel.this.master.controller.project.getContainers().setSelect((long)(contNumber + 1));
            }
        }
    }

    protected class GridBag
    extends GridBagConstraints {
        protected GridBag() {
        }

        GridBag pos(int y, int x) {
            this.gridy = y;
            this.gridx = x;
            return this;
        }

        GridBag gapy(int n) {
            this.insets.top = this.insets.bottom = n;
            return this;
        }

        GridBag gapx(int n) {
            this.insets.left = this.insets.right = n;
            return this;
        }

        GridBag width(int n) {
            this.gridwidth = n;
            return this;
        }

        GridBag weightx(double n) {
            this.weightx = n;
            return this;
        }

        GridBag fill(int n) {
            this.fill = n;
            return this;
        }

        GridBag align(int n) {
            this.anchor = n;
            return this;
        }
    }

    protected class ActionStartContainer
    extends CommandCenterGui.BackgroundAction {
        protected ActionStartContainer() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("Start Container");
        }

        @Override
        protected void actionPerformed() throws Throwable {
            int contNumber = (int)TabPanel.this.master.controller.project.getContainers().getSelect();
            String contName = TabPanel.this.master.controller.project.getContainers().getContainer(contNumber).getName();
            ProjectRunModel runmodel = TabPanel.this.master.controller.model.createViewOnContainer(contNumber);
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Starting " + contName, TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeContainer.startLocalScript(runmodel, TabPanel.this.master.giveOutputListener2(contName));
                    break;
                }
                case 1: {
                    TabPanel.this.flowDialog.prepareShow("Starting " + contName, TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeContainer.startRemote(runmodel, false, TabPanel.this.master.giveOutputListener2(contName));
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Starting " + contName, TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeContainer.startRemote(runmodel, true, TabPanel.this.master.giveOutputListener2(contName));
                    break;
                }
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Starting " + contName, TabPanel.this.remoteContainerDaemonFlowPanel);
                    TabPanel.this.master.controller.executeContainer.startRemoteDemonic(runmodel, TabPanel.this.master.giveOutputListener(contName));
                    break;
                }
                case 4: {
                    TabPanel.this.flowDialog.prepareShow("Starting " + contName, TabPanel.this.localJavaFlowPanel);
                    TabPanel.this.master.controller.executeContainer.startLocalJava(runmodel, TabPanel.this.master.giveOutputListener2(contName));
                }
            }
        }
    }

    protected class ActionStopContainer
    extends CommandCenterGui.BackgroundAction {
        protected ActionStopContainer() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("Stop Container");
        }

        @Override
        protected void actionPerformed() throws Throwable {
            int contNumber = (int)TabPanel.this.master.controller.project.getContainers().getSelect();
            String contName = TabPanel.this.master.controller.project.getContainers().getContainer(contNumber).getName();
            ProjectRunModel runmodel = TabPanel.this.master.controller.model.createViewOnContainer(contNumber);
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Stopping " + contName, TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeContainer.stopLocalScript(runmodel, TabPanel.this.master.giveOutputListener2(contName));
                    break;
                }
                case 1: {
                    TabPanel.this.flowDialog.prepareShow("Stopping " + contName, TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeContainer.stopRemote(runmodel, false, TabPanel.this.master.giveOutputListener2(contName));
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Stopping " + contName, TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeContainer.stopRemote(runmodel, true, TabPanel.this.master.giveOutputListener2(contName));
                    break;
                }
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Stopping " + contName, TabPanel.this.remoteContainerDaemonFlowPanel);
                    TabPanel.this.master.controller.executeContainer.stopRemoteDemonic(runmodel, TabPanel.this.master.giveOutputListener(contName));
                    break;
                }
                case 4: {
                    TabPanel.this.flowDialog.prepareShow("Stopping " + contName, TabPanel.this.localJavaFlowPanel);
                    TabPanel.this.master.controller.executeContainer.stopLocalJava(runmodel);
                }
            }
        }
    }

    protected class ActionConfigureContainer
    extends CommandCenterGui.BackgroundAction {
        protected ActionConfigureContainer() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("Configure Container");
        }

        @Override
        protected void actionPerformed() throws Throwable {
            TabPanel.this.master.showContainerSettingsDialog();
        }
    }

    protected class ActionStartAcs
    extends CommandCenterGui.BackgroundAction {
        protected ActionStartAcs() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("Start", TabPanel.this.master.icons.getStartIcon());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TabPanel.this.getMode() == 4 && !TabPanel.this.confirmStartJavaOnlyAcs()) {
                return;
            }
            super.actionPerformed(evt);
        }

        @Override
        protected void actionPerformed() throws Throwable {
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Starting Acs", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeAcs.startLocalScript(TabPanel.this.master.giveOutputListener2("Acs"));
                    TabPanel.this.managerStarted();
                    break;
                }
                case 1: {
                    TabPanel.this.flowDialog.prepareShow("Starting Acs", TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeAcs.startRemote(false, TabPanel.this.master.giveOutputListener2("Acs"));
                    TabPanel.this.managerStarted();
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Starting Acs", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeAcs.startRemote(true, TabPanel.this.master.giveOutputListener2("Acs"));
                    TabPanel.this.managerStarted();
                    break;
                }
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Starting Acs", TabPanel.this.remoteServicesDaemonFlowPanel);
                    TabPanel.this.master.controller.executeAcs.startRemoteDemonic(TabPanel.this.master.giveOutputListener("Acs"));
                    TabPanel.this.managerStarted();
                    break;
                }
                case 4: {
                    TabPanel.this.flowDialog.prepareShow("Starting Cdb", TabPanel.this.localJavaFlowPanel);
                    TabPanel.this.master.controller.executeServices.startLocalJava(TabPanel.this.master.giveOutputListener2("Acs"));
                    TabPanel.this.flowDialog.prepareShow("Starting Manager", TabPanel.this.localJavaFlowPanel);
                    TabPanel.this.master.controller.executeManager.startLocalJava(TabPanel.this.master.giveOutputListener2("Acs"));
                    TabPanel.this.managerStarted();
                }
            }
        }
    }

    protected class ActionStopAcs
    extends CommandCenterGui.BackgroundAction {
        protected ActionStopAcs() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("Stop", TabPanel.this.master.icons.getStopIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Acs", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeAcs.stopLocalScript(TabPanel.this.master.giveOutputListener2("Acs"));
                    TabPanel.this.managerStopped();
                    break;
                }
                case 1: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Acs", TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeAcs.stopRemote(false, TabPanel.this.master.giveOutputListener2("Acs"));
                    TabPanel.this.managerStopped();
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Acs", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeAcs.stopRemote(true, TabPanel.this.master.giveOutputListener2("Acs"));
                    TabPanel.this.managerStopped();
                    break;
                }
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Acs", TabPanel.this.remoteServicesDaemonFlowPanel);
                    TabPanel.this.master.controller.executeAcs.stopRemoteDemonic(TabPanel.this.master.giveOutputListener("Acs"));
                    TabPanel.this.managerStopped();
                    break;
                }
                case 4: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Manager", TabPanel.this.localJavaFlowPanel);
                    TabPanel.this.master.controller.executeManager.stopLocalJava();
                    TabPanel.this.flowDialog.prepareShow("Stopping Cdb", TabPanel.this.singleStepFlowPanel);
                    TabPanel.this.master.controller.executeServices.stopLocalJava();
                    TabPanel.this.managerStopped();
                }
            }
        }
    }

    protected class ActionKillAcs
    extends CommandCenterGui.BackgroundAction {
        protected ActionKillAcs() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("Kill", TabPanel.this.master.icons.getStopIconRed());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TabPanel.this.getMode() == 4) {
                JOptionPane.showMessageDialog(TabPanel.this.master.frame, "Kill not available in Java-only Acs.\nTerminate AcsCommandCenter instead.");
                return;
            }
            if (TabPanel.this.confirmKillAcs()) {
                super.actionPerformed(evt);
            }
        }

        @Override
        protected void actionPerformed() throws Throwable {
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Killing Acs", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeAcs.killLocalScript(TabPanel.this.master.giveOutputListener2("Acs"));
                    break;
                }
                case 1: 
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Killing Acs", TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeAcs.killRemote(false, TabPanel.this.master.giveOutputListener2("Acs"));
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Killing Acs", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeAcs.killRemote(true, TabPanel.this.master.giveOutputListener2("Acs"));
                    break;
                }
            }
        }
    }

    protected class ActionStartServices
    extends CommandCenterGui.BackgroundAction {
        protected ActionStartServices() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getStartIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Starting Services", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeServices.startLocalScript(TabPanel.this.master.giveOutputListener2("Services"));
                    break;
                }
                case 1: 
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Starting Services", TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeServices.startRemote(false, TabPanel.this.master.giveOutputListener2("Services"));
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Starting Services", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeServices.startRemote(true, TabPanel.this.master.giveOutputListener2("Services"));
                    break;
                }
                case 4: {
                    TabPanel.this.flowDialog.prepareShow("Starting Cdb", TabPanel.this.localJavaFlowPanel);
                    TabPanel.this.master.controller.executeServices.startLocalJava(TabPanel.this.master.giveOutputListener2("Services"));
                }
            }
        }
    }

    protected class ActionStopServices
    extends CommandCenterGui.BackgroundAction {
        protected ActionStopServices() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getStopIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Services", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeServices.stopLocalScript(TabPanel.this.master.giveOutputListener2("Services"));
                    break;
                }
                case 1: 
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Services", TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeServices.stopRemote(false, TabPanel.this.master.giveOutputListener2("Services"));
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Services", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeServices.stopRemote(true, TabPanel.this.master.giveOutputListener2("Services"));
                    break;
                }
                case 4: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Cdb", TabPanel.this.singleStepFlowPanel);
                    TabPanel.this.master.controller.executeServices.stopLocalJava();
                }
            }
        }
    }

    protected class ActionStartManager
    extends CommandCenterGui.BackgroundAction {
        protected ActionStartManager() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getStartIcon());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TabPanel.this.getMode() == 4 && !TabPanel.this.confirmStartJavaOnlyAcs()) {
                return;
            }
            super.actionPerformed(evt);
        }

        @Override
        protected void actionPerformed() throws Throwable {
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Starting Manager", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeManager.startLocalScript(TabPanel.this.master.giveOutputListener2("Manager"));
                    TabPanel.this.managerStarted();
                    break;
                }
                case 1: 
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Starting Manager", TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeManager.startRemote(false, TabPanel.this.master.giveOutputListener2("Manager"));
                    TabPanel.this.managerStarted();
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Starting Manager", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeManager.startRemote(true, TabPanel.this.master.giveOutputListener2("Manager"));
                    TabPanel.this.managerStarted();
                    break;
                }
                case 4: {
                    TabPanel.this.flowDialog.prepareShow("Starting Manager", TabPanel.this.localJavaFlowPanel);
                    TabPanel.this.master.controller.executeManager.startLocalJava(TabPanel.this.master.giveOutputListener2("Manager"));
                    TabPanel.this.managerStarted();
                }
            }
        }
    }

    protected class ActionStopManager
    extends CommandCenterGui.BackgroundAction {
        protected ActionStopManager() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getStopIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            switch (TabPanel.this.getMode()) {
                case 0: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Manager", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeManager.stopLocalScript(TabPanel.this.master.giveOutputListener2("Manager"));
                    TabPanel.this.managerStopped();
                    break;
                }
                case 1: 
                case 2: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Manager", TabPanel.this.remoteFlowPanel);
                    TabPanel.this.master.controller.executeManager.stopRemote(false, TabPanel.this.master.giveOutputListener2("Manager"));
                    TabPanel.this.managerStopped();
                    break;
                }
                case 3: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Manager", TabPanel.this.localScriptFlowPanel);
                    TabPanel.this.master.controller.executeManager.stopRemote(true, TabPanel.this.master.giveOutputListener2("Manager"));
                    TabPanel.this.managerStopped();
                    break;
                }
                case 4: {
                    TabPanel.this.flowDialog.prepareShow("Stopping Manager", TabPanel.this.localJavaFlowPanel);
                    TabPanel.this.master.controller.executeManager.stopLocalJava();
                    TabPanel.this.managerStopped();
                }
            }
        }
    }

    protected class MyCheckBox
    extends JCheckBox {
        MyCheckBox(Action a) {
            super(a);
        }

        @Override
        public void setSelected(boolean b) {
            ActionEvent e = new ActionEvent(this, 0, "");
            super.fireActionPerformed(e);
            super.setSelected(b);
        }
    }

    protected class ActionShowAdvanced
    extends CommandCenterGui.BackgroundAction {
        protected ActionShowAdvanced() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("advanced", null);
        }

        @Override
        protected void actionPerformed() throws Throwable {
            boolean b = TabPanel.this.btnShowAdvanced.isSelected();
            TabPanel.this.setAdvancedVisible(b);
        }
    }

    protected class ActionStartAllContainers
    extends CommandCenterGui.BackgroundAction {
        protected ActionStartAllContainers() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getStartIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            ContainersT conts = TabPanel.this.master.controller.project.getContainers();
            for (int contNumber = 0; contNumber < conts.getContainerCount(); ++contNumber) {
                conts.setSelect((long)contNumber);
                TabPanel.this.actStartContainer.actionPerformed();
            }
        }
    }

    protected class ActionStopAllContainers
    extends CommandCenterGui.BackgroundAction {
        protected ActionStopAllContainers() {
            CommandCenterGui commandCenterGui = TabPanel.this.master;
            Objects.requireNonNull(commandCenterGui);
            super("", TabPanel.this.master.icons.getStopIcon());
        }

        @Override
        protected void actionPerformed() throws Throwable {
            ContainersT conts = TabPanel.this.master.controller.project.getContainers();
            for (int contNumber = conts.getContainerCount() - 1; contNumber >= 0; --contNumber) {
                conts.setSelect((long)contNumber);
                TabPanel.this.actStopContainer.actionPerformed();
            }
        }
    }

    protected class FixSizeSeparator
    extends JSeparator {
        Dimension d;

        public FixSizeSeparator(int orientation, Dimension d) {
            super(orientation);
            this.d = d;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.d;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.d;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.d;
        }
    }

    protected class FixSizeScrollPane
    extends JScrollPane {
        Dimension d;

        public FixSizeScrollPane(Component q, int vsbPolicy, int hsbPolicy) {
            super(q, vsbPolicy, hsbPolicy);
        }

        public void freezeSize(int width, int height) {
            int barWidth = this.getVerticalScrollBar().getWidth();
            int barHeight = this.getVerticalScrollBar().getWidth();
            Insets ins = this.getInsets();
            this.d = new Dimension(ins.left + width + barWidth + ins.right, ins.top + height + barHeight + ins.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.d != null ? this.d : super.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.d != null ? this.d : super.getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.d != null ? this.d : super.getPreferredSize();
        }
    }

    protected class ContainerLine
    extends JPanel
    implements ActionListener {
        JRadioButton selectB;
        JLabel lblMnemomic;
        Button btnStart;
        Button btnStop;
        Button btnConfigure;
        JTextField nameF;
        JComboBox typeF;
        JTextField hostF;

        ContainerLine() {
            this.setLayout(new BoxLayout(this, 0));
            this.lblMnemomic = new JLabel("x");
            this.add(this.lblMnemomic);
            this.add(Box.createHorizontalStrut(5));
            JPanel b = new JPanel(new GridLayout(0, 3, 5, 5));
            this.nameF = new JTextField(10);
            b.add(this.nameF);
            this.typeF = new JComboBox<String>(new String[]{"java", "cpp", "py"});
            b.add(this.typeF);
            this.hostF = new JTextField(10);
            b.add(this.hostF);
            this.add(b);
            this.add(Box.createHorizontalStrut(5));
            this.hostF.setToolTipText("Remote Host (if different from Manager host)");
            this.hostF.setEditable(false);
            this.selectB = new JRadioButton();
            this.selectB.addFocusListener(TabPanel.this.focusListener);
            TabPanel.this.buttonGroup2.add(this.selectB);
            this.nameF.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ContainerLine.this.selectB.setSelected(true);
                    TabPanel.this.validateAfterProgrammaticUpdate(ContainerLine.this.selectB);
                }
            });
            this.btnConfigure = new Button(TabPanel.this.master.icons.getConfigIcon(), this);
            this.add(this.btnConfigure);
            this.btnConfigure.setToolTipText("Edit Remote Settings");
            this.btnStart = new Button(TabPanel.this.master.icons.getStartIcon(), this);
            this.add(this.btnStart);
            this.btnStart.setToolTipText("Start this Container");
            TabPanel.this.flowDialog.disenable(this.btnStart);
            this.btnStop = new Button(TabPanel.this.master.icons.getStopIcon(), this);
            this.add(this.btnStop);
            this.btnStop.setToolTipText("Stop this Container");
            TabPanel.this.flowDialog.disenable(this.btnStop);
            TabPanel.this.makeButtonPair(this.btnStart, this.btnStop);
        }

        void populate(String name, String type, String host, boolean selected) {
            this.nameF.setText(name);
            this.typeF.setSelectedItem(type);
            this.hostF.setText(host);
            this.selectB.setSelected(selected);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selectB.setSelected(true);
            TabPanel.this.validateAfterProgrammaticUpdate(this.selectB);
            if (e.getSource() == this.btnStart && this.sanityCheck()) {
                TabPanel.this.actStartContainer.actionPerformed(null);
            }
            if (e.getSource() == this.btnStop && this.sanityCheck()) {
                TabPanel.this.actStopContainer.actionPerformed(null);
            }
            if (e.getSource() == this.btnConfigure) {
                TabPanel.this.actConfigureContainer.actionPerformed(null);
            }
        }

        boolean sanityCheck() {
            if (this.nameF.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(TabPanel.this.master.frame, "The specified Name is invalid", "Invalid Container Settings", 0);
                return false;
            }
            return true;
        }

        class Button
        extends JButton {
            Button(Icon icon, ContainerLine cl) {
                super(icon);
                this.setMargin(new Insets(1, 0, 1, 0));
                this.addActionListener(cl);
            }
        }
    }

    protected class Disenabler
    implements ActionListener {
        Disenabler() {
            TabPanel.this.chkRemoteScript.addActionListener(this);
            TabPanel.this.chkLocalScript.addActionListener(this);
            TabPanel.this.chkRemoteBuiltin.addActionListener(this);
            TabPanel.this.chkRemoteNative.addActionListener(this);
            TabPanel.this.chkRemoteDaemons.addActionListener(this);
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean local = TabPanel.this.chkLocalScript.isSelected();
            boolean remote = TabPanel.this.chkRemoteScript.isSelected();
            boolean remoteBuiltin = remote && TabPanel.this.chkRemoteBuiltin.isSelected();
            boolean remoteNative = remote && TabPanel.this.chkRemoteNative.isSelected();
            boolean remoteDaemon = remote && TabPanel.this.chkRemoteDaemons.isSelected();
            TabPanel.this.chkRemoteBuiltin.setEnabled(remote);
            TabPanel.this.chkRemoteDaemons.setEnabled(remote);
            TabPanel.this.chkRemoteNative.setEnabled(remote);
            TabPanel.this.hostL.setEnabled(remote);
            TabPanel.this.hostF.setEnabled(remote);
            TabPanel.this.accountL.setEnabled(remoteBuiltin || remoteNative);
            TabPanel.this.accountF.setEnabled(remoteBuiltin || remoteNative);
            TabPanel.this.passwordL.setEnabled(remoteBuiltin);
            TabPanel.this.passwordF.setEnabled(remoteBuiltin);
            TabPanel.this.cdbrootF.setEnabled(local || remoteBuiltin || remoteNative);
            if (TabPanel.this.master.dlgContainerSettings != null) {
                TabPanel.this.master.dlgContainerSettings.btnCustom.setEnabled(remote);
                TabPanel.this.master.dlgContainerSettings.hostL.setEnabled(remote);
                TabPanel.this.master.dlgContainerSettings.hostF.setEnabled(remote);
                TabPanel.this.master.dlgContainerSettings.accountL.setEnabled(remoteBuiltin || remoteNative);
                TabPanel.this.master.dlgContainerSettings.accountF.setEnabled(remoteBuiltin || remoteNative);
                TabPanel.this.master.dlgContainerSettings.passwordL.setEnabled(remoteBuiltin);
                TabPanel.this.master.dlgContainerSettings.passwordF.setEnabled(remoteBuiltin);
                TabPanel.this.master.dlgContainerSettings.modifL.setEnabled(remoteDaemon);
                TabPanel.this.master.dlgContainerSettings.modifF.setEnabled(remoteDaemon);
                TabPanel.this.master.dlgContainerSettings.heapL.setEnabled(remoteDaemon);
                TabPanel.this.master.dlgContainerSettings.heapF.setEnabled(remoteDaemon);
            }
            for (ContainerLine contline : TabPanel.this.containerLines) {
                contline.btnConfigure.setEnabled(remote);
            }
        }
    }

    protected class ButtonPair
    implements ActionListener {
        protected JButton on;
        protected JButton off;

        protected ButtonPair(TabPanel this$0, JButton on, JButton off) {
            this.on = on;
            on.addActionListener(this);
            this.off = off;
            off.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.on) {
                this.respond(this.on, this.off);
            } else if (e.getSource() == this.off) {
                this.respond(this.off, this.on);
            }
        }

        protected void respond(JButton active, JButton passive) {
            active.setBackground(CommandCenterGui.COLOR_ActiveButton);
            passive.setBackground(CommandCenterGui.COLOR_PassiveButton);
        }
    }
}

