/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.utilities.TextUtils;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.services.experts.calibrators.DeclinationComparator;
import alma.obsprep.services.experts.calibrators.MeasurementTableModel;
import alma.obsprep.services.experts.spectralline.gui.TableCellRendererFactory;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class ObservatoryGoalTargetSelectorEditor
extends EditorWithGridBagLayout {
    private final Set<Measurement> selected = new HashSet<Measurement>();
    private final MeasurementTableModel measurementTableModel = new MeasurementTableModel();
    private JButton addAllButton;
    private JButton addSelectedButton;
    private JButton submitQueryButton;
    private JButton cancelButton;
    private JButton okButton;
    private JLabel infoLabel;
    private JScrollPane scrollPane;
    private JComboBox catalogue;
    private JTable table;
    private JButton selectButton;
    private boolean isMultipleSelect = false;

    @Override
    public void addComponents(String string) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.scrollPane = new ScrollWhenFocusedPane();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.addSelectedButton = new JButton();
        this.addAllButton = new JButton();
        JLabel jLabel4 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        JLabel jLabel5 = new JLabel();
        this.catalogue = new JComboBox();
        this.submitQueryButton = this.makeButton(QuerySourceEditor.filterFID, "Submit Query", "Find source catalog measurements matching your selection criteria");
        this.selectButton = new JButton();
        jPanel.setName("ObservatoryGoalTargetsEditor.resultsPanel");
        jLabel.setName("ObservatoryGoalTargetsEditor.helpLabel");
        this.infoLabel.setName("ObservatoryGoalTargetsEditor.infoLabel");
        this.scrollPane.setName("ObservatoryGoalTargetsEditor.scrollPane");
        this.table.setName("ObservatoryGoalTargetsEditor.table");
        jPanel2.setName("ObservatoryGoalTargetsEditor.buttonPanel");
        jLabel2.setName("ObservatoryGoalTargetsEditor.spacer1");
        jLabel3.setName("ObservatoryGoalTargetsEditor.spacer2");
        this.addSelectedButton.setName("ObservatoryGoalTargetsEditor.addSelectedButton");
        this.addAllButton.setName("ObservatoryGoalTargetsEditor.addAllButton");
        jLabel4.setName("ObservatoryGoalTargetsEditor.spacer3");
        this.cancelButton.setName("ObservatoryGoalTargetsEditor.cancelButton");
        this.okButton.setName("ObservatoryGoalTargetsEditor.okButton");
        jLabel5.setName("ObservatoryGoalTargetsEditor.catalogueLabel");
        this.catalogue.setName("ObservatoryGoalTargetsEditor.catalogue");
        this.selectButton.setName("ObservatoryGoalTargetsEditor.selectButton");
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getStyle() & 0xFFFFFFFE));
        if (this.isMultipleSelect) {
            jLabel.setText("<html><ul><li>Click <i>Submit Query</i> to find source catalog measurements matching your criteria.</li><li>Choose targets from the table using the <i>Add Selected</i> and <i>Add All</i> buttons.</li></ul></html>");
        } else {
            jLabel.setText("<html><ul><li>Click <i>Submit Query</i> to find source catalog measurements matching your criteria.</li><li>Choose a measurement from the table and click <i>Select Calibrator</i> to import the target.</li></ul></html>");
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        jPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.table.setModel(this.measurementTableModel);
        this.measurementTableModel.addTableModelListener(tableModelEvent -> this.selectButton.setEnabled(this.measurementTableModel.getRowCount() >= 1));
        if (this.isMultipleSelect) {
            this.table.setSelectionMode(2);
        } else {
            this.table.setSelectionMode(0);
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.SEPARATION));
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.table.getColumnModel().getColumn(5);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FLUX_DENSITY));
        tableColumn = this.table.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.DATE));
        this.scrollPane.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        jPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.addSelectedButton.setText("Add Selected");
        this.addAllButton.setText("Add All");
        this.cancelButton.setText("Cancel");
        this.okButton.setText("OK");
        jLabel5.setText("to");
        this.selectButton.setText("Select Calibrator");
        GroupLayout groupLayout = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout);
        if (this.isMultipleSelect) {
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitQueryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addSelectedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton)));
            groupLayout.linkSize(0, this.okButton, jLabel2);
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(jLabel3).addComponent(this.addSelectedButton).addComponent(this.addAllButton).addComponent(jLabel4).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(jLabel5).addComponent(this.catalogue, -2, -1, -2).addComponent(this.submitQueryButton)));
        } else {
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitQueryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addComponent(this.okButton)));
            groupLayout.linkSize(0, this.okButton, jLabel2);
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(jLabel3).addComponent(this.selectButton).addComponent(jLabel4).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(jLabel5).addComponent(this.catalogue, -2, -1, -2).addComponent(this.submitQueryButton)));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public ObservatoryGoalTargetSelectorEditor(Model model, boolean bl) {
        this.isMultipleSelect = bl;
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(CalibratorExpertEditor.tableFID)) {
            if (object instanceof List) {
                List list = (List)object;
                this.measurementTableModel.setCalibrators(list);
            }
            if (this.submitQueryButton != null) {
                this.submitQueryButton.setEnabled(true);
            }
        } else if (fieldID.equals(QuerySourceEditor.raFID)) {
            String string = (String)object;
            this.measurementTableModel.setQueryRA(string);
        } else if (fieldID.equals(QuerySourceEditor.decFID)) {
            String string = (String)object;
            this.measurementTableModel.setQueryDec(string);
        } else if (fieldID.equals(QuerySourceEditor.catlocFID)) {
            this.set2(this.catalogue, object);
            return;
        }
        super.modelChanged(model, fieldID, object);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (QuerySourceEditor.filterFID.equals(fieldID)) {
            this.submitQueryButton.setEnabled(false);
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    protected void build() {
        super.build("ObservatoryGoalTargetsEditor");
        this.catalogue.setModel(new DefaultComboBoxModel<String>(CalibratorExpert.SourceCatalog.getNames()));
        this.initEvents(this.catalogue, QuerySourceEditor.catlocFID);
        this.makeTableSortable();
        this.addAllButton.addActionListener(actionEvent -> this.addAllButtonActionPerformed());
        this.addSelectedButton.addActionListener(actionEvent -> this.addSelectedButtonActionPerformed());
        this.selectButton.addActionListener(actionEvent -> this.selectButtonActionPerformed());
    }

    void addOkButtonActionListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
    }

    void addCancelButtonActionListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public List<Measurement> getSelectedCalibrators() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        arrayList.addAll(this.selected);
        return arrayList;
    }

    public JButton getSubmitQueryButton() {
        return this.submitQueryButton;
    }

    private void makeTableSortable() {
        TableRowSorter<MeasurementTableModel> tableRowSorter = new TableRowSorter<MeasurementTableModel>(this.measurementTableModel);
        tableRowSorter.setComparator(2, new DeclinationComparator());
        this.table.setRowSorter(tableRowSorter);
    }

    private void displayNumSelectedSummary() {
        int n = this.selected.size();
        Dimension dimension = this.scrollPane.getSize();
        if (n > 1) {
            this.infoLabel.setIcon(Icons.info);
            this.infoLabel.setText("Adding " + n + " results to your target list");
        } else if (n == 1) {
            this.infoLabel.setIcon(Icons.info);
            this.infoLabel.setText("Adding " + n + " result to your target list");
        }
        dimension.setSize(dimension.width, dimension.height - this.infoLabel.getHeight());
        this.scrollPane.setPreferredSize(dimension);
    }

    private void selectButtonActionPerformed() {
        int n = this.table.getSelectedRow();
        if (n != -1) {
            int n2 = this.table.convertRowIndexToModel(n);
            Measurement measurement = this.measurementTableModel.get(n2);
            this.selected.clear();
            this.selected.add(measurement);
            this.infoLabel.setIcon(Icons.info);
            this.infoLabel.setText(TextUtils.join((Collection)measurement.getNames(), (String)";") + " will be selected as a calibrator");
            Dimension dimension = this.scrollPane.getSize();
            dimension.setSize(dimension.width, dimension.height - this.infoLabel.getHeight());
            this.scrollPane.setPreferredSize(dimension);
        }
    }

    private void addSelectedButtonActionPerformed() {
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            Measurement measurement = this.measurementTableModel.get(n2);
            this.selected.add(measurement);
        }
        this.displayNumSelectedSummary();
    }

    private void addAllButtonActionPerformed() {
        List<Measurement> list = this.measurementTableModel.getCalibrators();
        this.selected.addAll(list);
        this.displayNumSelectedSummary();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        QuerySource querySource = QuerySource.createQuerySource();
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(querySourceAdapter);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, exception);
            }
            ObservatoryGoalTargetSelectorEditor observatoryGoalTargetSelectorEditor = new ObservatoryGoalTargetSelectorEditor(calibratorExpertModel, true);
            JFrame jFrame = new JFrame("ObservatoryGoalTargetSelectorPanel");
            jFrame.setDefaultCloseOperation(3);
            jFrame.getContentPane().add(observatoryGoalTargetSelectorEditor);
            jFrame.pack();
            jFrame.setVisible(true);
        });
    }
}

