/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.CrossPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.CrossPatternModel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CrossPatternEditor
extends EditorWithGridBagLayout {
    public static FieldID FID_INITIALSCANDIRECTION = new FieldID("CrossPattern.initialScanDirection");

    public CrossPatternEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        CrossPatternModel crossPatternModel = (CrossPatternModel)this.getModel();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        CoordsEditor coordsEditor = new CoordsEditor(true, crossPatternModel.getPatternCenterCoordsModel());
        this.registerSubView(coordsEditor);
        coordsEditor.setToolTipText("The pattern center coordinsates");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Pattern Center Coords", (JComponent)coordsEditor);
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, crossPatternModel.getLatitudeLengthModel(), "Lat. length", "The latitude length");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, crossPatternModel.getLongitudeLengthModel(), "Long. length", "The longitude length");
        this.addComboBox((JComponent)jPanel, gridBagLayout, gridBagConstraints, FID_INITIALSCANDIRECTION, "Initial Scan Direction", "The cross's initial scan direction", RectanglePattern.getKnownScanDirectionList());
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, crossPatternModel.getScanVelocityModel(), "Scan Velocity", "The rectangle's scan velocity");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, crossPatternModel.getOrientationModel(), "Orientation", "The rectangle's orientation");
        this.addComponent(jPanel);
    }

    @Override
    public void build() {
        super.build("CrossPatternEditor");
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        CrossPattern crossPattern = CrossPattern.createCrossPattern();
        CrossPatternModel crossPatternModel = new CrossPatternModel(null);
        CrossPatternEditor crossPatternEditor = new CrossPatternEditor(crossPatternModel);
        crossPatternModel.setDocument((Object)crossPattern);
        JFrame jFrame = new JFrame("TEST:CrossPatternEditor");
        jFrame.setPreferredSize(new Dimension(600, 600));
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.add(crossPatternEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

