/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.editors.schedblock.ObservingGroupAllTargetsTable;
import alma.obsprep.ot.editors.schedblock.ObservingGroupSelectTargetsTable;
import alma.obsprep.ot.models.schedblock.ObservingGroupModel;
import alma.obsprep.ot.models.schedblock.ObservingGroupSelectTargetsTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ObservingGroupEditor
extends Editor {
    public static final FieldID DOCUMENT_FID = new FieldID("ObservingGroupEditor.Document");
    public static final FieldID GROUP_NAME_FID = new FieldID("ObservingGroupEditor.GroupName");
    public static final FieldID GROUP_DOPPLER_TARGET_FID = new FieldID("ObservingGroupEditor.DopplerTarget");
    private OTTextField m_nameTextField = null;
    private ObservingGroupAllTargetsTable m_allTargetsTable = null;
    private ObservingGroupSelectTargetsTable m_selectTargetsTable = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JButton m_addButton = null;
    private JButton m_deleteButton = null;

    public ObservingGroupEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public ObservingGroupModel getModel() {
        return (ObservingGroupModel)super.getModel();
    }

    private void createComponents() {
        ObservingGroupModel observingGroupModel = this.getModel();
        this.m_nameTextField = new OTTextField();
        this.m_nameTextField.setColumns(30);
        this.m_nameTextField.setToolTipText("Set observing group name");
        this.initEvents(this.m_nameTextField, GROUP_NAME_FID);
        this.m_allTargetsTable = new ObservingGroupAllTargetsTable(observingGroupModel.getAllTargetsTableModel());
        this.m_selectTargetsTable = new ObservingGroupSelectTargetsTable(observingGroupModel.getSelectTargetsTableModel());
        this.m_addButton = new JButton("\u2192");
        this.m_addButton.setToolTipText("Add target to observing group");
        this.m_addButton.addActionListener(actionEvent -> this.addTargetsToObservingGroup());
        this.m_deleteButton = new JButton("Delete");
        this.m_deleteButton.setToolTipText("Delete target from observing group");
        this.m_deleteButton.addActionListener(actionEvent -> this.deleteTargetsFromObservingGroup());
        this.m_upButton = new JButton("\u2191");
        this.m_upButton.setToolTipText("Move target up one row");
        this.m_upButton.addActionListener(actionEvent -> this.moveTargetUpOneRow());
        this.m_downButton = new JButton("\u2193");
        this.m_downButton.setToolTipText("Move target down one row");
        this.m_downButton.addActionListener(actionEvent -> this.moveTargetDownOneRow());
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(new JLabel("Observing Group Name"));
        jPanel.add(this.m_nameTextField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("<html><strong>All Available Targets</strong></html>");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel("<html><strong>Observing Group Targets</strong></html>");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel2, gridBagConstraints);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.m_allTargetsTable);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)scrollWhenFocusedPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.m_addButton, gridBagConstraints);
        ScrollWhenFocusedPane scrollWhenFocusedPane2 = new ScrollWhenFocusedPane(this.m_selectTargetsTable);
        scrollWhenFocusedPane2.setPreferredSize(new Dimension(600, 260));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)scrollWhenFocusedPane2, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.m_deleteButton);
        jPanel2.add(this.m_upButton);
        jPanel2.add(this.m_downButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel3 = new JLabel("Warning: Changing the doppler target can result in invalid tuning solutions.");
        this.add((Component)jLabel3, gridBagConstraints);
    }

    @Override
    protected void build() {
        this.createComponents();
        this.layoutComponents();
    }

    private void addTargetsToObservingGroup() {
        ObservingGroup observingGroup = (ObservingGroup)this.getModel().getDocument();
        int n = observingGroup.getOrderedTargetCount();
        int n2 = this.m_selectTargetsTable.getSelectedRow();
        n2 = n2 < 0 || n2 > n ? n : ++n2;
        int n3 = 0;
        for (int n4 : this.m_allTargetsTable.getSelectedRows()) {
            Target target = observingGroup.getSchedBlock().getTarget(n4);
            if (observingGroup.isTargetInGroup(target)) continue;
            OrderedTarget orderedTarget = observingGroup.createOrderedTarget(n2 + n3);
            orderedTarget.setTarget(target);
            ++n3;
        }
        this.getModel().publish();
    }

    private void deleteTargetsFromObservingGroup() {
        ObservingGroup observingGroup = (ObservingGroup)this.getModel().getDocument();
        int[] nArray = this.m_selectTargetsTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[nArray.length - 1 - i];
        }
        for (int n : nArray2) {
            if (observingGroup.getMainTarget() != null && observingGroup.getMainTarget().equals(observingGroup.getOrderedTarget(n).getTarget())) {
                observingGroup.setMainTarget(null);
            }
            observingGroup.deleteOrderedTarget(n);
        }
        this.getModel().publish();
    }

    private void moveTargetUpOneRow() {
        ObservingGroup observingGroup = (ObservingGroup)this.getModel().getDocument();
        int n = this.m_selectTargetsTable.getRowCount();
        if (n == 0) {
            return;
        }
        int n2 = this.m_selectTargetsTable.getSelectedRow();
        if (n2 <= 0 || n2 > n) {
            return;
        }
        observingGroup.moveOrderedTargetUpOneRow(n2);
        this.getModel().publish();
        try {
            this.m_selectTargetsTable.setRowSelectionInterval(n2 - 1, n2 - 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.m_selectTargetsTable.setRowSelectionInterval(n2, n2);
        }
    }

    private void moveTargetDownOneRow() {
        ObservingGroup observingGroup = (ObservingGroup)this.getModel().getDocument();
        int n = this.m_selectTargetsTable.getRowCount();
        if (n == 0) {
            return;
        }
        int n2 = this.m_selectTargetsTable.getSelectedRow();
        if (n2 < 0 || n2 >= n) {
            return;
        }
        observingGroup.moveOrderedTargetDownOneRow(n2);
        this.getModel().publish();
        try {
            this.m_selectTargetsTable.setRowSelectionInterval(n2 + 1, n2 + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.m_selectTargetsTable.setRowSelectionInterval(n2, n2);
        }
    }

    public Target[] getHighlightedTargets() {
        int[] nArray = this.m_selectTargetsTable.getSelectedRows();
        ObservingGroupSelectTargetsTableModel observingGroupSelectTargetsTableModel = (ObservingGroupSelectTargetsTableModel)this.m_selectTargetsTable.getModel();
        Target[] targetArray = new Target[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            targetArray[i] = observingGroupSelectTargetsTableModel.getOrderedTargetAtRow(n).getTarget();
        }
        return targetArray;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == DOCUMENT_FID) {
            ObservingGroup observingGroup = (ObservingGroup)object;
            if (observingGroup == null) {
                return;
            }
            super.update(fieldID, object);
        } else if (fieldID == GROUP_NAME_FID) {
            String string = (String)object;
            if (string == null) {
                return;
            }
            this.m_nameTextField.setText(string);
        }
    }
}

