/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.obsproject.RectangleEditor;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiControlParameterEditor;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.models.obsproject.SuspendablePropertyChangeListener;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.RectangleAreaExpert;
import alma.valuetypes.data.SkyCoordinatesData;
import lombok.NonNull;

public class RectangleModel
extends Model {
    private boolean isACAEnabled = true;
    private final ModelChangeSubscriber nPointingsUpdater = (model, fieldID, object) -> {
        Object object2;
        Rectangle rectangle = this.getRectangle();
        if (rectangle == null) {
            return;
        }
        BusinessObject businessObject = rectangle.getParent();
        if (businessObject == null) {
            return;
        }
        BusinessObject businessObject2 = businessObject.getParent();
        boolean bl = false;
        if (businessObject2 instanceof ScienceGoal) {
            object2 = (ScienceGoal)businessObject2;
            bl = ((ScienceGoal)object2).isStandAloneACA();
        }
        object2 = RectangleAreaExpert.of(rectangle);
        this.publish(RectangleEditor.NPOINTINGS12M_FID, bl ? "" : Integer.valueOf(((RectangleAreaExpert)object2).getNumberOfPointings(Array.ARRAY_12M)));
        this.publish(RectangleEditor.NPOINTINGS7M_FID, ((RectangleAreaExpert)object2).getNumberOfPointings(Array.ARRAY_7M));
    };
    private final ModelChangeSubscriber updaterFor12mPointings = (model, fieldID, object) -> this.nPointingsUpdater.modelChanged(null, null, null);
    public static final FieldID LONG_VALUE = new FieldID("Rectangle.long.value");
    public static final FieldID LONG_UNIT = new FieldID("Rectangle.long.unit");
    public static final FieldID SHORT_VALUE = new FieldID("Rectangle.short.value");
    public static final FieldID SHORT_UNIT = new FieldID("Rectangle.short.unit");
    public static final FieldID PA_LONG_VALUE = new FieldID("Rectangle.paLong.value");
    public static final FieldID PA_LONG_UNIT = new FieldID("Rectangle.paLong.unit");
    public static final FieldID SPACING_VALUE = new FieldID("Rectangle.spacing.value");
    public static final FieldID SPACING_UNIT = new FieldID("Rectangle.spacing.unit");
    private final CoordsModel coordsModel = new CoordsModel(null);
    private final ValueUnitPairModel longModel = new ValueUnitPairModel(null, LONG_VALUE, LONG_UNIT);
    private final ValueUnitPairModel shortModel = new ValueUnitPairModel(null, SHORT_VALUE, SHORT_UNIT);
    private final ValueUnitPairModel paLongModel = new ValueUnitPairModel(null, PA_LONG_VALUE, PA_LONG_UNIT);
    private final UserUnitValueUnitPairModel spacingModel = new UserUnitValueUnitPairModel(null, SPACING_VALUE, SPACING_UNIT);
    private final SuspendablePropertyChangeListener boListener = new SuspendablePropertyChangeListener(this);
    private final ModelChangeSubscriber acaEnabledUpdater = (model, fieldID, object) -> {
        boolean bl = this.isACAEnabled;
        if (SfiControlParameterEditor.FID_ACAOBSERVATION.equals(fieldID) && object instanceof Boolean) {
            this.isACAEnabled = (Boolean)object;
            this.publish(RectangleEditor.ACA_ENABLED_FID, this.isACAEnabled);
        }
        this.nPointingsUpdater.modelChanged(null, null, null);
        if (bl != this.isACAEnabled && this.isACAEnabled) {
            this.nPointingsUpdater.modelChanged(null, null, null);
        }
    };

    public RectangleModel(Object object2) {
        super(object2);
        this.registerSubModel(this.coordsModel);
        this.registerSubModel(this.longModel);
        this.registerSubModel(this.shortModel);
        this.registerSubModel(this.paLongModel);
        this.registerSubModel(this.spacingModel);
        this.configureNpointingsUpdater();
        this.setDocument(object2);
    }

    private Rectangle getRectangle() {
        return (Rectangle)this.getDocument();
    }

    private void configureNpointingsUpdater() {
        this.longModel.subscribe(this.nPointingsUpdater);
        this.shortModel.subscribe(this.nPointingsUpdater);
        this.spacingModel.subscribe(this.nPointingsUpdater);
    }

    public ValueUnitPairModel getPALongModel() {
        return this.paLongModel;
    }

    @Override
    public void publish() {
        Rectangle rectangle = this.getRectangle();
        if (rectangle != null) {
            this.getCoordsModel().publish();
            this.getLongModel().publish();
            this.getShortModel().publish();
            this.getPALongModel().publish();
            this.getSpacingModel().publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == RectangleEditor.NYQUIST_FID) {
            this.boListener.setEnabled(false);
            this.getRectangle().setSpacingToNyquist();
            this.boListener.setEnabled(true);
            this.getSpacingModel().publish();
            return null;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_NONSIDEREALMOTION)) {
            boolean bl = (Boolean)object;
            if (bl) {
                this.coordsModel.update(editor, CoordsEditor.FID_COORDS_TYPE, SkyCoordinatesData.TYPE_RELATIVE);
            }
            this.publish(fieldID, object);
        }
        return null;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        if (object != null) {
            Rectangle rectangle = this.getRectangle();
            this.getCoordsModel().setonlyDocument(rectangle);
            this.getLongModel().setonlyDocument((Object)rectangle.getLong());
            this.getShortModel().setonlyDocument((Object)rectangle.getShort());
            this.getPALongModel().setonlyDocument((Object)rectangle.getPALong());
            this.getSpacingModel().setonlyDocument(rectangle.getSpacing());
        }
    }

    @Override
    public void setDocument(Object object) {
        Rectangle rectangle = this.getRectangle();
        if (rectangle != null) {
            rectangle.removePropertyChangeListener(this.boListener);
        }
        if (object instanceof Rectangle) {
            Rectangle rectangle2 = (Rectangle)object;
            rectangle2.addPropertyChangeListener(this.boListener);
        }
        this.setonlyDocument(object);
        this.publish();
    }

    public void setIsMosaic(boolean bl) {
        Rectangle rectangle = this.getRectangle();
        if (null != rectangle) {
            rectangle.setIsMosaic(bl);
        }
    }

    public boolean isMosaic() {
        Rectangle rectangle = this.getRectangle();
        return null == rectangle ? true : rectangle.isMosaic();
    }

    public void setRectangleCoordinateSystem(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("coordinateSystem is marked non-null but is null");
        }
        Rectangle rectangle = this.getRectangle();
        if (rectangle == null) {
            return;
        }
        this.getCoordsModel().update(null, CoordsEditor.FID_COORDS_SYSTEM, string);
    }

    public ModelChangeSubscriber getUpdaterFor12mPointings() {
        return this.updaterFor12mPointings;
    }

    public CoordsModel getCoordsModel() {
        return this.coordsModel;
    }

    public ValueUnitPairModel getLongModel() {
        return this.longModel;
    }

    public ValueUnitPairModel getShortModel() {
        return this.shortModel;
    }

    public UserUnitValueUnitPairModel getSpacingModel() {
        return this.spacingModel;
    }

    public ModelChangeSubscriber getAcaEnabledUpdater() {
        return this.acaEnabledUpdater;
    }
}

