/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.ot.editors.misc.ValueUnitPairParser;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class SpectralWindowTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1209021921204253095L;
    private AbstractBaseBandConfig baseBandConfig = null;
    private final ValueUnitPairParser vupParser = new ValueUnitPairParser();

    public SpectralWindowTableModel(AbstractBaseBandConfig abstractBaseBandConfig) {
        this.setBaseBandConfig(abstractBaseBandConfig);
    }

    public void setBaseBandConfig(AbstractBaseBandConfig abstractBaseBandConfig) {
        this.baseBandConfig = abstractBaseBandConfig;
    }

    private boolean isAca() {
        return this.baseBandConfig == null ? false : this.baseBandConfig.isACA();
    }

    private int getSpectralWindowIndex(int n) {
        return n;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        SpectralWindowTableColumnDescriptor spectralWindowTableColumnDescriptor = SpectralWindowTableColumnDescriptor.getColumnDescriptor(n2);
        switch (spectralWindowTableColumnDescriptor.ordinal()) {
            case 0: {
                return true;
            }
            case 2: {
                return this.isSideBandEditable();
            }
            case 4: {
                return this.isSideBandEditable();
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return !this.isAca();
            }
        }
        return false;
    }

    private boolean isSideBandEditable() {
        if (this.baseBandConfig == null) {
            return false;
        }
        if (this.baseBandConfig.getDataProducts().equals(AbstractBaseBandConfig.DATAPRODUCTS_AUTO_ONLY)) {
            return false;
        }
        SpectralSpec spectralSpec = this.baseBandConfig.getSpectralSpec();
        if (spectralSpec != null) {
            String string = spectralSpec.getReceiverType();
            if (string.equals(SpectralSpec.RECEIVERTYPE_SSB)) {
                return false;
            }
            if (string.equals(SpectralSpec.RECEIVERTYPE_TSB)) {
                return false;
            }
            if (string.equals(SpectralSpec.RECEIVERTYPE_DSB) && this.baseBandConfig.isRejectionMode()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getColumnCount() {
        return SpectralWindowTableColumnDescriptor.getColumnCount();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        SpectralWindowTableColumnDescriptor spectralWindowTableColumnDescriptor = SpectralWindowTableColumnDescriptor.getColumnDescriptor(n);
        if (spectralWindowTableColumnDescriptor == null) {
            throw new RuntimeException("Invalid number of columns");
        }
        return spectralWindowTableColumnDescriptor.columnClass;
    }

    @Override
    public String getColumnName(int n) {
        SpectralWindowTableColumnDescriptor spectralWindowTableColumnDescriptor = SpectralWindowTableColumnDescriptor.getColumnDescriptor(n);
        if (spectralWindowTableColumnDescriptor == null) {
            return "<html><div align=center><font color=red>**ERROR**</font></div></html>";
        }
        return spectralWindowTableColumnDescriptor.columnName;
    }

    @Override
    public int getRowCount() {
        return this.getBaseBandConfig() == null ? 0 : this.getBaseBandConfig().getSpectralWindowCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SpectralWindowI spectralWindowI = this.getBaseBandConfig().getSpectralWindow(this.getSpectralWindowIndex(n));
        SpectralWindowTableColumnDescriptor spectralWindowTableColumnDescriptor = SpectralWindowTableColumnDescriptor.getColumnDescriptor(n2);
        switch (spectralWindowTableColumnDescriptor.ordinal()) {
            case 0: {
                return spectralWindowI.getCenterFrequency().getContentInMHz();
            }
            case 1: {
                return spectralWindowI.getRestFrequencyLSB();
            }
            case 2: {
                return spectralWindowI.getSideBandUse().usesLSB();
            }
            case 3: {
                return spectralWindowI.getRestFrequencyUSB();
            }
            case 4: {
                return spectralWindowI.getSideBandUse().usesUSB();
            }
            case 5: {
                Frequency frequency = spectralWindowI.getNominalBandwidth();
                frequency.convertToMHz();
                return frequency;
            }
            case 6: {
                return spectralWindowI.getNominalNumberOfChannels();
            }
            case 7: {
                Frequency frequency = spectralWindowI.getResolution().deepCopy().convertToFriendlyUnit();
                return String.format("%7.12f %s", frequency.getContent(), frequency.getUnit());
            }
            case 8: {
                return spectralWindowI.getPolnProducts();
            }
            case 9: {
                DataRate dataRate = spectralWindowI.getInstantaneousDataRate();
                if (dataRate == null) {
                    return "Error";
                }
                double d = dataRate.getContentInUnits(DataRate.UNIT_MB_S);
                if (d < 1.0) {
                    return String.format("%7.3f %s", dataRate.getContentInUnits(DataRate.UNIT_KB_S), DataRate.UNIT_KB_S);
                }
                return String.format("%7.3f %s", d, DataRate.UNIT_MB_S);
            }
        }
        return "<html><font color=\"red\">Error!</font></html>";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.getSpectralWindowIndex(n);
        SpectralWindowI spectralWindowI = this.getBaseBandConfig().getSpectralWindow(n3);
        SpectralWindowTableColumnDescriptor spectralWindowTableColumnDescriptor = SpectralWindowTableColumnDescriptor.getColumnDescriptor(n2);
        switch (spectralWindowTableColumnDescriptor.ordinal()) {
            case 0: {
                double d = (Double)object;
                spectralWindowI.getCenterFrequency().setContentInMHz(d);
                spectralWindowI.adjustCenterFrequency();
                break;
            }
            case 2: {
                boolean bl = (Boolean)object;
                SideBandUse sideBandUse = spectralWindowI.getSideBandUse().enableLSB(bl);
                spectralWindowI.changeSideBandUse(sideBandUse);
                break;
            }
            case 4: {
                boolean bl = (Boolean)object;
                SideBandUse sideBandUse = spectralWindowI.getSideBandUse().enableUSB(bl);
                spectralWindowI.changeSideBandUse(sideBandUse);
                break;
            }
            case 5: {
                Frequency frequency = null;
                if (object instanceof Frequency) {
                    frequency = (Frequency)((Object)object);
                } else {
                    String string = TextUtils.stripHtmlTags((String)object);
                    frequency = (Frequency)this.vupParser.parse(string, Frequency.class);
                }
                if (frequency == null) break;
                spectralWindowI.setBandParameters(frequency, spectralWindowI.getNominalNumberOfChannels(), SpectralWindowBand.ChannelType.NOMINAL);
                break;
            }
            case 6: {
                if (object == null) break;
                int n4 = 0;
                if (object instanceof Integer) {
                    n4 = (Integer)object;
                } else {
                    try {
                        n4 = Integer.parseInt(TextUtils.stripHtmlTags((String)object));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                spectralWindowI.setBandParameters(spectralWindowI.getNominalBandwidth(), n4, SpectralWindowBand.ChannelType.NOMINAL);
                break;
            }
            case 8: {
                if (object == null) break;
                spectralWindowI.setPolnProducts((String)object);
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public Object[] getLongValues() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (SpectralWindowTableColumnDescriptor spectralWindowTableColumnDescriptor : SpectralWindowTableColumnDescriptor.values()) {
            arrayList.add(spectralWindowTableColumnDescriptor.longValue);
        }
        Object[] objectArray = new Object[arrayList.size()];
        return arrayList.toArray(objectArray);
    }

    public void dataRateChanged() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.fireTableCellUpdated(i, SpectralWindowTableColumnDescriptor.DATARATE.ordinal());
        }
    }

    public AbstractBaseBandConfig getBaseBandConfig() {
        return this.baseBandConfig;
    }

    public static enum SpectralWindowTableColumnDescriptor {
        OFFSET("<html><div align=center>Offset<br>(MHz)</div></html>", Double.class, Double.valueOf("100.123456")),
        FSKY_LSB("<html><div align=center>LSB(Rest)</div></html>", Frequency.class, (Object)((Object)Frequency.createFrequencyGHZ(100.123))),
        USE_LSB("<html><div align=center>use<br>LSB</div></html>", Boolean.class, true),
        FSKY_USB("<html><div align=center>USB(Rest)</div></html>", Frequency.class, (Object)((Object)Frequency.createFrequencyGHZ(100.123))),
        USE_USB("<html><div align=center>use<br>USB</div></html>", Boolean.class, true),
        BANDWIDTH("<html><div align=center>Bandwidth</div></html>", Frequency.class, (Object)((Object)Frequency.createFrequencyMHZ(2000.0))),
        CHANNELS("<html><div align=center>Chs</div></html>", Integer.class, Integer.valueOf("8192")),
        RESOLUTION("<html><div align=center>Channel Spacing</div></html>", Frequency.class, (Object)((Object)Frequency.createFrequency((double)15.259, (String)Frequency.UNIT_KHZ))),
        POLARIZATION("<html><div align=center>Polarization</div></html>", String.class, "XX,YY,XY,YX"),
        DATARATE("<html><div align=center>Output Data Rate</div></html>", DataRate.class, (Object)((Object)DataRate.createDataRate((double)12.123, (String)DataRate.UNIT_MB_S)));

        public final String columnName;
        public final Class<?> columnClass;
        public final Object longValue;

        public static int getColumnCount() {
            return SpectralWindowTableColumnDescriptor.values().length;
        }

        public static SpectralWindowTableColumnDescriptor getColumnDescriptor(int n) {
            return SpectralWindowTableColumnDescriptor.values()[n];
        }

        public int getColumnIndex() {
            int n = 0;
            for (SpectralWindowTableColumnDescriptor spectralWindowTableColumnDescriptor : SpectralWindowTableColumnDescriptor.values()) {
                if (this == spectralWindowTableColumnDescriptor) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private SpectralWindowTableColumnDescriptor(String string2, Class<?> clazz, Object object) {
            this.columnName = string2;
            this.columnClass = clazz;
            this.longValue = object;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

