/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.gui.AvailableLinesTableFormat;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.ThreadedMatcherEditor;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import javax.swing.table.TableModel;

public class FilteredCatalogue {
    private final CompositeMatcherEditor<SpectralLine> composite = new CompositeMatcherEditor();
    private final SortedList<SpectralLine> sorted;
    private final FilterList<SpectralLine> filtered;

    public FilteredCatalogue(EventList<SpectralLine> eventList) {
        eventList.getReadWriteLock().writeLock().lock();
        try {
            this.sorted = new SortedList(eventList, null);
            this.filtered = new FilterList(this.sorted, (MatcherEditor)new ThreadedMatcherEditor(this.composite));
        }
        finally {
            eventList.getReadWriteLock().writeLock().unlock();
        }
    }

    public void addMatcherEditor(MatcherEditor<SpectralLine> matcherEditor) {
        EventList eventList = this.composite.getMatcherEditors();
        if (!eventList.contains(matcherEditor)) {
            eventList.add(matcherEditor);
        }
    }

    public boolean removeMatcherEditor(MatcherEditor<SpectralLine> matcherEditor) {
        EventList eventList = this.composite.getMatcherEditors();
        return eventList.remove(matcherEditor);
    }

    public SpectralLine get(int n) {
        if (n >= this.filtered.size()) {
            return null;
        }
        this.filtered.getReadWriteLock().readLock().lock();
        try {
            SpectralLine spectralLine = (SpectralLine)this.filtered.get(n);
            return spectralLine;
        }
        finally {
            this.filtered.getReadWriteLock().readLock().unlock();
        }
    }

    public SortedList<SpectralLine> getSorted() {
        return this.sorted;
    }

    public TableModel getTableModel(Velocity velocity) {
        return new EventTableModel(this.filtered, (TableFormat)new AvailableLinesTableFormat(velocity));
    }

    public EventSelectionModel<SpectralLine> getSelectionModel() {
        return new EventSelectionModel(this.filtered);
    }
}

