/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import ca.odell.glazedlists.matchers.Matcher;

public class UpperStateEnergyMatcher
implements Matcher<SpectralLine> {
    private Double minEnergy;
    private Double maxEnergy;

    public UpperStateEnergyMatcher(Double d, Double d2) {
        this.minEnergy = d;
        this.maxEnergy = d2;
    }

    public boolean matches(SpectralLine spectralLine) {
        Double d = spectralLine.getUpperStateEnergy();
        if (d == null) {
            return true;
        }
        if (this.maxEnergy > 0.0 && this.minEnergy > this.maxEnergy) {
            return false;
        }
        if (this.maxEnergy == 0.0) {
            return d >= this.minEnergy;
        }
        return this.minEnergy <= d && d <= this.maxEnergy;
    }
}

