/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class TargetCache {
    private Map<SBGeneratorTemplate.SchedBlockType, Set<Target>> targetCacheMap = new ConcurrentHashMap<SBGeneratorTemplate.SchedBlockType, Set<Target>>();
    private static TargetCache targetCache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TargetCache getInstance() {
        if (targetCache != null) return targetCache;
        Class<TargetCache> clazz = TargetCache.class;
        synchronized (TargetCache.class) {
            if (targetCache != null) return targetCache;
            targetCache = new TargetCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return targetCache;
        }
    }

    private TargetCache() {
        this.clearCache();
    }

    public synchronized void addTarget(@NonNull Target target, @NonNull SBGeneratorTemplate.SchedBlockType schedBlockType) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (schedBlockType == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.targetCacheMap.get((Object)schedBlockType).add(target);
    }

    public Target getTarget(@NonNull Target target, @NonNull SBGeneratorTemplate.SchedBlockType schedBlockType) throws TargetNotFoundException {
        if (target == null) {
            throw new NullPointerException("targetToFind is marked non-null but is null");
        }
        if (schedBlockType == null) {
            throw new NullPointerException("schedBlockType is marked non-null but is null");
        }
        if (this.targetCacheMap.containsKey((Object)schedBlockType)) {
            String string = target.getFieldSource().getSourceName();
            Set<Target> set = this.targetCacheMap.get((Object)schedBlockType);
            for (Target target2 : set) {
                if (!target2.getFieldSource().getSourceName().equals(string)) continue;
                return target2;
            }
        }
        throw new TargetNotFoundException();
    }

    public synchronized void clearCache() {
        this.targetCacheMap = new ConcurrentHashMap<SBGeneratorTemplate.SchedBlockType, Set<Target>>();
        for (SBGeneratorTemplate.SchedBlockType schedBlockType : SBGeneratorTemplate.SchedBlockType.values()) {
            this.targetCacheMap.put(schedBlockType, new HashSet());
        }
    }

    public class TargetNotFoundException
    extends Exception {
    }
}

