/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.JointProposalPartner;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class JointProposalSummaryParameters
implements SummaryDocument {
    private JointProposal jointProposal = null;
    private boolean isJointProposalToBeReported = false;
    private boolean isJointProposalJustificationsToReported = false;
    private final List<PartnerRequestedTimes> jointProposalPartners = new ArrayList<PartnerRequestedTimes>();
    private final ObsProposal obsProposal;

    public JointProposalSummaryParameters(@NonNull ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        this.obsProposal = obsProposal;
    }

    @Override
    public BusinessObject getUserObject() {
        return this.jointProposal;
    }

    @Override
    public void collectInfo() {
        this.jointProposal = this.getObsProposal().getJointProposal();
        this.jointProposalPartners.clear();
        if (this.jointProposal instanceof JointProposal) {
            PartnerRequestedTimes.PartnerRequestedTimesBuilder partnerRequestedTimesBuilder;
            this.isJointProposalToBeReported = this.jointProposal.getIsJointProposal();
            if (!this.isJointProposalToBeReported) {
                return;
            }
            this.isJointProposalJustificationsToReported = this.jointProposal.isMainJointProposal();
            for (JointProposalPartner jointProposalPartner : this.jointProposal.getJointProposalPartner()) {
                partnerRequestedTimesBuilder = new PartnerRequestedTimes.PartnerRequestedTimesBuilder();
                String string = jointProposalPartner.getObservatory();
                partnerRequestedTimesBuilder.justification(jointProposalPartner.getJustification()).partnerObservatory(string).isMainObservatory(jointProposalPartner.getIsMainObservatory());
                Time time = jointProposalPartner.getRequestedTime();
                partnerRequestedTimesBuilder.requestedTime(String.format("%.3g %s", time.getContentInUnits(time.getUnit()), time.getUnit()));
                partnerRequestedTimesBuilder.justificationLabel("Justification for " + string + " time");
                this.jointProposalPartners.add(partnerRequestedTimesBuilder.build());
            }
            for (OTConfiguration.TelescopePolicies.JointProposal.PartnerObservatory partnerObservatory : AlmaPolicies.getInstance().getJointProposalPartners()) {
                if (partnerObservatory.getObservatory().equals("ALMA") || !this.jointProposalPartners.stream().noneMatch(partnerRequestedTimes -> partnerRequestedTimes.getPartnerObservatory().equals(partnerObservatory.getObservatory()))) continue;
                partnerRequestedTimesBuilder = new PartnerRequestedTimes.PartnerRequestedTimesBuilder();
                partnerRequestedTimesBuilder.partnerObservatory(partnerObservatory.getObservatory()).isPartnerUsed(true).requestedTime("").isPartnerTAToBeUsed(false);
                this.jointProposalPartners.add(partnerRequestedTimesBuilder.build());
            }
        }
    }

    @Override
    public String getTitle() {
        return this.getJointProposal().isMainJointProposal() ? "Joint Proposal (Main) Summary" : "Joint Proposal (Partner) Summary";
    }

    @Override
    public ProblemListModel getProblems() {
        return null;
    }

    public JointProposal getJointProposal() {
        return this.jointProposal;
    }

    public void setJointProposal(JointProposal jointProposal) {
        this.jointProposal = jointProposal;
    }

    public boolean isJointProposalToBeReported() {
        return this.isJointProposalToBeReported;
    }

    public boolean isJointProposalJustificationsToReported() {
        return this.isJointProposalJustificationsToReported;
    }

    public List<PartnerRequestedTimes> getJointProposalPartners() {
        return this.jointProposalPartners;
    }

    public ObsProposal getObsProposal() {
        return this.obsProposal;
    }

    public static class PartnerRequestedTimes {
        private boolean isPartnerTAToBeUsed;
        private boolean isPartnerUsed;
        private boolean isMainObservatory;
        private String requestedTime;
        private String partnerObservatory;
        private String justification;
        private String justificationLabel;

        private static boolean $default$isPartnerTAToBeUsed() {
            return true;
        }

        private static boolean $default$isPartnerUsed() {
            return true;
        }

        private static boolean $default$isMainObservatory() {
            return false;
        }

        private static String $default$requestedTime() {
            return "";
        }

        private static String $default$partnerObservatory() {
            return "";
        }

        private static String $default$justification() {
            return "";
        }

        private static String $default$justificationLabel() {
            return "";
        }

        PartnerRequestedTimes(boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3, String string4) {
            this.isPartnerTAToBeUsed = bl;
            this.isPartnerUsed = bl2;
            this.isMainObservatory = bl3;
            this.requestedTime = string;
            this.partnerObservatory = string2;
            this.justification = string3;
            this.justificationLabel = string4;
        }

        public static PartnerRequestedTimesBuilder builder() {
            return new PartnerRequestedTimesBuilder();
        }

        public boolean isPartnerTAToBeUsed() {
            return this.isPartnerTAToBeUsed;
        }

        public boolean isPartnerUsed() {
            return this.isPartnerUsed;
        }

        public boolean isMainObservatory() {
            return this.isMainObservatory;
        }

        public String getRequestedTime() {
            return this.requestedTime;
        }

        public String getPartnerObservatory() {
            return this.partnerObservatory;
        }

        public String getJustification() {
            return this.justification;
        }

        public String getJustificationLabel() {
            return this.justificationLabel;
        }

        public void setPartnerTAToBeUsed(boolean bl) {
            this.isPartnerTAToBeUsed = bl;
        }

        public void setPartnerUsed(boolean bl) {
            this.isPartnerUsed = bl;
        }

        public void setMainObservatory(boolean bl) {
            this.isMainObservatory = bl;
        }

        public void setRequestedTime(String string) {
            this.requestedTime = string;
        }

        public void setPartnerObservatory(String string) {
            this.partnerObservatory = string;
        }

        public void setJustification(String string) {
            this.justification = string;
        }

        public void setJustificationLabel(String string) {
            this.justificationLabel = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PartnerRequestedTimes)) {
                return false;
            }
            PartnerRequestedTimes partnerRequestedTimes = (PartnerRequestedTimes)object;
            if (!partnerRequestedTimes.canEqual(this)) {
                return false;
            }
            if (this.isPartnerTAToBeUsed() != partnerRequestedTimes.isPartnerTAToBeUsed()) {
                return false;
            }
            if (this.isPartnerUsed() != partnerRequestedTimes.isPartnerUsed()) {
                return false;
            }
            if (this.isMainObservatory() != partnerRequestedTimes.isMainObservatory()) {
                return false;
            }
            String string = this.getRequestedTime();
            String string2 = partnerRequestedTimes.getRequestedTime();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getPartnerObservatory();
            String string4 = partnerRequestedTimes.getPartnerObservatory();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                return false;
            }
            String string5 = this.getJustification();
            String string6 = partnerRequestedTimes.getJustification();
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                return false;
            }
            String string7 = this.getJustificationLabel();
            String string8 = partnerRequestedTimes.getJustificationLabel();
            return !(string7 == null ? string8 != null : !string7.equals(string8));
        }

        protected boolean canEqual(Object object) {
            return object instanceof PartnerRequestedTimes;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isPartnerTAToBeUsed() ? 79 : 97);
            n = n * 59 + (this.isPartnerUsed() ? 79 : 97);
            n = n * 59 + (this.isMainObservatory() ? 79 : 97);
            String string = this.getRequestedTime();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getPartnerObservatory();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            String string3 = this.getJustification();
            n = n * 59 + (string3 == null ? 43 : string3.hashCode());
            String string4 = this.getJustificationLabel();
            n = n * 59 + (string4 == null ? 43 : string4.hashCode());
            return n;
        }

        public String toString() {
            return "JointProposalSummaryParameters.PartnerRequestedTimes(isPartnerTAToBeUsed=" + this.isPartnerTAToBeUsed() + ", isPartnerUsed=" + this.isPartnerUsed() + ", isMainObservatory=" + this.isMainObservatory() + ", requestedTime=" + this.getRequestedTime() + ", partnerObservatory=" + this.getPartnerObservatory() + ", justification=" + this.getJustification() + ", justificationLabel=" + this.getJustificationLabel() + ")";
        }

        public static class PartnerRequestedTimesBuilder {
            private boolean isPartnerTAToBeUsed$set;
            private boolean isPartnerTAToBeUsed$value;
            private boolean isPartnerUsed$set;
            private boolean isPartnerUsed$value;
            private boolean isMainObservatory$set;
            private boolean isMainObservatory$value;
            private boolean requestedTime$set;
            private String requestedTime$value;
            private boolean partnerObservatory$set;
            private String partnerObservatory$value;
            private boolean justification$set;
            private String justification$value;
            private boolean justificationLabel$set;
            private String justificationLabel$value;

            PartnerRequestedTimesBuilder() {
            }

            public PartnerRequestedTimesBuilder isPartnerTAToBeUsed(boolean bl) {
                this.isPartnerTAToBeUsed$value = bl;
                this.isPartnerTAToBeUsed$set = true;
                return this;
            }

            public PartnerRequestedTimesBuilder isPartnerUsed(boolean bl) {
                this.isPartnerUsed$value = bl;
                this.isPartnerUsed$set = true;
                return this;
            }

            public PartnerRequestedTimesBuilder isMainObservatory(boolean bl) {
                this.isMainObservatory$value = bl;
                this.isMainObservatory$set = true;
                return this;
            }

            public PartnerRequestedTimesBuilder requestedTime(String string) {
                this.requestedTime$value = string;
                this.requestedTime$set = true;
                return this;
            }

            public PartnerRequestedTimesBuilder partnerObservatory(String string) {
                this.partnerObservatory$value = string;
                this.partnerObservatory$set = true;
                return this;
            }

            public PartnerRequestedTimesBuilder justification(String string) {
                this.justification$value = string;
                this.justification$set = true;
                return this;
            }

            public PartnerRequestedTimesBuilder justificationLabel(String string) {
                this.justificationLabel$value = string;
                this.justificationLabel$set = true;
                return this;
            }

            public PartnerRequestedTimes build() {
                boolean bl = this.isPartnerTAToBeUsed$value;
                if (!this.isPartnerTAToBeUsed$set) {
                    bl = PartnerRequestedTimes.$default$isPartnerTAToBeUsed();
                }
                boolean bl2 = this.isPartnerUsed$value;
                if (!this.isPartnerUsed$set) {
                    bl2 = PartnerRequestedTimes.$default$isPartnerUsed();
                }
                boolean bl3 = this.isMainObservatory$value;
                if (!this.isMainObservatory$set) {
                    bl3 = PartnerRequestedTimes.$default$isMainObservatory();
                }
                String string = this.requestedTime$value;
                if (!this.requestedTime$set) {
                    string = PartnerRequestedTimes.$default$requestedTime();
                }
                String string2 = this.partnerObservatory$value;
                if (!this.partnerObservatory$set) {
                    string2 = PartnerRequestedTimes.$default$partnerObservatory();
                }
                String string3 = this.justification$value;
                if (!this.justification$set) {
                    string3 = PartnerRequestedTimes.$default$justification();
                }
                String string4 = this.justificationLabel$value;
                if (!this.justificationLabel$set) {
                    string4 = PartnerRequestedTimes.$default$justificationLabel();
                }
                return new PartnerRequestedTimes(bl, bl2, bl3, string, string2, string3, string4);
            }

            public String toString() {
                return "JointProposalSummaryParameters.PartnerRequestedTimes.PartnerRequestedTimesBuilder(isPartnerTAToBeUsed$value=" + this.isPartnerTAToBeUsed$value + ", isPartnerUsed$value=" + this.isPartnerUsed$value + ", isMainObservatory$value=" + this.isMainObservatory$value + ", requestedTime$value=" + this.requestedTime$value + ", partnerObservatory$value=" + this.partnerObservatory$value + ", justification$value=" + this.justification$value + ", justificationLabel$value=" + this.justificationLabel$value + ")";
            }
        }
    }
}

