/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.exceptions;

import alma.ACSErr.ErrorTrace;
import alma.acs.exceptions.AcsJException;
import alma.acs.exceptions.DefaultAcsJException;
import alma.acs.exceptions.ErrorTraceManipulator;
import alma.acs.util.UTCUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.omg.CORBA.UserException;

public class CorbaExceptionConverter {
    public static final String PROPERTY_JAVAEXCEPTION_CLASS = "javaex.class";
    public static final String PROPERTY_JAVAEXCEPTION_MESSAGE = "javaex.msg";

    static Throwable recursiveGetThrowable(ErrorTrace et) {
        String classname = ErrorTraceManipulator.getProperty(et, PROPERTY_JAVAEXCEPTION_CLASS);
        Object message = ErrorTraceManipulator.getProperty(et, PROPERTY_JAVAEXCEPTION_MESSAGE);
        if (message == null) {
            message = "";
        }
        Throwable thr = null;
        if (classname != null) {
            try {
                Class<Throwable> exClass = Class.forName(classname).asSubclass(Throwable.class);
                if (AcsJException.class.isAssignableFrom(exClass)) {
                    if (exClass != DefaultAcsJException.class) {
                        Constructor<Throwable> msgCtor = exClass.getConstructor(String.class);
                        thr = msgCtor.newInstance(message);
                    }
                } else {
                    thr = new DefaultAcsJException((String)message, 0, 0, et.shortDescription, classname);
                }
            }
            catch (Exception e) {
                message = "failed to reconstruct Java exception '" + classname + "'. Original msg was '" + (String)message + "'.";
            }
        }
        if (thr == null) {
            thr = new DefaultAcsJException((String)message, et.errorType, et.errorCode, et.shortDescription);
        }
        CorbaExceptionConverter.resurrectThrowable(thr, et);
        return thr;
    }

    private static void resurrectThrowable(Throwable thr, ErrorTrace et) {
        ErrorTrace etCause;
        if (thr == null || et == null) {
            throw new NullPointerException("resurrectThrowable: parameters must not be null!");
        }
        if (thr instanceof AcsJException) {
            AcsJException acsJEx = (AcsJException)thr;
            acsJEx.m_host = et.host;
            acsJEx.m_process = et.process;
            acsJEx.m_file = et.file;
            acsJEx.m_method = et.routine;
            acsJEx.m_line = et.lineNum;
            acsJEx.m_severity = et.severity;
            acsJEx.m_threadName = et.thread;
            acsJEx.m_timeMilli = UTCUtility.utcOmgToJava((long)et.timeStamp);
            acsJEx.m_properties = ErrorTraceManipulator.getProperties(et);
        }
        StackTraceElement[] stackTrace = new StackTraceElement[]{new StackTraceElement("---", et.routine, et.file, et.lineNum)};
        thr.setStackTrace(stackTrace);
        if (et.previousError != null && et.previousError.length > 0 && et.previousError[0] != null && (etCause = et.previousError[0]) != null) {
            Throwable thrCause = CorbaExceptionConverter.recursiveGetThrowable(etCause);
            thr.initCause(thrCause);
        }
    }

    public static void convertErrorTraceToJavaException(ErrorTrace et, AcsJException jEx) {
        CorbaExceptionConverter.resurrectThrowable(jEx, et);
    }

    public static Throwable convertHiddenErrorTrace(Throwable thr) {
        if (thr == null) {
            return null;
        }
        if (UserException.class.isAssignableFrom(thr.getClass())) {
            try {
                Field errorTraceField = thr.getClass().getField("errorTrace");
                ErrorTrace etCause = (ErrorTrace)errorTraceField.get(thr);
                thr = CorbaExceptionConverter.recursiveGetThrowable(etCause);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return thr;
    }
}

