/*
 * Decompiled with CFR 0.152.
 */
package alma.hla.runtime.obsprep.bo;

import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.interfaces.ModelStructureNotifier;
import alma.hla.runtime.obsprep.util.XmlConversionException;
import alma.hla.runtime.obsprep.util.XmlMarshaller;
import alma.obsprep.bo.obsproject.ObsProject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BusinessObject
implements IBusinessObject {
    protected Object storageObject;
    public Referring referrers = new Referring();
    private Map<String, Object> nameValuePairs = new TreeMap<String, Object>();
    private static volatile AtomicInteger propertyChangeEnabled = new AtomicInteger(0);
    private final transient Vector<PropertyChangeListener> pclisteners = new Vector();
    private volatile transient PropertyChangeListener[] pclisteners_ro = new PropertyChangeListener[0];
    public static volatile TracingInterface tracingIF;

    protected BusinessObject(Object castorObject) {
        this.storageObject = castorObject;
    }

    public String getName() {
        return null;
    }

    public String getShortClassName() {
        String result = this.getClass().getName();
        int l = result.lastIndexOf(46);
        result = result.substring(l + 1);
        return result;
    }

    public String getNameOrDefault() {
        String name = this.getName();
        if ((name == null || name.length() == 0 || name.trim().length() == 0) && (name = this.getShortClassName()).startsWith("Obs") && name.length() > 3) {
            name = name.substring(3);
        }
        return name;
    }

    public boolean isSpatial() {
        return true;
    }

    public boolean isSpectral() {
        return !this.isSpatial();
    }

    public BusinessObject getSpatial() {
        if (this.isSpatial()) {
            return this;
        }
        return null;
    }

    public BusinessObject getSpectral() {
        if (this.isSpectral()) {
            return this;
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String cn = this.getClass().getName();
        b.append(cn.substring(cn.lastIndexOf(46, cn.lastIndexOf(46) - 1) + 1));
        b.append("[");
        b.append("name=").append(this.getName());
        if (this instanceof Entity) {
            b.append(", eid=").append(((Entity)((Object)this)).getEntityID());
        }
        if (this instanceof EntityPart) {
            b.append(", epid=").append(((EntityPart)((Object)this)).getEntityPartId());
        }
        b.append(", idhash=").append(System.identityHashCode(this));
        b.append("]");
        return b.toString();
    }

    public String toXml() throws XmlConversionException {
        XmlMarshaller m = new XmlMarshaller();
        String xml = m.marshalToString(this.getCastorObject());
        return xml;
    }

    public String toTreeString(int phase, boolean userView, boolean expanded) {
        return this.getNameOrDefault();
    }

    protected void initAsNew() {
    }

    protected void initAttribsAndPartsFrom(IBusinessObject original, Copier copier) {
    }

    protected void initEntityReferencesFrom(IBusinessObject original, Copier copier) {
    }

    protected BusinessObject invokeCreateUnitialized() throws CopyException {
        throw new CopyException("no invokeCreateUnitialized() implemention available for this object: " + String.valueOf(this));
    }

    @Override
    public IBusinessObject deepCopy() throws CopyException {
        Copier copier = new Copier();
        return copier.copy(this);
    }

    public void updateLocalReference() {
    }

    public void addedTo(IBusinessObject bo, Referring.By by, int index) {
        TracingInterface tif = tracingIF;
        if (tif != null) {
            tif.structureChanged(true, this, bo, by);
        }
        if (bo == null) {
            throw new NullPointerException("added to null? by=" + String.valueOf((Object)by) + ", at " + index);
        }
        this.referrers.add(bo, by);
        ObsProject ancestor = ((BusinessObject)bo).findProject();
        if (ancestor != null && ancestor instanceof ModelStructureNotifier) {
            ((ModelStructureNotifier)ancestor).fireBusinessObjectAddedTo(this, bo, by, index);
        }
    }

    public void removedFrom(IBusinessObject bo, Referring.By by) {
        TracingInterface tif = tracingIF;
        if (tif != null) {
            tif.structureChanged(false, this, bo, by);
        }
        if (bo == null) {
            throw new NullPointerException("removed from null? by=" + String.valueOf((Object)by));
        }
        this.referrers.remove(bo, by);
        ObsProject ancestor = ((BusinessObject)bo).findProject();
        if (ancestor == null) {
            ancestor = this.findProject();
        }
        if (ancestor != null && ancestor instanceof ModelStructureNotifier) {
            ((ModelStructureNotifier)ancestor).fireBusinessObjectRemovedFrom(this, bo, by);
        }
    }

    @Override
    public ObsProject findProject() {
        BusinessObject root;
        BusinessObject curr = this;
        do {
            root = curr;
        } while ((curr = curr.getParent()) != null);
        if (root instanceof ObsProject) {
            return (ObsProject)root;
        }
        List<IBusinessObject> proj = root.referrers.get(ObsProject.class);
        if (!proj.isEmpty()) {
            return (ObsProject)proj.get(0);
        }
        return null;
    }

    public List<IBusinessObject> findPathFromRoot() {
        ArrayList<IBusinessObject> ret = new ArrayList<IBusinessObject>();
        BusinessObject curr = this;
        do {
            ret.add(curr);
        } while ((curr = curr.getParent()) != null);
        Collections.reverse(ret);
        return ret;
    }

    @Override
    public Entity findEntity() {
        BusinessObject curr;
        for (curr = this; !(curr instanceof Entity) && curr != null; curr = curr.getParent()) {
        }
        return (Entity)((Object)curr);
    }

    public BusinessObject getParent() {
        return (BusinessObject)this.referrers.getParent();
    }

    @Override
    public List<IBusinessObject> referencedBOs(Referring.By ... by) {
        return new ArrayList<IBusinessObject>();
    }

    public List<IBusinessObject> associatedObjects() {
        return this.referencedBOs(Referring.By.UmlComposition, Referring.By.UmlUnidir);
    }

    public void wrapObjects(ReferenceablesMap referencedObjects, List<ReferenceableProxy<? extends IBusinessObject>> referrers) {
    }

    protected boolean addToCollection(Collection c, Object o) {
        if (o == null) {
            return false;
        }
        boolean ret = false;
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                ret |= c.add(array[i]);
            }
        } else {
            ret = c.add(o);
        }
        return ret;
    }

    public void setNameValue(String name, Object value) {
        this.nameValuePairs.put(name, value);
    }

    public Object getNameValue(String name) {
        return this.nameValuePairs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean enablePropertyChangeEvents(boolean enable) {
        boolean ret;
        AtomicInteger atomicInteger = propertyChangeEnabled;
        synchronized (atomicInteger) {
            int counterValue = 0;
            if (enable) {
                if (propertyChangeEnabled.get() > 0) {
                    counterValue = propertyChangeEnabled.decrementAndGet();
                }
            } else {
                counterValue = propertyChangeEnabled.incrementAndGet();
            }
            ret = counterValue == 0;
        }
        return ret;
    }

    protected void firePropertyChangeEvent(Object source, String property, Object newValue) {
        PropertyChangeListener[] listeners;
        TracingInterface tif = tracingIF;
        if (tif != null) {
            tif.propertyChanged(source, property, newValue);
        }
        if ((listeners = this.pclisteners_ro).length > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(source, property, null, newValue);
            for (PropertyChangeListener pcl : listeners) {
                pcl.propertyChange(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        Vector<PropertyChangeListener> vector = this.pclisteners;
        synchronized (vector) {
            this.pclisteners.add(pcl);
            Object[] new_ro = new PropertyChangeListener[this.pclisteners.size()];
            this.pclisteners.copyInto(new_ro);
            this.pclisteners_ro = new_ro;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        Vector<PropertyChangeListener> vector = this.pclisteners;
        synchronized (vector) {
            this.pclisteners.remove(pcl);
            Object[] new_ro = new PropertyChangeListener[this.pclisteners.size()];
            this.pclisteners.copyInto(new_ro);
            this.pclisteners_ro = new_ro;
        }
    }

    public static interface TracingInterface {
        public void structureChanged(boolean var1, BusinessObject var2, IBusinessObject var3, Referring.By var4);

        public void propertyChanged(Object var1, String var2, Object var3);
    }
}

