/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheDispatcher;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheDispatcher;
import org.apache.commons.jcs3.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;
import org.apache.commons.jcs3.auxiliary.remote.util.RemoteCacheRequestFactory;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class RemoteHttpCacheClient<K, V>
implements IRemoteHttpCacheClient<K, V> {
    private static final Log log = LogManager.getLog(RemoteHttpCacheClient.class);
    private IRemoteCacheDispatcher remoteDispatcher;
    private RemoteHttpCacheAttributes remoteHttpCacheAttributes;
    private boolean initialized = false;

    public RemoteHttpCacheClient() {
    }

    public RemoteHttpCacheClient(RemoteHttpCacheAttributes attributes) {
        this.setRemoteHttpCacheAttributes(attributes);
        this.initialize(attributes);
    }

    @Override
    public void initialize(RemoteHttpCacheAttributes attributes) {
        this.setRemoteDispatcher(new RemoteHttpCacheDispatcher(attributes));
        log.info("Created remote Dispatcher. {0}", () -> this.getRemoteDispatcher());
        this.setInitialized(true);
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key) throws IOException {
        return this.get(cacheName, key, 0L);
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized. Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createGetRequest(cacheName, key, requesterId);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        log.debug("Get [{0}] = {1}", key, remoteHttpCacheResponse);
        if (remoteHttpCacheResponse != null) {
            return (ICacheElement)remoteHttpCacheResponse.getPayload();
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern) throws IOException {
        return this.getMatching(cacheName, pattern, 0L);
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized. Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createGetMatchingRequest(cacheName, pattern, requesterId);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        log.debug("GetMatching [{0}] = {1}", pattern, remoteHttpCacheResponse);
        return (Map)remoteHttpCacheResponse.getPayload();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys) throws IOException {
        return this.getMultiple(cacheName, keys, 0L);
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createGetMultipleRequest(cacheName, keys, requesterId);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        log.debug("GetMultiple [{0}] = {1}", keys, remoteHttpCacheResponse);
        return (Map)remoteHttpCacheResponse.getPayload();
    }

    @Override
    public void remove(String cacheName, K key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    @Override
    public void remove(String cacheName, K key, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createRemoveRequest(cacheName, key, requesterId);
        this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
    }

    @Override
    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    @Override
    public void removeAll(String cacheName, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createRemoveAllRequest(cacheName, requesterId);
        this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
    }

    @Override
    public void update(ICacheElement<K, V> item) throws IOException {
        this.update(item, 0L);
    }

    @Override
    public void update(ICacheElement<K, V> cacheElement, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest<K, V> remoteHttpCacheRequest = RemoteCacheRequestFactory.createUpdateRequest(cacheElement, requesterId);
        this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
    }

    @Override
    public void dispose(String cacheName) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createDisposeRequest(cacheName, 0L);
        this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
    }

    @Override
    public void release() throws IOException {
    }

    @Override
    public Set<K> getKeySet(String cacheName) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest<String, String> remoteHttpCacheRequest = RemoteCacheRequestFactory.createGetKeySetRequest(cacheName, 0L);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        if (remoteHttpCacheResponse != null && remoteHttpCacheResponse.getPayload() != null) {
            return (Set)remoteHttpCacheResponse.getPayload();
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isAlive() throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn(message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createAliveCheckRequest(0L);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        if (remoteHttpCacheResponse != null) {
            return remoteHttpCacheResponse.isSuccess();
        }
        return false;
    }

    public void setRemoteDispatcher(IRemoteCacheDispatcher remoteDispatcher) {
        this.remoteDispatcher = remoteDispatcher;
    }

    public IRemoteCacheDispatcher getRemoteDispatcher() {
        return this.remoteDispatcher;
    }

    public void setRemoteHttpCacheAttributes(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        this.remoteHttpCacheAttributes = remoteHttpCacheAttributes;
    }

    public RemoteHttpCacheAttributes getRemoteHttpCacheAttributes() {
        return this.remoteHttpCacheAttributes;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }
}

