/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import uk.ac.starlink.votable.Decoder;

abstract class CharDecoders {
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$uk$ac$starlink$votable$CharDecoders;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    CharDecoders() {
    }

    public static Decoder makeCharDecoder(long[] arraysize) {
        CharReader cread = new CharReader(){

            public char readCharFromStream(DataInput strm) throws IOException {
                return (char)(strm.readByte() & 0xFF);
            }
        };
        return CharDecoders.makeDecoder(arraysize, cread);
    }

    public static Decoder makeUnicodeCharDecoder(long[] arraysize) {
        CharReader cread = new CharReader(){

            public char readCharFromStream(DataInput strm) throws IOException {
                return strm.readChar();
            }
        };
        return CharDecoders.makeDecoder(arraysize, cread);
    }

    private static Decoder makeDecoder(long[] arraysize, CharReader cread) {
        int ndim = arraysize.length;
        if (ndim == 0 || ndim == 1 && arraysize[0] == 1L) {
            return new ScalarCharDecoder(cread);
        }
        if (ndim == 1 && arraysize[0] == -2L) {
            return new ScalarStringDecoder(arraysize, cread){

                public Object decodeStream(DataInput strm) throws IOException {
                    throw new RuntimeException("Refuse to decode assumed char arraysize - try -Dvotable.strict=true");
                }
            };
        }
        if (ndim == 1) {
            return new ScalarStringDecoder(arraysize, cread);
        }
        return new StringDecoder(arraysize, cread);
    }

    private static class StringDecoder
    extends Decoder {
        final CharReader cread;
        final long[] decodedShape;
        final boolean isVariable;
        int fixedSize;

        StringDecoder(long[] arraysize, CharReader cread) {
            super(array$Ljava$lang$String == null ? (array$Ljava$lang$String = CharDecoders.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, arraysize);
            this.cread = cread;
            int ndim = arraysize.length;
            this.decodedShape = new long[ndim - 1];
            System.arraycopy(arraysize, 1, this.decodedShape, 0, ndim - 1);
            boolean bl = this.isVariable = arraysize[ndim - 1] < 0L;
            if (!this.isVariable) {
                this.fixedSize = 1;
                for (int i = 0; i < arraysize.length; ++i) {
                    this.fixedSize = (int)((long)this.fixedSize * arraysize[i]);
                }
            }
        }

        public long[] getDecodedShape() {
            return this.decodedShape;
        }

        public int getElementSize() {
            return (int)this.arraysize[0];
        }

        public int getNumItems(DataInput strm) throws IOException {
            return this.isVariable ? super.getNumItems(strm) : this.fixedSize;
        }

        public Object decodeString(String txt) {
            return this.makeStrings(txt);
        }

        public Object decodeStream(DataInput strm) throws IOException {
            int num = this.getNumItems(strm);
            StringBuffer sbuf = new StringBuffer(num);
            for (int i = 0; i < num; ++i) {
                sbuf.append(this.cread.readCharFromStream(strm));
            }
            return this.makeStrings(sbuf);
        }

        public String[] makeStrings(CharSequence txt) {
            int ntok = txt.length();
            int ncell = this.numCells(ntok);
            int sleng = (int)this.arraysize[0];
            int nstr = ncell / sleng;
            String[] result = new String[nstr];
            int k = 0;
            char[] buf = new char[sleng];
            for (int i = 0; i < nstr && k < ntok; ++i) {
                char c;
                int leng = 0;
                while (leng < sleng && k < ntok && (c = txt.charAt(k++)) != '\u0000') {
                    buf[leng++] = c;
                }
                while (leng > 0 && buf[leng - 1] == ' ') {
                    --leng;
                }
                if (leng > 0) {
                    result[i] = new String(buf, 0, leng);
                }
                k = (i + 1) * sleng;
            }
            return result;
        }

        public boolean isNull(Object array, int index) {
            return false;
        }

        public void setNullValue(String txt) {
        }
    }

    private static class ScalarStringDecoder
    extends Decoder {
        final CharReader cread;

        ScalarStringDecoder(long[] arraysize, CharReader cread) {
            super(class$java$lang$String == null ? (class$java$lang$String = CharDecoders.class$("java.lang.String")) : class$java$lang$String, arraysize);
            this.cread = cread;
        }

        public long[] getDecodedShape() {
            return SCALAR_SIZE;
        }

        public int getElementSize() {
            return (int)this.arraysize[0];
        }

        public Object decodeString(String txt) {
            return txt;
        }

        public Object decodeStream(DataInput strm) throws IOException {
            int i;
            int num = this.getNumItems(strm);
            StringBuffer data = new StringBuffer(num);
            for (i = 0; i < num; ++i) {
                char c = this.cread.readCharFromStream(strm);
                if (c == '\u0000') break;
                data.append(c);
            }
            while (i < num) {
                this.cread.readCharFromStream(strm);
                ++i;
            }
            return new String(data);
        }

        String makeString(CharSequence txt) {
            char c;
            int leng = 0;
            int sleng = txt.length();
            char[] buf = new char[sleng];
            for (int i = 0; i < sleng && (c = txt.charAt(i)) != '\u0000'; ++i) {
                buf[leng++] = c;
            }
            while (leng > 0 && buf[leng - 1] == ' ') {
                --leng;
            }
            return leng > 0 ? new String(buf, 0, leng) : null;
        }

        public boolean isNull(Object array, int index) {
            return false;
        }

        public void setNullValue(String txt) {
        }
    }

    private static class ScalarCharDecoder
    extends Decoder {
        final CharReader cread;
        static final /* synthetic */ boolean $assertionsDisabled;

        ScalarCharDecoder(CharReader cread) {
            super(class$java$lang$Character == null ? (class$java$lang$Character = CharDecoders.class$("java.lang.Character")) : class$java$lang$Character, SCALAR_SIZE);
            this.cread = cread;
        }

        public Object decodeString(String txt) {
            return new Character(txt.length() > 0 ? txt.charAt(0) : (char)'\u0000');
        }

        public Object decodeStream(DataInput strm) throws IOException {
            if (!$assertionsDisabled && this.getNumItems(strm) != 1) {
                throw new AssertionError();
            }
            return new Character(this.cread.readCharFromStream(strm));
        }

        public boolean isNull(Object array, int index) {
            return false;
        }

        public void setNullValue(String txt) {
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$votable$CharDecoders == null ? (class$uk$ac$starlink$votable$CharDecoders = CharDecoders.class$("uk.ac.starlink.votable.CharDecoders")) : class$uk$ac$starlink$votable$CharDecoders).desiredAssertionStatus();
        }
    }

    private static interface CharReader {
        public char readCharFromStream(DataInput var1) throws IOException;
    }
}

