/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.HashSet;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;

public abstract class AbstractCartesianMatchEngine
implements MatchEngine {
    private final int ndim_;
    private final int blockSize_;
    private boolean normaliseScores_;
    private double[] errors_;
    private double[] err2rs_;
    private double[] cellScales_;
    public static final double CELL_SCALE = 2.0;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractCartesianMatchEngine(int ndim, boolean normaliseScores) {
        this.ndim_ = ndim;
        this.errors_ = new double[ndim];
        this.err2rs_ = new double[ndim];
        this.cellScales_ = new double[ndim];
        this.blockSize_ = (int)Math.pow(3.0, ndim);
        this.setNormaliseScores(normaliseScores);
    }

    public int getDimensions() {
        return this.ndim_;
    }

    public double matchScore(Object[] tuple1, Object[] tuple2) {
        for (int i = 0; i < this.ndim_; ++i) {
            if (!(Math.abs(((Number)tuple1[i]).doubleValue() - ((Number)tuple2[i]).doubleValue()) > this.errors_[i])) continue;
            return -1.0;
        }
        double spaceDist2 = 0.0;
        double normDist2 = 0.0;
        for (int i = 0; i < this.ndim_; ++i) {
            double d = ((Number)tuple1[i]).doubleValue() - ((Number)tuple2[i]).doubleValue();
            double d2 = d * d;
            spaceDist2 += d2;
            normDist2 += d2 * this.err2rs_[i];
        }
        if (normDist2 <= 1.0) {
            return this.normaliseScores_ ? Math.sqrt(normDist2) : Math.sqrt(spaceDist2);
        }
        return -1.0;
    }

    public ValueInfo getMatchScoreInfo() {
        String descrip = this.getNormaliseScores() ? "Normalised distance between matched points(0 is identical position, 1 is worst permissible match)" : "Spatial distance between matched points";
        DefaultValueInfo scoreInfo = new DefaultValueInfo("Separation", Double.class, descrip);
        scoreInfo.setUCD("pos.distance");
        return scoreInfo;
    }

    public Object[] getBins(Object[] tuple) {
        double[] coords = new double[this.ndim_];
        for (int i = 0; i < this.ndim_; ++i) {
            if (!(tuple[i] instanceof Number)) {
                return NO_BINS;
            }
            coords[i] = ((Number)tuple[i]).doubleValue();
        }
        return this.getCellBlock(coords);
    }

    public ValueInfo[] getTupleInfos() {
        ValueInfo[] infos = new ValueInfo[this.ndim_];
        for (int i = 0; i < this.ndim_; ++i) {
            DefaultValueInfo info = new DefaultValueInfo(this.getCoordinateName(i), class$java$lang$Number == null ? AbstractCartesianMatchEngine.class$("java.lang.Number") : class$java$lang$Number, this.getCoordinateDescription(i));
            info.setNullable(false);
            infos[i] = info;
        }
        return infos;
    }

    public boolean canBoundMatch() {
        return true;
    }

    public Comparable[][] getMatchBounds(Comparable[] minTuple, Comparable[] maxTuple) {
        minTuple = (Comparable[])minTuple.clone();
        maxTuple = (Comparable[])maxTuple.clone();
        for (int i = 0; i < this.ndim_; ++i) {
            Class<?> clazz;
            double err = this.getError(i);
            if (minTuple[i] instanceof Number) {
                double min = ((Number)((Object)minTuple[i])).doubleValue() - err;
                clazz = minTuple[i].getClass();
                Number min1 = clazz == (class$java$lang$Byte == null ? AbstractCartesianMatchEngine.class$("java.lang.Byte") : class$java$lang$Byte) && Math.floor(min) >= -128.0 ? (Number)new Byte((byte)Math.floor(min)) : (Number)(clazz == (class$java$lang$Short == null ? AbstractCartesianMatchEngine.class$("java.lang.Short") : class$java$lang$Short) && Math.floor(min) >= -32768.0 ? (Number)new Short((short)Math.floor(min)) : (Number)(clazz == (class$java$lang$Integer == null ? AbstractCartesianMatchEngine.class$("java.lang.Integer") : class$java$lang$Integer) && Math.floor(min) >= -2.147483648E9 ? (Number)new Integer((int)Math.floor(min)) : (Number)(clazz == (class$java$lang$Long == null ? AbstractCartesianMatchEngine.class$("java.lang.Long") : class$java$lang$Long) && Math.floor(min) >= -9.223372036854776E18 ? (Number)new Long((long)Math.floor(min)) : (Number)(clazz == (class$java$lang$Float == null ? AbstractCartesianMatchEngine.class$("java.lang.Float") : class$java$lang$Float) ? (Number)new Float((float)min) : (Number)(clazz == (class$java$lang$Double == null ? AbstractCartesianMatchEngine.class$("java.lang.Double") : class$java$lang$Double) ? new Double(min) : null)))));
                minTuple[i] = min1;
            }
            if (!(maxTuple[i] instanceof Number)) continue;
            double max = ((Number)((Object)maxTuple[i])).doubleValue() + err;
            clazz = maxTuple[i].getClass();
            Number max1 = clazz == (class$java$lang$Byte == null ? AbstractCartesianMatchEngine.class$("java.lang.Byte") : class$java$lang$Byte) && Math.ceil(max) <= 127.0 ? (Number)new Byte((byte)Math.ceil(max)) : (Number)(clazz == (class$java$lang$Short == null ? AbstractCartesianMatchEngine.class$("java.lang.Short") : class$java$lang$Short) && Math.ceil(max) <= 32767.0 ? (Number)new Short((short)Math.ceil(max)) : (Number)(clazz == (class$java$lang$Integer == null ? AbstractCartesianMatchEngine.class$("java.lang.Integer") : class$java$lang$Integer) && Math.ceil(max) <= 2.147483647E9 ? (Number)new Integer((int)Math.ceil(max)) : (Number)(clazz == (class$java$lang$Float == null ? AbstractCartesianMatchEngine.class$("java.lang.Float") : class$java$lang$Float) ? (Number)new Float((float)max) : (Number)(clazz == (class$java$lang$Double == null ? AbstractCartesianMatchEngine.class$("java.lang.Double") : class$java$lang$Double) ? new Double(max) : null))));
            maxTuple[i] = max1;
        }
        return new Comparable[][]{minTuple, maxTuple};
    }

    public abstract DescribedValue[] getMatchParameters();

    protected double getError(int idim) {
        return this.errors_[idim];
    }

    public void setError(int idim, double error) {
        this.errors_[idim] = error;
        this.err2rs_[idim] = error == 0.0 ? Double.MAX_VALUE : 1.0 / (error * error);
        this.cellScales_[idim] = 1.0 / (2.0 * error);
    }

    public void setNormaliseScores(boolean norm) {
        this.normaliseScores_ = norm;
    }

    public boolean getNormaliseScores() {
        return this.normaliseScores_;
    }

    String getCoordinateName(int idim) {
        return this.ndim_ <= 3 ? (new String[]{"X", "Y", "Z"})[idim] : "Co-ord #" + (idim + 1);
    }

    String getCoordinateDescription(int idim) {
        return "Cartesian co-ordinate #" + (idim + 1);
    }

    public abstract String toString();

    private int[] getBaseLabel(double[] coords) {
        int[] label = new int[this.ndim_];
        for (int i = 0; i < this.ndim_; ++i) {
            label[i] = (int)Math.floor(coords[i] * this.cellScales_[i]);
        }
        return label;
    }

    private Cell[] getCellBlock(double[] coords) {
        HashSet<Cell> cells = new HashSet<Cell>();
        int[] offset = new int[this.ndim_];
        double[] pos = new double[this.ndim_];
        block0: for (int icell = 0; icell < this.blockSize_; ++icell) {
            for (int i = 0; i < this.ndim_; ++i) {
                pos[i] = coords[i] + (double)(offset[i] - 1) * this.errors_[i];
            }
            Cell cell = new Cell(this.getBaseLabel(pos));
            cells.add(cell);
            for (int j = 0; j < this.ndim_; ++j) {
                int n = j;
                offset[n] = offset[n] + 1;
                if (offset[n] < 3) continue block0;
                offset[j] = 0;
            }
        }
        for (int i = 0; i < this.ndim_; ++i) {
            if (!$assertionsDisabled && offset[i] != 0) {
                throw new AssertionError();
            }
        }
        return cells.toArray(new Cell[cells.size()]);
    }

    static {
        $assertionsDisabled = !AbstractCartesianMatchEngine.class.desiredAssertionStatus();
    }

    private class Cell {
        private final int[] label_;
        private final AbstractCartesianMatchEngine encloser_;

        Cell(int[] label) {
            this.label_ = label;
            this.encloser_ = AbstractCartesianMatchEngine.this;
        }

        public boolean equals(Object o) {
            if (o instanceof Cell) {
                Cell other = (Cell)o;
                if (this.encloser_ == other.encloser_) {
                    int[] otherLabel = other.label_;
                    for (int i = 0; i < AbstractCartesianMatchEngine.this.ndim_; ++i) {
                        if (otherLabel[i] == this.label_[i]) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int code = 37;
            for (int i = 0; i < AbstractCartesianMatchEngine.this.ndim_; ++i) {
                code = 23 * code + this.label_[i];
            }
            return code;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer("(");
            for (int i = 0; i < AbstractCartesianMatchEngine.this.ndim_; ++i) {
                if (i > 0) {
                    sbuf.append(",");
                }
                sbuf.append(this.label_[i]);
            }
            sbuf.append(")");
            return sbuf.toString();
        }
    }
}

