/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.BinContents;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.ListStore;
import uk.ac.starlink.table.join.ListStores;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MultiJoinType;
import uk.ac.starlink.table.join.NullProgressIndicator;
import uk.ac.starlink.table.join.PairsRowLink;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.ProgressRowSequence;
import uk.ac.starlink.table.join.Range;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowLink2;
import uk.ac.starlink.table.join.RowRef;
import uk.ac.starlink.table.join.TreeSetLinkSet;

public class RowMatcher {
    private final MatchEngine engine;
    private final StarTable[] tables;
    private final int nTable;
    private ProgressIndicator indicator = new NullProgressIndicator();
    private long startTime;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Comparable;

    public RowMatcher(MatchEngine engine, StarTable[] tables) {
        this.engine = engine;
        this.tables = tables;
        this.nTable = tables.length;
    }

    public void setIndicator(ProgressIndicator indicator) {
        this.indicator = indicator;
    }

    public ProgressIndicator getIndicator() {
        return this.indicator;
    }

    public LinkSet createLinkSet() {
        return new TreeSetLinkSet();
    }

    public LinkSet findPairMatches(boolean bestOnly) throws IOException, InterruptedException {
        this.checkRandom();
        if (this.nTable != 2) {
            throw new IllegalStateException("findPairMatches only makes sense for 2 tables");
        }
        this.startMatch();
        LinkSet possibleLinks = this.getPossibleInterLinks(0, 1);
        LinkSet pairs = this.findInterPairs(possibleLinks, 0, 1);
        if (bestOnly) {
            pairs = this.eliminateMultipleRowEntries(pairs);
        }
        this.endMatch();
        return pairs;
    }

    public LinkSet findMultiPairMatches(int index0, boolean bestOnly, MultiJoinType[] joinTypes) throws IOException, InterruptedException {
        int i;
        this.checkRandom();
        if (joinTypes.length != this.nTable) {
            throw new IllegalArgumentException("Options length " + joinTypes.length + " differs from table count " + this.nTable);
        }
        this.startMatch();
        LinkSet possibleLinks = this.getPossibleMultiPairLinks(index0);
        LinkSet multiLinks = this.findMultiPairMatches(possibleLinks, index0, bestOnly);
        LinkSet[] missing = new LinkSet[this.nTable];
        for (i = 0; i < this.nTable; ++i) {
            if (joinTypes[i] != MultiJoinType.ALWAYS) continue;
            missing[i] = this.missingSingles(multiLinks, i);
        }
        for (i = 0; i < this.nTable; ++i) {
            if (missing[i] == null) continue;
            Iterator it = missing[i].iterator();
            while (it.hasNext()) {
                multiLinks.addLink((RowLink)it.next());
            }
            missing[i] = null;
        }
        Iterator it = multiLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            if (this.acceptRow(link, joinTypes)) continue;
            it.remove();
        }
        this.endMatch();
        return multiLinks;
    }

    public LinkSet findGroupMatches(MultiJoinType[] joinTypes) throws IOException, InterruptedException {
        int i;
        this.checkRandom();
        if (this.nTable < 2) {
            throw new IllegalStateException("Find matches only makes sense for multiple tables");
        }
        if (joinTypes.length != this.nTable) {
            throw new IllegalArgumentException("Options length " + joinTypes.length + " differs from table count " + this.nTable);
        }
        this.startMatch();
        LinkSet pairs = this.findPairs(this.getAllPossibleLinks());
        this.eliminateInternalLinks(pairs);
        LinkSet links = this.agglomerateLinks(pairs);
        pairs = null;
        this.eliminateInternalLinks(links);
        LinkSet[] missing = new LinkSet[this.nTable];
        for (i = 0; i < this.nTable; ++i) {
            if (joinTypes[i] != MultiJoinType.ALWAYS) continue;
            missing[i] = this.missingSingles(links, i);
        }
        for (i = 0; i < this.nTable; ++i) {
            if (missing[i] == null) continue;
            Iterator it = missing[i].iterator();
            while (it.hasNext()) {
                links.addLink((RowLink)it.next());
            }
            missing[i] = null;
        }
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            if (this.acceptRow(link, joinTypes)) continue;
            it.remove();
        }
        this.endMatch();
        return links;
    }

    public LinkSet findInternalMatches(boolean includeSingles) throws IOException, InterruptedException {
        this.checkRandom();
        if (this.nTable != 1) {
            throw new IllegalStateException("Internal matches only make sense with a single table");
        }
        this.startMatch();
        LinkSet links = this.findPairs(this.getAllPossibleLinks());
        links = this.agglomerateLinks(links);
        if (includeSingles) {
            Iterator it = this.missingSingles(links, 0).iterator();
            while (it.hasNext()) {
                links.addLink((RowLink)it.next());
                it.remove();
            }
        }
        this.endMatch();
        return links;
    }

    private LinkSet findPairs(LinkSet possibleLinks) throws IOException, InterruptedException {
        LinkSet pairs = this.createLinkSet();
        double nLink = possibleLinks.size();
        int iLink = 0;
        this.indicator.startStage("Locating pairs");
        Iterator it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            it.remove();
            int nref = link.size();
            if (nref > 1) {
                int i;
                Object[][] binnedRows = new Object[nref][];
                for (i = 0; i < nref; ++i) {
                    RowRef ref = link.getRef(i);
                    StarTable table = this.tables[ref.getTableIndex()];
                    binnedRows[i] = table.getRow(ref.getRowIndex());
                }
                for (i = 0; i < nref; ++i) {
                    for (int j = 0; j < i; ++j) {
                        double score;
                        RowLink2 pair = new RowLink2(link.getRef(i), link.getRef(j));
                        if (pairs.containsLink(pair) || !((score = this.engine.matchScore(binnedRows[i], binnedRows[j])) >= 0.0)) continue;
                        pair.setScore(score);
                        pairs.addLink(pair);
                    }
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        return pairs;
    }

    private LinkSet findInterPairs(LinkSet possibleLinks, int index1, int index2) throws IOException, InterruptedException {
        LinkSet pairs = this.createLinkSet();
        double nLink = possibleLinks.size();
        int iLink = 0;
        this.indicator.startStage("Locating inter-table pairs");
        Iterator it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            it.remove();
            int nref = link.size();
            if (nref > 1) {
                boolean got1 = false;
                boolean got2 = false;
                for (int i = 0; !(i >= nref || got1 && got2); ++i) {
                    int tableIndex = link.getRef(i).getTableIndex();
                    got1 = got1 || tableIndex == index1;
                    got2 = got2 || tableIndex == index2;
                }
                if (got1 && got2) {
                    int i;
                    Object[][] binnedRows = new Object[nref][];
                    for (i = 0; i < nref; ++i) {
                        RowRef ref = link.getRef(i);
                        StarTable table = this.tables[ref.getTableIndex()];
                        binnedRows[i] = table.getRow(ref.getRowIndex());
                    }
                    for (i = 0; i < nref; ++i) {
                        RowRef refI = link.getRef(i);
                        int iTableI = refI.getTableIndex();
                        for (int j = 0; j < i; ++j) {
                            double score;
                            RowLink2 pair;
                            RowRef refJ = link.getRef(j);
                            int iTableJ = refJ.getTableIndex();
                            if ((iTableI != index1 || iTableJ != index2) && (iTableI != index2 || iTableJ != index1) || pairs.containsLink(pair = new RowLink2(refI, refJ)) || !((score = this.engine.matchScore(binnedRows[i], binnedRows[j])) >= 0.0)) continue;
                            pair.setScore(score);
                            pairs.addLink(pair);
                        }
                    }
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        return pairs;
    }

    private LinkSet getAllPossibleLinks() throws IOException, InterruptedException {
        Range range = new Range(this.tables[0].getColumnCount());
        BinContents bins = new BinContents(this.indicator);
        long totalRows = 0L;
        for (int itab = 0; itab < this.nTable; ++itab) {
            this.binRows(itab, range, bins, true);
            totalRows += this.tables[itab].getRowCount();
        }
        long nBin = bins.getRowCount();
        this.indicator.logMessage("Average bin count per row: " + (float)((double)nBin / (double)totalRows));
        LinkSet links = this.createLinkSet();
        bins.addRowLinks(links);
        return links;
    }

    private LinkSet getPossibleInterLinks(int index1, int index2) throws IOException, InterruptedException {
        int indexB;
        int indexA;
        Range range;
        int ncol = this.tables[index1].getColumnCount();
        if (this.tables[index2].getColumnCount() != ncol) {
            throw new IllegalStateException();
        }
        long nIncludedRows1 = this.tables[index1].getRowCount();
        long nIncludedRows2 = this.tables[index2].getRowCount();
        if (this.engine.canBoundMatch()) {
            this.indicator.logMessage("Attempt to locate restricted common region");
            try {
                range = Range.intersection(this.getRange(index1), this.getRange(index2));
                if (range == null) {
                    this.indicator.logMessage("No region overlap - matches not possible");
                    return this.createLinkSet();
                }
                this.indicator.logMessage("Potential match region: " + range);
                nIncludedRows1 = this.countInRange(index1, range);
                nIncludedRows2 = this.countInRange(index2, range);
            }
            catch (ClassCastException e) {
                this.indicator.logMessage("Common region location failed (incompatible value types)");
                range = new Range(ncol);
            }
        } else {
            range = new Range(ncol);
        }
        if (nIncludedRows1 < nIncludedRows2) {
            indexA = index1;
            indexB = index2;
        } else {
            indexA = index2;
            indexB = index1;
        }
        BinContents bins = new BinContents(this.indicator);
        this.binRows(indexA, range, bins, true);
        this.binRows(indexB, range, bins, false);
        LinkSet links = this.createLinkSet();
        bins.addRowLinks(links);
        return links;
    }

    private void eliminateInternalLinks(LinkSet links) throws InterruptedException {
        Object[] refs = new RowRef[this.nTable];
        LinkSet replacements = this.createLinkSet();
        this.indicator.startStage("Eliminating internal links");
        double nLink = links.size();
        int iLink = 0;
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            if (link.size() > 1) {
                Arrays.fill(refs, null);
                boolean dup = false;
                for (int i = 0; i < nref; ++i) {
                    RowRef ref = link.getRef(i);
                    int iTable = ref.getTableIndex();
                    if (refs[iTable] == null) {
                        refs[iTable] = ref;
                        continue;
                    }
                    dup = true;
                }
                if (dup) {
                    it.remove();
                    ArrayList<Object> repRefs = new ArrayList<Object>();
                    for (int i = 0; i < this.nTable; ++i) {
                        if (refs[i] == null) continue;
                        repRefs.add(refs[i]);
                    }
                    RowLink repLink = new RowLink(repRefs);
                    replacements.addLink(repLink);
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        this.indicator.logMessage("Internal links removed: " + replacements.size());
        it = replacements.iterator();
        while (it.hasNext()) {
            RowLink repLink = (RowLink)it.next();
            links.addLink(repLink);
            it.remove();
        }
    }

    private LinkSet missingSingles(LinkSet links, int iTable) {
        BitSet present = new BitSet();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() != iTable) continue;
                present.set(RowMatcher.checkedLongToInt(ref.getRowIndex()));
            }
        }
        int nrow = RowMatcher.checkedLongToInt(this.tables[iTable].getRowCount());
        LinkSet singles = this.createLinkSet();
        for (int iRow = 0; iRow < nrow; ++iRow) {
            if (present.get(iRow)) continue;
            singles.addLink(new RowLink(new RowRef(iTable, iRow)));
        }
        return singles;
    }

    private LinkSet getPossibleMultiPairLinks(int index0) throws IOException, InterruptedException {
        Range range;
        int ncol = this.tables[index0].getColumnCount();
        if (this.engine.canBoundMatch()) {
            this.indicator.logMessage("Attempt to locate restricted common region");
            try {
                Range[] ranges = new Range[this.nTable];
                for (int i = 0; i < this.nTable; ++i) {
                    ranges[i] = this.getRange(i);
                }
                Range unionOthers = null;
                for (int i = 0; i < this.nTable; ++i) {
                    if (i == index0) continue;
                    unionOthers = unionOthers == null ? ranges[i] : Range.union(unionOthers, ranges[i]);
                }
                range = Range.intersection(ranges[index0], unionOthers);
                this.indicator.logMessage("Potential match region: " + range);
            }
            catch (ClassCastException e) {
                this.indicator.logMessage("Region location failed (incompatible value types)");
                range = new Range(ncol);
            }
        } else {
            range = new Range(ncol);
        }
        BinContents bins = new BinContents(this.indicator);
        this.binRows(index0, range, bins, true);
        for (int itab = 0; itab < this.nTable; ++itab) {
            if (itab == index0) continue;
            this.binRows(itab, range, bins, false);
        }
        LinkSet linkSet = this.createLinkSet();
        bins.addRowLinks(linkSet);
        return linkSet;
    }

    private LinkSet findMultiPairMatches(LinkSet possibleLinks, int index0, boolean bestOnly) throws IOException, InterruptedException {
        RowRef ref0;
        LinkSet pairs = this.createLinkSet();
        double nLink = possibleLinks.size();
        int iLink = 0;
        this.indicator.startStage("Locating pair matches between " + index0 + " and other tables");
        Iterator it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            it.remove();
            int nref = link.size();
            boolean hasOthers = false;
            for (int iref = 0; iref < nref && !hasOthers; ++iref) {
                if (link.getRef(iref).getTableIndex() == index0) continue;
                hasOthers = true;
            }
            if (hasOthers) {
                Object[][] binnedRows = new Object[nref][];
                for (int iref = 0; iref < nref; ++iref) {
                    RowRef ref = link.getRef(iref);
                    StarTable table = this.tables[ref.getTableIndex()];
                    binnedRows[iref] = table.getRow(ref.getRowIndex());
                }
                for (int i0 = 0; i0 < nref; ++i0) {
                    ref0 = link.getRef(i0);
                    int iTable0 = ref0.getTableIndex();
                    if (iTable0 != index0) continue;
                    long irow0 = ref0.getRowIndex();
                    for (int i1 = 0; i1 < nref; ++i1) {
                        double score;
                        RowLink2 pair;
                        RowRef ref1 = link.getRef(i1);
                        int iTable1 = ref1.getTableIndex();
                        if (iTable1 == index0 || pairs.containsLink(pair = new RowLink2(ref0, ref1)) || !((score = this.engine.matchScore(binnedRows[i0], binnedRows[i1])) >= 0.0)) continue;
                        pair.setScore(score);
                        pairs.addLink(pair);
                    }
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        HashMap<RowRef, Object> pairMap = new HashMap<RowRef, Object>();
        ListStore store = ListStores.createListStore();
        Iterator it2 = pairs.iterator();
        while (it2.hasNext()) {
            RowRef ref1;
            RowLink2 pair = (RowLink2)it2.next();
            it2.remove();
            RowRef refA = pair.getRef(0);
            RowRef refB = pair.getRef(1);
            if (refA.getTableIndex() == index0) {
                if (!$assertionsDisabled && refB.getTableIndex() == index0) {
                    throw new AssertionError();
                }
                ref0 = refA;
                ref1 = refB;
            } else if (refB.getTableIndex() == index0) {
                if (!$assertionsDisabled && refA.getTableIndex() == index0) {
                    throw new AssertionError();
                }
                ref0 = refB;
                ref1 = refA;
            } else {
                throw new IllegalArgumentException("Pair doesn't contain reference table");
            }
            RowRef key = ref0;
            ScoredRef value = new ScoredRef(ref1, pair.getScore());
            pairMap.put(key, store.addItem(pairMap.get(key), value));
        }
        LinkSet multiLinks = this.createLinkSet();
        Iterator it3 = pairMap.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry entry = it3.next();
            RowRef ref02 = (RowRef)entry.getKey();
            ScoredRef[] sref1s = store.getList(entry.getValue()).toArray(new ScoredRef[0]);
            int nref1 = sref1s.length;
            if (nref1 <= 0) continue;
            RowRef[] ref1s = new RowRef[nref1];
            double[] scores = new double[nref1];
            for (int ir1 = 0; ir1 < nref1; ++ir1) {
                ref1s[ir1] = sref1s[ir1].ref_;
                scores[ir1] = sref1s[ir1].score_;
            }
            multiLinks.addLink(new PairsRowLink(ref02, ref1s, scores, bestOnly));
        }
        return multiLinks;
    }

    private boolean acceptRow(RowLink link, MultiJoinType[] joinTypes) {
        boolean[] present = new boolean[this.nTable];
        int nref = link.size();
        for (int i = 0; i < nref; ++i) {
            RowRef ref = link.getRef(i);
            int iTable = ref.getTableIndex();
            present[iTable] = true;
        }
        return MultiJoinType.accept(joinTypes, present);
    }

    private LinkSet eliminateMultipleRowEntries(LinkSet pairs) throws InterruptedException {
        HashMap<RowRef, RowLink2> bestRowScores = new HashMap<RowRef, RowLink2>();
        LinkSet inPairs = pairs;
        LinkSet outPairs = this.createLinkSet();
        double nPair = inPairs.size();
        int iPair = 0;
        this.indicator.startStage("Eliminating multiple row references");
        Iterator it = inPairs.iterator();
        while (it.hasNext()) {
            RowLink2 pair = (RowLink2)it.next();
            it.remove();
            double score = pair.getScore();
            if (pair.size() != 2 || Double.isNaN(score) || score < 0.0) {
                throw new IllegalArgumentException();
            }
            RowRef ref1 = pair.getRef(0);
            RowRef ref2 = pair.getRef(1);
            if (ref1.getTableIndex() != 0 || ref2.getTableIndex() != 1) {
                throw new IllegalArgumentException();
            }
            RowLink2 best1 = (RowLink2)bestRowScores.get(ref1);
            RowLink2 best2 = (RowLink2)bestRowScores.get(ref2);
            if ((best1 == null || score < best1.getScore()) && (best2 == null || score < best2.getScore())) {
                if (best1 != null) {
                    outPairs.removeLink(best1);
                }
                if (best2 != null) {
                    outPairs.removeLink(best2);
                }
                outPairs.addLink(pair);
                bestRowScores.put(ref1, pair);
                bestRowScores.put(ref2, pair);
            }
            this.indicator.setLevel((double)(++iPair) / nPair);
        }
        this.indicator.endStage();
        if (!$assertionsDisabled && inPairs.size() != 0) {
            throw new AssertionError();
        }
        return outPairs;
    }

    private LinkSet agglomerateLinks(LinkSet links) throws InterruptedException {
        this.indicator.logMessage("Agglomerating links");
        HashMap<RowRef, Object> refMap = new HashMap<RowRef, Object>();
        ListStore listStore = ListStores.createModifiableListStore();
        Iterator linkIt = links.iterator();
        while (linkIt.hasNext()) {
            RowLink link = (RowLink)linkIt.next();
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                refMap.put(ref, listStore.addItem(refMap.get(ref), link));
            }
        }
        LinkSet agglomeratedLinks = this.createLinkSet();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowRef ref;
            int i;
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            boolean isolated = true;
            for (i = 0; isolated && i < nref; ++i) {
                ref = link.getRef(i);
                List refLinks = listStore.getList(refMap.get(ref));
                if (!$assertionsDisabled && refLinks.size() <= 0) {
                    throw new AssertionError();
                }
                isolated = isolated && refLinks.size() == 1;
            }
            if (!isolated) continue;
            agglomeratedLinks.addLink(link);
            for (i = 0; i < nref; ++i) {
                ref = link.getRef(i);
                Object removed = refMap.remove(ref);
                if (!$assertionsDisabled && removed == null) {
                    throw new AssertionError();
                }
            }
        }
        double nRefs = refMap.size();
        this.indicator.startStage("Walking links");
        while (!refMap.isEmpty()) {
            this.indicator.setLevel(1.0 - (double)refMap.size() / nRefs);
            RowRef ref1 = (RowRef)refMap.keySet().iterator().next();
            HashSet refSet = new HashSet();
            RowMatcher.walkLinks(ref1, refMap, listStore, refSet);
            agglomeratedLinks.addLink(new RowLink(refSet));
        }
        this.indicator.endStage();
        return agglomeratedLinks;
    }

    private static void walkLinks(RowRef baseRef, Map refMap, ListStore listStore, Set outSet) {
        if (!outSet.contains(baseRef)) {
            List links = listStore.getList(refMap.get(baseRef));
            if (!links.isEmpty()) {
                outSet.add(baseRef);
                Iterator linkIt = links.iterator();
                while (linkIt.hasNext()) {
                    RowLink link = (RowLink)linkIt.next();
                    for (int i = 0; i < link.size(); ++i) {
                        RowRef rref = link.getRef(i);
                        RowMatcher.walkLinks(rref, refMap, listStore, outSet);
                    }
                    linkIt.remove();
                }
            }
            if (links.isEmpty()) {
                refMap.remove(baseRef);
            }
        }
    }

    private void checkRandom() {
        for (int itab = 0; itab < this.tables.length; ++itab) {
            if (this.tables[itab].isRandom()) continue;
            throw new IllegalArgumentException("Table " + this.tables[itab] + " is not random access");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range getRange(int tIndex) throws IOException, InterruptedException {
        StarTable table = this.tables[tIndex];
        int ncol = table.getColumnCount();
        if (!this.engine.canBoundMatch()) {
            return new Range(ncol);
        }
        boolean[] isComparable = new boolean[ncol];
        int ncomp = 0;
        for (int icol = 0; icol < ncol; ++icol) {
            if (!(class$java$lang$Comparable == null ? RowMatcher.class$("java.lang.Comparable") : class$java$lang$Comparable).isAssignableFrom(table.getColumnInfo(icol).getContentClass())) continue;
            isComparable[icol] = true;
            ++ncomp;
        }
        if (ncomp == 0) {
            return new Range(ncol);
        }
        Comparable[] mins = new Comparable[ncol];
        Comparable[] maxs = new Comparable[ncol];
        ProgressRowSequence rseq = new ProgressRowSequence(table, this.indicator, "Assessing range of coordinates from table " + (tIndex + 1));
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < ncol; ++icol) {
                    Object cell;
                    if (!isComparable[icol] || !((cell = row[icol]) instanceof Comparable) || Tables.isBlank(cell)) continue;
                    Comparable val = (Comparable)cell;
                    mins[icol] = Range.min(mins[icol], val, false);
                    maxs[icol] = Range.max(maxs[icol], val, false);
                }
                ++lrow;
            }
        }
        finally {
            rseq.close();
        }
        for (int icol = 0; icol < ncol; ++icol) {
            if (mins[icol] instanceof Number) {
                double min = ((Number)((Object)mins[icol])).doubleValue();
                if (!$assertionsDisabled && Double.isNaN(min)) {
                    throw new AssertionError();
                }
                if (Double.isInfinite(min)) {
                    mins[icol] = null;
                }
            }
            if (!(maxs[icol] instanceof Number)) continue;
            double max = ((Number)((Object)maxs[icol])).doubleValue();
            if (!$assertionsDisabled && Double.isNaN(max)) {
                throw new AssertionError();
            }
            if (!Double.isInfinite(max)) continue;
            maxs[icol] = null;
        }
        this.indicator.logMessage("Limits are: " + new Range(mins, maxs));
        Comparable[][] bounds = this.engine.getMatchBounds(mins, maxs);
        return new Range(bounds[0], bounds[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void binRows(int itab, Range range, BinContents bins, boolean newBins) throws IOException, InterruptedException {
        StarTable table = this.tables[itab];
        ProgressRowSequence rseq = new ProgressRowSequence(table, this.indicator, "Binning rows for table " + (itab + 1));
        long nrow = 0L;
        long nexclude = 0L;
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                if (range.isInside(row)) {
                    Object[] keys = this.engine.getBins(row);
                    int nkey = keys.length;
                    if (nkey > 0) {
                        RowRef rref = new RowRef(itab, lrow);
                        for (int ikey = 0; ikey < nkey; ++ikey) {
                            Object key = keys[ikey];
                            if (!newBins && !bins.containsKey(key)) continue;
                            bins.putRowInBin(keys[ikey], rref);
                        }
                    }
                } else {
                    ++nexclude;
                }
                ++nrow;
                ++lrow;
            }
            if (!$assertionsDisabled && nrow != table.getRowCount()) {
                throw new AssertionError();
            }
        }
        finally {
            rseq.close();
        }
        if (nexclude > 0L) {
            this.indicator.logMessage(nexclude + "/" + nrow + " rows excluded " + "(out of match region)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countInRange(int tIndex, Range range) throws IOException, InterruptedException {
        ProgressRowSequence rseq = new ProgressRowSequence(this.tables[tIndex], this.indicator, "Counting rows in match region for table " + (tIndex + 1));
        long nInclude = 0L;
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                if (range.isInside(rseq.getRow())) {
                    ++nInclude;
                }
                ++lrow;
            }
        }
        finally {
            rseq.close();
        }
        this.indicator.logMessage(nInclude + " rows in match region");
        return nInclude;
    }

    private void startMatch() {
        this.startTime = new Date().getTime();
    }

    private void endMatch() {
        long millis = new Date().getTime() - this.startTime;
        this.indicator.logMessage("Elapsed time for match: " + millis / 1000L + " seconds");
    }

    private static int checkedLongToInt(long lval) {
        return Tables.checkedLongToInt(lval);
    }

    static {
        $assertionsDisabled = !RowMatcher.class.desiredAssertionStatus();
    }

    private static class ScoredRef {
        final RowRef ref_;
        final double score_;

        public ScoredRef(RowRef ref, double score) {
            this.ref_ = ref;
            this.score_ = score;
        }
    }
}

