/*
 * Decompiled with CFR 0.152.
 */
package skyview.process;

import java.util.ArrayList;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import skyview.geometry.Converter;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.geometry.TransformationException;
import skyview.process.Processor;
import skyview.survey.Image;

public class Mosaicker
implements Processor {
    private ArrayList<String> usedImageNames = new ArrayList();

    @Override
    public String getName() {
        return "Mosaicker";
    }

    @Override
    public String getDescription() {
        return "Create a new image by putting together resampled pixels from set of old images";
    }

    @Override
    public void process(Image[] input, Image output, int[] osource, Sampler samp, DepthSampler dSampler) {
        int[] source = (int[])osource.clone();
        int width = output.getWidth();
        int height = output.getHeight();
        boolean newData = false;
        double[] out = new double[2];
        double[] in = new double[2];
        boolean morePixels = true;
        samp.setOutput(output);
        int procCount = 0;
        while (morePixels) {
            morePixels = false;
            Converter cv = null;
            Object data = null;
            int inWidth = 0;
            int inHeight = 0;
            int inDepth = 0;
            boolean badPixel = false;
            boolean goodPixel = false;
            int currImg = -1;
            boolean validImage = true;
            for (int pix = 0; pix < source.length; ++pix) {
                int img = source[pix];
                if (img < 0) continue;
                if (img >= 0 && currImg >= 0 && img != currImg) {
                    morePixels = true;
                    continue;
                }
                currImg = img;
                if (inWidth == 0) {
                    try {
                        input[img].validate();
                        this.usedImageNames.add(input[currImg].getName());
                    }
                    catch (Throwable e) {
                        validImage = false;
                        System.err.println("  Error processing candidate image #" + img + ": " + e.getMessage());
                        inWidth = -1;
                    }
                    if (validImage) {
                        try {
                            cv = new Converter();
                            cv.add(output.getWCS().inverse());
                            cv.add(input[img].getWCS());
                        }
                        catch (TransformationException e) {
                            throw new Error("Tranformation error in mosaicker:" + e);
                        }
                        String suffix = Mosaicker.ordinalSuffix(++procCount);
                        System.err.println("  Processing " + procCount + suffix + " candidate image #" + img);
                        inDepth = input[img].getDepth();
                        if (inDepth > 1 && dSampler != null) {
                            input[img] = dSampler.sample(input[img]);
                        }
                        inWidth = input[img].getWidth();
                        inHeight = input[img].getHeight();
                        if (input[img].isTiled()) {
                            samp.setBounds(this.getBounds(pix, source, width));
                        }
                        samp.setTransform(cv);
                        samp.setInput(input[img]);
                    }
                }
                if (validImage) {
                    samp.sample(pix);
                }
                source[pix] = -4;
            }
            if (currImg < 0) continue;
            input[currImg].clearData();
        }
    }

    private int[] getBounds(int pix, int[] source, int width) {
        int y0;
        int x0;
        int matching = source[pix];
        int xe = x0 = pix % width;
        int ye = y0 = pix / width;
        for (int xpix = pix + 1; xpix < source.length; ++xpix) {
            if (source[xpix] != matching) continue;
            int x = xpix % width;
            int y = xpix / width;
            if (x < x0) {
                x0 = x;
            } else if (x > xe) {
                xe = x;
            }
            if (y < y0) {
                y0 = y;
                continue;
            }
            if (y <= ye) continue;
            ye = y;
        }
        return new int[]{x0 + y0 * width, xe + y0 * width, x0 + ye * width, xe + ye * width};
    }

    @Override
    public void updateHeader(Header h) {
        try {
            h.insertHistory("");
            h.insertHistory("Image mosaicking using skyview.geometry.Mosaicker");
            h.insertHistory("");
            String[] names = this.usedImageNames.toArray(new String[0]);
            if (names.length == 0) {
                h.insertComment("");
                h.insertComment("************************************");
                h.insertComment("** No valid pixels for mosaicking **");
                h.insertComment("************************************");
                h.insertComment("");
                h.addValue("SV_ERROR", "No valid pixels found in mosaicker", "");
            }
            for (String name : names) {
                h.insertHistory("  Used image:" + name);
            }
            h.insertHistory("");
        }
        catch (FitsException e) {
            System.err.println("Error updating FITS header:\n   " + e);
        }
    }

    public static String ordinalSuffix(int n) {
        if (n < 0) {
            n = -n;
        }
        int unit = n % 10;
        int tens = n % 100 / 10;
        if (unit == 1 && tens != 1) {
            return "st";
        }
        if (unit == 2 && tens != 1) {
            return "nd";
        }
        if (unit == 3 && tens != 1) {
            return "rd";
        }
        return "th";
    }
}

