/*
 * Decompiled with CFR 0.152.
 */
package skyview.request;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.ivoa.util.CGI;
import org.xml.sax.Attributes;
import skyview.executive.Settings;
import skyview.survey.Util;

public class XMLGallery {
    static CGI cgi = new CGI();

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            Settings.updateFromFile(args[i]);
        }
        try {
            XMLGallery.printTemplate("../userimages/gallery.xml");
        }
        catch (Exception e) {
            XMLGallery.error("Exception processing request: " + e);
        }
    }

    public static void printTemplate(String name) throws Exception {
        System.out.println("Content-type: text/html\n");
        XMLGallery.printGallery(name);
    }

    public static void error(String msg) {
        System.out.println("Content-type: text/html\n\n<h2>Error during processing</h2>" + msg);
    }

    public static void printGallery(String filename) throws Exception {
        String xslt;
        if (Settings.get("GalleryXSLT") == null) {
            Settings.put("GalleryXSLT", "cgifiles/imagegallerythumbs.xsl");
        }
        if ((xslt = Settings.get("GalleryXSLT")) == null) {
            XMLGallery.error("No description transformation file in settings");
        }
        StreamSource xmlSource = new StreamSource(Util.getResourceOrFile(filename));
        StreamSource xslSource = new StreamSource(Util.getResourceOrFile(xslt));
        StringWriter sw = new StringWriter();
        StreamResult output = new StreamResult(sw);
        Transformer trans = TransformerFactory.newInstance().newTransformer(xslSource);
        trans.transform(xmlSource, output);
        sw.close();
        String outHTML = sw.toString();
        System.out.print(outHTML);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrib) {
        String lq = qName.toLowerCase();
    }

    public void endElement(String uri, String localName, String qName) {
        String lq = qName.toLowerCase();
    }

    public void characters(char[] arr, int start, int len) {
    }
}

