/*
 * Decompiled with CFR 0.152.
 */
package skyview.util;

import java.util.Arrays;
import skyview.util.Scaler;

public class HistScaler
extends Scaler {
    private int scale;
    private double[] array;
    private int start;

    public HistScaler() {
    }

    public HistScaler(double minVal, double maxVal, int minOutput, int maxOutput) {
        super(minVal, maxVal, minOutput, maxOutput);
    }

    @Override
    protected void setMinMax(double[] old) {
        this.array = new double[old.length];
        Arrays.sort(this.array);
    }

    @Override
    protected void prepareScaling(double[] c) {
        this.scale = this.getMaxOutput() - this.getMinOutput();
        this.start = this.getMinOutput();
    }

    @Override
    protected byte scale(double val) {
        int index = Arrays.binarySearch(this.array, val);
        return (byte)(index * this.scale / this.array.length + this.start);
    }
}

