/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;

public abstract class AbstractArrayDataIO
implements ArrayDataInput,
ArrayDataOutput {
    protected abstract byte get() throws IOException;

    protected abstract void get(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void put(byte var1) throws IOException;

    protected abstract void put(byte[] var1, int var2, int var3) throws IOException;

    public abstract long length();

    protected abstract long remaining();

    public boolean readBoolean() throws IOException {
        return this.get() == 1;
    }

    public byte readByte() throws IOException {
        return this.get();
    }

    public short readShort() throws IOException {
        return (short)((this.get() & 0xFF) << 8 | (this.get() & 0xFF) << 0);
    }

    public char readChar() throws IOException {
        return (char)((this.get() & 0xFF) << 8 | (this.get() & 0xFF) << 0);
    }

    public int readInt() throws IOException {
        return (this.get() & 0xFF) << 24 | (this.get() & 0xFF) << 16 | (this.get() & 0xFF) << 8 | (this.get() & 0xFF) << 0;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | ((long)this.readInt() & 0xFFFFFFFFL) << 0;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readUnsignedByte() throws IOException {
        return this.get() | 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() | 0xFFFF;
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFully(byte[] buf, int start, int len) throws IOException {
        int nread = this.numAvailable(len, 1);
        this.get(buf, start, nread);
        if (nread < len) {
            throw new EOFException();
        }
    }

    public int read(byte[] buf, int start, int length) throws IOException {
        int nread = this.numAvailable(length, 1);
        if (nread == 0) {
            throw new EOFException();
        }
        this.get(buf, start, nread);
        return nread;
    }

    public int read(boolean[] buf, int start, int length) throws IOException {
        int nread = this.numAvailable(length, 1);
        if (nread == 0) {
            throw new EOFException();
        }
        for (int i = 0; i < nread; ++i) {
            buf[i] = this.readBoolean();
        }
        return nread;
    }

    public int read(short[] buf, int start, int length) throws IOException {
        int nread = this.numAvailable(length, 2);
        if (nread == 0) {
            throw new EOFException();
        }
        for (int i = 0; i < nread; ++i) {
            buf[start++] = this.readShort();
        }
        return nread;
    }

    public int read(char[] buf, int start, int length) throws IOException {
        int nread = this.numAvailable(length, 2);
        if (nread == 0) {
            throw new EOFException();
        }
        for (int i = 0; i < nread; ++i) {
            buf[start++] = this.readChar();
        }
        return nread;
    }

    public int read(int[] buf, int start, int length) throws IOException {
        int nread = this.numAvailable(length, 4);
        if (nread == 0) {
            throw new EOFException();
        }
        for (int i = 0; i < nread; ++i) {
            buf[start++] = this.readInt();
        }
        return nread;
    }

    public int read(long[] buf, int start, int length) throws IOException {
        int nread = this.numAvailable(length, 8);
        if (nread == 0) {
            throw new EOFException();
        }
        for (int i = 0; i < nread; ++i) {
            buf[start++] = this.readLong();
        }
        return nread;
    }

    public int read(float[] buf, int start, int length) throws IOException {
        int nread = this.numAvailable(length, 4);
        if (nread == 0) {
            throw new EOFException();
        }
        for (int i = 0; i < nread; ++i) {
            buf[start++] = this.readFloat();
        }
        return nread;
    }

    public int read(double[] buf, int start, int length) throws IOException {
        int nread = this.numAvailable(length, 8);
        if (nread == 0) {
            throw new EOFException();
        }
        for (int i = 0; i < nread; ++i) {
            buf[start++] = this.readDouble();
        }
        return nread;
    }

    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(boolean[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(short[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(int[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(long[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(float[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(double[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int readArray(Object o) throws IOException {
        int nread = 0;
        return this.primitiveArrayRecurse(o, nread);
    }

    private int primitiveArrayRecurse(Object o, int nread) throws IOException {
        if (o == null) {
            return nread;
        }
        Class<?> elclass = o.getClass().getComponentType();
        if (elclass == null) {
            throw new IllegalArgumentException("Invalid object: " + o + " is not an array");
        }
        int nel = Array.getLength(o);
        if (elclass.isAssignableFrom(Object.class)) {
            for (int i = 0; i < nel; ++i) {
                this.primitiveArrayRecurse(((Object[])o)[i], nread);
            }
        } else if (elclass == Byte.TYPE) {
            nread += this.read((byte[])o, 0, nel);
        } else if (elclass == Boolean.TYPE) {
            nread += this.read((boolean[])o, 0, nel);
        } else if (elclass == Short.TYPE) {
            nread += this.read((short[])o, 0, nel);
        } else if (elclass == Character.TYPE) {
            nread += this.read((char[])o, 0, nel);
        } else if (elclass == Integer.TYPE) {
            nread += this.read((int[])o, 0, nel);
        } else if (elclass == Long.TYPE) {
            nread += this.read((long[])o, 0, nel);
        } else if (elclass == Float.TYPE) {
            nread += this.read((float[])o, 0, nel);
        } else if (elclass == Double.TYPE) {
            nread += this.read((double[])o, 0, nel);
        } else {
            throw new IllegalArgumentException("Invalid object: " + o + " is not a primitive array");
        }
        return nread;
    }

    public void write(int val) throws IOException {
        this.writeByte(val);
    }

    public void writeBoolean(boolean val) throws IOException {
        this.put(val ? (byte)1 : 0);
    }

    public void writeByte(int val) throws IOException {
        this.put((byte)val);
    }

    public void writeShort(int val) throws IOException {
        this.put((byte)(val >>> 8));
        this.put((byte)(val >>> 0));
    }

    public void writeChar(int val) throws IOException {
        this.put((byte)(val >>> 8));
        this.put((byte)(val >>> 0));
    }

    public void writeInt(int val) throws IOException {
        this.put((byte)(val >>> 24));
        this.put((byte)(val >>> 16));
        this.put((byte)(val >>> 8));
        this.put((byte)(val >>> 0));
    }

    public void writeLong(long val) throws IOException {
        this.put((byte)(val >>> 56));
        this.put((byte)(val >>> 48));
        this.put((byte)(val >>> 40));
        this.put((byte)(val >>> 32));
        this.put((byte)(val >>> 24));
        this.put((byte)(val >>> 16));
        this.put((byte)(val >>> 8));
        this.put((byte)(val >>> 0));
    }

    public void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    public void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    public void write(byte[] buf, int start, int length) throws IOException {
        int nwrite = this.numAvailable(length, 1);
        this.put(buf, start, nwrite);
        if (nwrite < length) {
            throw this.writeOverflowException();
        }
    }

    public void write(boolean[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeBoolean(buf[start++]);
        }
    }

    public void write(short[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeShort(buf[start++]);
        }
    }

    public void write(char[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeChar(buf[start++]);
        }
    }

    public void write(int[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeInt(buf[start++]);
        }
    }

    public void write(long[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeLong(buf[start++]);
        }
    }

    public void write(float[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeFloat(buf[start++]);
        }
    }

    public void write(double[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeDouble(buf[start++]);
        }
    }

    public void write(String[] strings, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeBytes(strings[start++]);
        }
    }

    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes(), 0, s.length());
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public void writeUTF(String str) throws IOException {
        AbstractArrayDataIO.writeUTF(str, this);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(boolean[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(short[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(int[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(long[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(float[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(double[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String[] strings) throws IOException {
        this.write(strings, 0, strings.length);
    }

    public void writeArray(Object o) throws IOException {
        Class<?> elclass;
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            this.write(((String)o).getBytes());
        }
        if ((elclass = o.getClass().getComponentType()) == null) {
            throw new IllegalArgumentException("Invalid object: " + o + " is not an array");
        }
        int nel = Array.getLength(o);
        if (elclass.isAssignableFrom(Object.class)) {
            for (int i = 0; i < nel; ++i) {
                this.writeArray(((Object[])o)[i]);
            }
        } else if (elclass == Byte.TYPE) {
            this.write((byte[])o, 0, nel);
        } else if (elclass == Boolean.TYPE) {
            this.write((boolean[])o, 0, nel);
        } else if (elclass == Short.TYPE) {
            this.write((short[])o, 0, nel);
        } else if (elclass == Character.TYPE) {
            this.write((char[])o, 0, nel);
        } else if (elclass == Integer.TYPE) {
            this.write((int[])o, 0, nel);
        } else if (elclass == Long.TYPE) {
            this.write((long[])o, 0, nel);
        } else if (elclass == Float.TYPE) {
            this.write((float[])o, 0, nel);
        } else if (elclass == Double.TYPE) {
            this.write((double[])o, 0, nel);
        } else {
            throw new IllegalArgumentException("Invalid object: " + o + " is not a primitive array");
        }
    }

    private int numAvailable(int required, int size) {
        int irem = (int)Math.min(Integer.MAX_VALUE, this.remaining());
        int nav = Math.min(required, irem / size);
        return nav;
    }

    private IOException writeOverflowException() {
        return new IOException("Attempted write beyond buffer limit");
    }

    private static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        out.write(bytearr);
        return utflen + 2;
    }
}

