/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.cone.ConeMatcher;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.ConeResultRowSequence;
import uk.ac.starlink.ttools.cone.ConeSearcher;

public class ParallelResultRowSequence
implements ConeResultRowSequence {
    private final ConeQueryRowSequence querySeq_;
    private final ConeSearcher coneSearcher_;
    private final boolean bestOnly_;
    private final String distanceCol_;
    private final int poolMax_;
    private final SortedSet resultPool_;
    private final Worker[] workers_;
    private long submitIndex_;
    private long nextIndex_;
    private Result currentResult_;
    private IOException error_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParallelResultRowSequence(ConeQueryRowSequence querySeq, ConeSearcher coneSearcher, boolean bestOnly, String distanceCol, int parallelism) {
        this.querySeq_ = querySeq;
        this.coneSearcher_ = coneSearcher;
        this.bestOnly_ = bestOnly;
        this.distanceCol_ = distanceCol;
        this.poolMax_ = parallelism * 3;
        this.resultPool_ = new TreeSet();
        this.workers_ = new Worker[parallelism];
        for (int i = 0; i < parallelism; ++i) {
            this.workers_[i] = new Worker("Cone Query Worker #" + (i + 1));
            this.workers_[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws IOException {
        SortedSet sortedSet = this.resultPool_;
        synchronized (sortedSet) {
            try {
                while (!(this.resultPool_.size() != 0 && ((Result)this.resultPool_.first()).index_ == this.nextIndex_ || this.workersFinished())) {
                    this.resultPool_.wait();
                }
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException("Interrupted").initCause(e);
            }
            if (this.error_ != null) {
                throw (IOException)new IOException("Rethrowing error from read thread").initCause(this.error_);
            }
            if (this.resultPool_.size() > 0) {
                this.currentResult_ = (Result)this.resultPool_.first();
                if (!$assertionsDisabled && this.currentResult_.index_ != this.nextIndex_) {
                    throw new AssertionError();
                }
                ++this.nextIndex_;
                boolean removed = this.resultPool_.remove(this.currentResult_);
                if (!$assertionsDisabled && !removed) {
                    throw new AssertionError();
                }
            } else {
                if (!$assertionsDisabled && !this.workersFinished()) {
                    throw new AssertionError();
                }
                this.currentResult_ = null;
            }
            this.resultPool_.notifyAll();
            return this.currentResult_ != null;
        }
    }

    public Object getCell(int icol) throws IOException {
        return this.getCurrentResult().row_[icol];
    }

    public Object[] getRow() throws IOException {
        return this.getCurrentResult().row_;
    }

    public double getRa() throws IOException {
        return this.getCurrentResult().ra_;
    }

    public double getDec() throws IOException {
        return this.getCurrentResult().dec_;
    }

    public double getRadius() throws IOException {
        return this.getCurrentResult().radius_;
    }

    public StarTable getConeResult() throws IOException {
        return this.getCurrentResult().table_;
    }

    public void close() throws IOException {
        for (int i = 0; i < this.workers_.length; ++i) {
            this.workers_[i].interrupt();
        }
        this.querySeq_.close();
    }

    private Result getCurrentResult() throws IOException {
        if (this.error_ != null) {
            throw (IOException)new IOException("Rethrowing error from read thread").initCause(this.error_);
        }
        if (this.currentResult_ == null) {
            String msg = "No current row";
            msg = msg + (this.workersFinished() ? " (iteration finished)" : " (next never called)");
            throw new IllegalStateException(msg);
        }
        return this.currentResult_;
    }

    private boolean workersFinished() {
        for (int i = 0; i < this.workers_.length; ++i) {
            if (this.workers_[i].isFinished()) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !ParallelResultRowSequence.class.desiredAssertionStatus();
    }

    private class Worker
    extends Thread {
        private boolean finished_;

        Worker(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done = false;
            while (!done) {
                try {
                    Result result = this.performNextQuery();
                    if (result != null) {
                        try {
                            this.submitResult(result);
                        }
                        catch (InterruptedException e) {
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                }
                catch (IOException e) {
                    this.setError(e);
                    done = true;
                }
                done = done || this.isInterrupted();
            }
            SortedSet sortedSet = ParallelResultRowSequence.this.resultPool_;
            synchronized (sortedSet) {
                this.finished_ = true;
                ParallelResultRowSequence.this.resultPool_.notifyAll();
            }
        }

        public boolean isFinished() {
            return this.finished_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result performNextQuery() throws IOException {
            long index;
            Object[] row;
            double radius;
            double dec;
            double ra;
            ConeQueryRowSequence coneQueryRowSequence = ParallelResultRowSequence.this.querySeq_;
            synchronized (coneQueryRowSequence) {
                if (!ParallelResultRowSequence.this.querySeq_.next()) {
                    return null;
                }
                ra = ParallelResultRowSequence.this.querySeq_.getRa();
                dec = ParallelResultRowSequence.this.querySeq_.getDec();
                radius = ParallelResultRowSequence.this.querySeq_.getRadius();
                row = (Object[])ParallelResultRowSequence.this.querySeq_.getRow().clone();
                index = ParallelResultRowSequence.this.submitIndex_++;
            }
            StarTable table = ConeMatcher.getConeResult(ParallelResultRowSequence.this.coneSearcher_, ParallelResultRowSequence.this.bestOnly_, ParallelResultRowSequence.this.distanceCol_, ra, dec, radius);
            return new Result(index, ra, dec, radius, row, table);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void submitResult(Result result) throws InterruptedException {
            SortedSet sortedSet = ParallelResultRowSequence.this.resultPool_;
            synchronized (sortedSet) {
                while (ParallelResultRowSequence.this.resultPool_.size() > ParallelResultRowSequence.this.poolMax_ && result.compareTo((Result)ParallelResultRowSequence.this.resultPool_.last()) > 0) {
                    ParallelResultRowSequence.this.resultPool_.wait();
                }
                ParallelResultRowSequence.this.resultPool_.add(result);
                ParallelResultRowSequence.this.resultPool_.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setError(IOException error) {
            ParallelResultRowSequence parallelResultRowSequence = ParallelResultRowSequence.this;
            synchronized (parallelResultRowSequence) {
                if (ParallelResultRowSequence.this.error_ == null) {
                    ParallelResultRowSequence.this.error_ = error;
                    for (int i = 0; i < ParallelResultRowSequence.this.workers_.length; ++i) {
                        ParallelResultRowSequence.this.workers_[i].interrupt();
                    }
                }
            }
        }
    }

    private class Result
    implements Comparable {
        private final long index_;
        private final double ra_;
        private final double dec_;
        private final double radius_;
        private final Object[] row_;
        private final StarTable table_;
        static final /* synthetic */ boolean $assertionsDisabled;

        Result(long index, double ra, double dec, double radius, Object[] row, StarTable table) {
            this.index_ = index;
            this.ra_ = ra;
            this.dec_ = dec;
            this.radius_ = radius;
            this.row_ = row;
            this.table_ = table;
        }

        public int compareTo(Object o) {
            Result other = (Result)o;
            if (this.index_ < other.index_) {
                return -1;
            }
            if (this.index_ > other.index_) {
                return 1;
            }
            if (!$assertionsDisabled && this != other) {
                throw new AssertionError();
            }
            return 0;
        }

        public String toString() {
            return "R" + this.index_;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ttools$cone$ParallelResultRowSequence == null ? (class$uk$ac$starlink$ttools$cone$ParallelResultRowSequence = ParallelResultRowSequence.class$("uk.ac.starlink.ttools.cone.ParallelResultRowSequence")) : class$uk$ac$starlink$ttools$cone$ParallelResultRowSequence).desiredAssertionStatus();
        }
    }
}

