/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class SetParameterFilter
extends BasicFilter {
    static final /* synthetic */ boolean $assertionsDisabled;

    public SetParameterFilter() {
        super("setparam", "[-type byte|short|int|long|float|double|boolean|string]\n[-desc <descrip>] [-unit <units>] [-ucd <ucd>]\n<pname> <pval>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"<p>Sets a named parameter in the table to a given value.", "The parameter named <code>&lt;pname&gt;</code> is set", "to the value <code>&lt;pval&gt;</code>.", "By default the type of the parameter is determined automatically", "(if it looks like an integer it's an integer etc)", "but this can be overridden using the <code>-type</code> flag.", "The parameter description may be set using the", "<code>-desc</code> flag.", "</p>"};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String type = null;
        String pname = null;
        String pval = null;
        String pdesc = null;
        String pucd = null;
        String punits = null;
        while (argIt.hasNext()) {
            String arg = (String)argIt.next();
            if ("-type".equals(arg) && type == null && argIt.hasNext()) {
                argIt.remove();
                type = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.startsWith("-desc") && pdesc == null && argIt.hasNext()) {
                argIt.remove();
                pdesc = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-ucd") && pucd == null && argIt.hasNext()) {
                argIt.remove();
                pucd = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.startsWith("-unit") && punits == null && argIt.hasNext()) {
                argIt.remove();
                punits = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (pname == null) {
                pname = arg;
                argIt.remove();
                continue;
            }
            if (pval != null) continue;
            pval = arg;
            argIt.remove();
        }
        if (pname == null) {
            throw new ArgException("No parameter name specified");
        }
        if (pval == null) {
            throw new ArgException("No parameter value specified");
        }
        final String name = pname;
        final String value = pval;
        final String descrip = pdesc;
        final String ucd = pucd;
        final String units = punits;
        final Class clazz = type == null ? null : SetParameterFilter.getClass(type);
        return new ProcessingStep(){

            public StarTable wrap(StarTable base) throws IOException {
                base.setParameter(SetParameterFilter.createDescribedValue(name, value, descrip, ucd, units, clazz));
                return base;
            }
        };
    }

    private static Class getClass(String type) throws ArgException {
        if ("byte".equals(type = type.toLowerCase().trim())) {
            return Byte.class;
        }
        if ("short".equals(type)) {
            return Short.class;
        }
        if ("int".equals(type)) {
            return Integer.class;
        }
        if ("long".equals(type)) {
            return Long.class;
        }
        if ("float".equals(type)) {
            return Float.class;
        }
        if ("double".equals(type)) {
            return Double.class;
        }
        if ("string".equals(type)) {
            return String.class;
        }
        throw new ArgException("Unknown parameter type \"" + type + "\"");
    }

    private static DescribedValue createDescribedValue(String name, String sval, String descrip, String ucd, String units, Class clazz) throws IOException {
        Object value = null;
        if (clazz != null) {
            try {
                if (clazz == Boolean.class) {
                    value = Boolean.valueOf(sval);
                }
                if (clazz == Byte.class) {
                    value = Byte.valueOf(sval);
                }
                if (clazz == Short.class) {
                    value = Short.valueOf(sval);
                }
                if (clazz == Integer.class) {
                    value = Integer.valueOf(sval);
                }
                if (clazz == Long.class) {
                    value = Long.valueOf(sval);
                }
                if (clazz == Float.class) {
                    value = Float.valueOf(sval);
                }
                if (clazz == Double.class) {
                    value = Double.valueOf(sval);
                }
                if (clazz == String.class) {
                    value = sval;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                value = sval;
                clazz = String.class;
            }
            catch (NumberFormatException e) {
                throw (IOException)new IOException("Value \"" + sval + "\" is not of type " + clazz.getName()).initCause(e);
            }
        } else {
            if (clazz == null) {
                try {
                    value = Integer.valueOf(sval);
                    clazz = Integer.class;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                try {
                    value = Double.valueOf(sval);
                    clazz = Double.class;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                if (sval.equalsIgnoreCase("true")) {
                    value = Boolean.TRUE;
                    clazz = Boolean.class;
                } else if (sval.equalsIgnoreCase("false")) {
                    value = Boolean.FALSE;
                    Class clazz2 = clazz = Boolean.class;
                }
            }
            if (clazz == null) {
                value = sval;
                Class clazz3 = clazz = String.class;
            }
        }
        if (!$assertionsDisabled && clazz == null) {
            throw new AssertionError();
        }
        DefaultValueInfo info = new DefaultValueInfo(name, clazz, descrip);
        if (ucd != null && ucd.trim().length() > 0) {
            info.setUCD(ucd);
        }
        if (units != null && units.trim().length() > 0) {
            info.setUnitString(units);
        }
        return new DescribedValue((ValueInfo)info, value);
    }

    static {
        $assertionsDisabled = !SetParameterFilter.class.desiredAssertionStatus();
    }
}

