/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.ttools.lint.AttributeChecker;
import uk.ac.starlink.ttools.lint.DeprecatedAttChecker;
import uk.ac.starlink.ttools.lint.FieldRefChecker;
import uk.ac.starlink.ttools.lint.IDChecker;
import uk.ac.starlink.ttools.lint.LintContext;
import uk.ac.starlink.ttools.lint.NameChecker;
import uk.ac.starlink.ttools.lint.ParamHandler;
import uk.ac.starlink.ttools.lint.RefChecker;
import uk.ac.starlink.ttools.lint.TableHandler;
import uk.ac.starlink.ttools.lint.VersionChecker;

public class CheckerFactory {
    private final LintContext context_;
    private final Map checkerMaps_ = new HashMap();

    public CheckerFactory(LintContext context) {
        this.context_ = context;
    }

    public Map getAttributeCheckers(String name) {
        if (!this.checkerMaps_.containsKey(name)) {
            this.checkerMaps_.put(name, this.createAttributeCheckers(name));
        }
        return (Map)this.checkerMaps_.get(name);
    }

    private Map createAttributeCheckers(String name) {
        HashMap<String, AttributeChecker> map = new HashMap<String, AttributeChecker>();
        boolean hasID = false;
        boolean hasName = false;
        if (name == null) {
            throw new NullPointerException();
        }
        if (!"BINARY".equals(name)) {
            if ("COOSYS".equals(name)) {
                hasID = true;
            } else if (!("DATA".equals(name) || "DEFINITIONS".equals(name) || "DESCRIPTION".equals(name))) {
                if ("FIELD".equals(name)) {
                    hasID = true;
                    hasName = true;
                    map.put("ref", new RefChecker("COOSYS"));
                } else if ("FIELDref".equals(name)) {
                    map.put("ref", new FieldRefChecker());
                } else if (!"FITS".equals(name)) {
                    if ("GROUP".equals(name)) {
                        hasID = true;
                        hasName = true;
                        map.put("ref", new RefChecker(new String[]{"GROUP", "COOSYS"}));
                    } else if ("INFO".equals(name)) {
                        hasID = true;
                        hasName = true;
                    } else if ("LINK".equals(name)) {
                        hasID = true;
                        if (!"1.0".equals(this.context_.getVersion())) {
                            map.put("gref", new DeprecatedAttChecker("gref"));
                        }
                    } else if (!"MAX".equals(name) && !"MIN".equals(name)) {
                        if ("OPTION".equals(name)) {
                            hasName = true;
                        } else if ("PARAM".equals(name)) {
                            hasID = true;
                            hasName = true;
                            map.put("value", new ParamHandler.ValueChecker());
                            map.put("ref", new RefChecker("COOSYS"));
                        } else if ("PARAMref".equals(name)) {
                            map.put("ref", new RefChecker("PARAM"));
                        } else if ("RESOURCE".equals(name)) {
                            hasID = true;
                            hasName = true;
                        } else if (!"STREAM".equals(name)) {
                            if ("TABLE".equals(name)) {
                                hasID = true;
                                hasName = true;
                                map.put("ref", new RefChecker("TABLE"));
                                map.put("nrows", new TableHandler.NrowsChecker());
                            } else if (!"TABLEDATA".equals(name)) {
                                if ("TD".equals(name)) {
                                    map.put("ref", new RefChecker(new String[0]));
                                } else if (!"TR".equals(name)) {
                                    if ("VALUES".equals(name)) {
                                        hasID = true;
                                    } else if ("VOTABLE".equals(name)) {
                                        hasID = true;
                                        map.put("version", new VersionChecker());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (hasID) {
            map.put("ID", new IDChecker());
        }
        if (hasName) {
            map.put("name", new NameChecker());
        }
        return map;
    }
}

