/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.filter.ProcessingFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.StepFactory;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class FilterParameter
extends Parameter
implements ExtraParameter,
MultiParameter {
    private ProcessingStep[] steps_;

    public FilterParameter(String name) {
        super(name);
        this.setUsage("<cmds>");
        this.setNullPermitted(true);
        String indir = String.valueOf('@');
        this.setDescription(new String[]{"<p>The value of this parameter is one or more of the filter", "commands described in <ref id=\"filterSteps\"/>.", "If more than one is given, they must be separated by", "semicolon characters (\";\").", "This parameter can be repeated multiple times on the same", "command line to build up a list of processing steps.", "The sequence of commands given in this way", "defines the processing pipeline which is performed on the table.", "</p>", "<p>Commands may alteratively be supplied in an external file,", "by using the indirection character '" + indir + "'.", "Thus \"<code>" + this.getName() + "=" + indir + "filename</code>\"", "causes the file <code>filename</code> to be read for a list", "of filter commands to execute.  The commands in the file", "may be separated by newline characters and/or semicolons.", "</p>"});
    }

    public char getValueSeparator() {
        return ';';
    }

    public void setValueFromString(Environment env, String sval) throws TaskException {
        this.steps_ = sval != null ? StepFactory.getInstance().createSteps(sval) : new ProcessingStep[0];
        super.setValueFromString(env, sval);
    }

    public ProcessingStep[] stepsValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.steps_;
    }

    public String getExtraUsage(TableEnvironment env) {
        return FilterParameter.getFiltersUsage(env);
    }

    public static String getFiltersUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer().append("   Known filter commands:\n");
        ObjectFactory filterFactory = StepFactory.getInstance().getFilterFactory();
        String[] fnames = filterFactory.getNickNames();
        for (int i = 0; i < fnames.length; ++i) {
            String fname = fnames[i];
            try {
                ProcessingFilter filter = (ProcessingFilter)filterFactory.createObject(fname);
                String fusage = filter.getUsage();
                sbuf.append("      ").append(fname);
                String pad = ("      " + fname).replaceAll(".", " ");
                if (fusage != null) {
                    sbuf.append(' ').append(fusage.replaceAll("\n", "\n " + pad));
                }
                sbuf.append('\n');
                continue;
            }
            catch (LoadException e) {
                if (!env.isDebug()) continue;
                sbuf.append("    ( ").append(fname).append(" - not available: ").append((Object)e).append(" )\n");
            }
        }
        sbuf.append("\n").append("   Commands can be separated on one line using ").append("semicolons (;).\n").append("   Arguments containing spaces should be ").append("'quoted' or \"quoted\".\n");
        return sbuf.toString();
    }
}

