/*
 * Decompiled with CFR 0.152.
 */
package jsky.image;

import com.sun.media.jai.codec.ImageCodec;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import javax.media.jai.Histogram;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.operator.TransposeDescriptor;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageColormap;
import jsky.image.ImageHistogram;
import jsky.image.ImageLookup;
import jsky.image.ImageUtil;
import jsky.image.fits.codec.FITSCodec;
import jsky.image.fits.codec.FITSImage;
import jsky.image.operator.CutLevelDescriptor;
import jsky.image.operator.ImageOps;
import jsky.image.operator.MinMaxDescriptor;
import jsky.util.gui.DialogUtil;

public class ImageProcessor {
    public static final int DEFAULT_X_PERIOD = 4;
    public static final int DEFAULT_Y_PERIOD = 4;
    private PlanarImage _sourceImage;
    private PlanarImage _rescaledSourceImage;
    private PlanarImage _shortImage;
    private PlanarImage _displayImage;
    private ROI _roi = null;
    private Rectangle2D.Double _region;
    private ImageHistogram _imageHistogram = new ImageHistogram();
    private int _numBands;
    private ImageColormap _colormap = new ImageColormap();
    private double _minValue = 0.0;
    private double _maxValue = 0.0;
    private double _lowCut = 0.0;
    private double _highCut = 0.0;
    private int _xPeriod = 4;
    private int _yPeriod = 4;
    private EventListenerList _listenerList = new EventListenerList();
    private ImageChangeEvent _imageChangeEvent = new ImageChangeEvent(this);
    private boolean _userSetCutLevels = false;
    private double _angle = 0.0;
    private boolean _flipX = false;
    private boolean _flipY = false;
    private boolean _reverseY = false;
    private boolean _invertedYAxis = false;
    private Interpolation _interpolation = new InterpolationNearest();
    private LookupTableJAI _scaleLookupTable;
    private int _scaleAlgorithm = 0;
    private String _name = "";
    private float _blank = Float.NaN;
    private double _dataMin = 0.0;
    private double _dataMax = 0.0;
    private double _dataMean = 0.0;
    private double _bzero = 0.0;
    private double _bscale = 1.0;
    private double _bitpix = 1.0;
    private boolean _updatePending = false;

    public ImageProcessor() {
    }

    public ImageProcessor(PlanarImage sourceImage, Rectangle2D.Double region) {
        this.setSourceImage(sourceImage, region);
    }

    public PlanarImage getSourceImage() {
        return this._sourceImage;
    }

    public PlanarImage getRescaledSourceImage() {
        return this._rescaledSourceImage;
    }

    public void setSourceImage(PlanarImage sourceImage, ImageProcessor imageProcessor) {
        this._sourceImage = sourceImage;
        this._updatePending = true;
        if (this._sourceImage == null) {
            this._displayImage = this._rescaledSourceImage = this._sourceImage;
            return;
        }
        SampleModel sampleModel = this._sourceImage.getSampleModel();
        if (sampleModel == null) {
            return;
        }
        this._numBands = sampleModel.getNumBands();
        if (imageProcessor != this) {
            this.copySettings(imageProcessor);
        }
        this._rescaledSourceImage = this.rescaleImage(this._sourceImage);
        ImageLookup imageLookup = new ImageLookup();
        this._shortImage = imageLookup.scaleToShortRange(this._rescaledSourceImage, this._lowCut, this._highCut);
    }

    public void setSourceImage(PlanarImage sourceImage, Rectangle2D.Double region) {
        this._sourceImage = sourceImage;
        this._updatePending = true;
        if (this._sourceImage == null) {
            this._displayImage = this._rescaledSourceImage = this._sourceImage;
            return;
        }
        SampleModel sampleModel = this._sourceImage.getSampleModel();
        if (sampleModel == null) {
            return;
        }
        this._numBands = sampleModel.getNumBands();
        this._maxValue = 0.0;
        this._minValue = 0.0;
        Object o = this._sourceImage.getProperty("#fits_image");
        this._reverseY = false;
        this._invertedYAxis = false;
        if (o instanceof FITSImage) {
            FITSImage fitsImage = (FITSImage)o;
            this._invertedYAxis = fitsImage.isYFlipped();
            this._reverseY = !this._invertedYAxis;
            this._bzero = fitsImage.getKeywordValue("BZERO", 0.0);
            this._bscale = fitsImage.getKeywordValue("BSCALE", 1.0);
            this._bitpix = fitsImage.getKeywordValue("BITPIX", 0);
            this._rescaledSourceImage = this.rescaleImage(this._sourceImage);
            if (this._numBands == 1 && !(this._sourceImage.getColorModel() instanceof IndexColorModel)) {
                this._blank = fitsImage.getKeywordValue("BLANK", Float.NaN);
                if (Float.isNaN(this._blank)) {
                    this._blank = fitsImage.getKeywordValue("BADPIXEL", Float.NaN);
                }
                if (!Float.isNaN(this._blank)) {
                    this._blank = this._blank * (float)this._bscale + (float)this._bzero;
                }
                this._dataMin = fitsImage.getKeywordValue("DATAMIN", 0.0);
                this._dataMax = fitsImage.getKeywordValue("DATAMAX", 0.0);
                this._dataMean = fitsImage.getKeywordValue("DATAMEAN", Double.NaN);
            }
        } else {
            this._bzero = 0.0;
            this._bscale = 1.0;
            this._bitpix = 0.0;
            this._blank = Float.NaN;
            this._dataMin = 0.0;
            this._dataMax = 0.0;
            this._dataMean = Double.NaN;
            this._rescaledSourceImage = this._sourceImage;
        }
        if (this._numBands == 1 && !(this._sourceImage.getColorModel() instanceof IndexColorModel)) {
            if (!this._userSetCutLevels) {
                this.autoSetCutLevels(region);
            } else {
                this.setRegionOfInterest(region);
                this.setCutLevels(this._lowCut, this._highCut, true);
            }
        }
    }

    public PlanarImage getDisplayImage() {
        return this._displayImage;
    }

    public void update() {
        if (!this._updatePending) {
            return;
        }
        this._updatePending = false;
        if (this._sourceImage == null) {
            this._displayImage = this._rescaledSourceImage = this._sourceImage;
            this.fireChange(this._imageChangeEvent);
            return;
        }
        if (this._rescaledSourceImage == null) {
            return;
        }
        try {
            PlanarImage colorImage;
            if (this._numBands == 1 && !(this._sourceImage.getColorModel() instanceof IndexColorModel)) {
                if (this._shortImage == null || this._scaleLookupTable == null) {
                    return;
                }
                PlanarImage byteImage = ImageOps.lookup(this._shortImage, this._scaleLookupTable);
                colorImage = ImageOps.lookup(byteImage, this._colormap.getColorLookupTable());
            } else {
                colorImage = this._rescaledSourceImage;
            }
            this._displayImage = this.setTrans(colorImage);
            this._displayImage = this.rotate(this._displayImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.fireChange(this._imageChangeEvent);
    }

    protected PlanarImage rescaleImage(PlanarImage im) {
        if (this._bscale != 1.0 || this._bzero != 0.0) {
            RenderingHints hints = ImageUtil.getSampleModelHint(im.getTileWidth(), im.getTileHeight(), 4);
            return ImageOps.rescale(im, this._bscale, this._bzero, hints);
        }
        return im;
    }

    protected PlanarImage setTrans(PlanarImage im) {
        if (this._flipX) {
            im = ImageOps.transpose(im, TransposeDescriptor.FLIP_HORIZONTAL);
        }
        if (this._flipY != this._reverseY) {
            im = ImageOps.transpose(im, TransposeDescriptor.FLIP_VERTICAL);
        }
        return im;
    }

    protected PlanarImage rotate(PlanarImage im) {
        if (this._angle != 0.0) {
            double x = (double)this._sourceImage.getWidth() / 2.0;
            double y = (double)this._sourceImage.getHeight() / 2.0;
            im = ImageOps.rotate(im, (float)x, (float)y, (float)this._angle, this._interpolation, null);
        }
        return im;
    }

    protected void setRegionOfInterest(Rectangle2D.Double region) {
        if (this._roi != null && this._region != null && region.equals(this._region)) {
            return;
        }
        this._region = region;
        this._region = new Rectangle2D.Double((int)this._region.getX(), (int)this._region.getY(), (int)this._region.getWidth(), (int)this._region.getHeight());
        this._region = (Rectangle2D.Double)this._region.createIntersection(new Rectangle2D.Double(this._xPeriod, this._yPeriod, this._sourceImage.getWidth() - this._xPeriod, this._sourceImage.getHeight() - this._yPeriod));
        this._roi = new ROIShape(this._region);
    }

    protected void calculateImageStatistics(Rectangle2D.Double region) {
        this.setRegionOfInterest(region);
        if (this._dataMin != this._dataMax) {
            this._minValue = this._dataMin;
            this._maxValue = this._dataMax;
        } else if (Float.isNaN(this._blank) && this._bitpix != -32.0 && this._bitpix != -64.0) {
            try {
                double[][] extrema = ImageOps.extrema(this._rescaledSourceImage, this._roi, this._xPeriod, this._yPeriod);
                this._minValue = extrema[0][0];
                this._maxValue = extrema[1][0];
            }
            catch (Exception e) {
                this._maxValue = 0.0;
                this._minValue = 0.0;
            }
        } else {
            double[] minMax = ImageOps.minMax(this._rescaledSourceImage, this._roi, this._xPeriod, this._yPeriod, this._blank);
            this._minValue = minMax[0];
            this._maxValue = minMax[1];
            this._dataMean = minMax[2];
        }
        if (this._minValue > this._maxValue) {
            throw new IllegalArgumentException("min value > max value.");
        }
        if (Double.isNaN(this._dataMean)) {
            this._dataMean = ImageOps.mean(this._rescaledSourceImage, this._roi, this._xPeriod, this._yPeriod)[0];
        }
        double[] cutLevels = ImageOps.cutLevel(this._rescaledSourceImage, this._roi, this._blank, this._dataMean);
        this._lowCut = cutLevels[0];
        this._highCut = cutLevels[1];
    }

    public void copySettings(ImageProcessor ip) {
        if (this._lowCut != ip._lowCut || this._highCut != ip._highCut || !this._colormap.equals(ip._colormap) || this._scaleAlgorithm != ip._scaleAlgorithm || this._flipX != ip._flipX || this._flipY != ip._flipY || this._reverseY != ip._reverseY || this._invertedYAxis != ip._invertedYAxis || this._angle != ip._angle) {
            this._updatePending = true;
            this._minValue = ip._minValue;
            this._maxValue = ip._maxValue;
            this._dataMin = ip._minValue;
            this._dataMax = ip._maxValue;
            this._dataMean = ip._dataMean;
            this._blank = ip._blank;
            this._bzero = ip._bzero;
            this._bscale = ip._bscale;
            this._lowCut = ip._lowCut;
            this._highCut = ip._highCut;
            this._userSetCutLevels = true;
            try {
                this._colormap = (ImageColormap)ip._colormap.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            this._scaleAlgorithm = ip._scaleAlgorithm;
            this._scaleLookupTable = ip._scaleLookupTable;
            this._flipX = ip._flipX;
            this._flipY = ip._flipY;
            this._reverseY = ip._reverseY;
            this._invertedYAxis = ip._invertedYAxis;
            this._angle = ip._angle;
        }
    }

    public void setCutLevels(double lowCut, double highCut) {
        this.setCutLevels(lowCut, highCut, true);
    }

    public void setCutLevels(double lowCut, double highCut, boolean userSetCutLevels) {
        if (lowCut > highCut) {
            return;
        }
        this._lowCut = lowCut;
        this._highCut = highCut;
        this._updatePending = true;
        this._userSetCutLevels = userSetCutLevels;
        ImageLookup imageLookup = new ImageLookup();
        this._shortImage = imageLookup.scale(this._rescaledSourceImage, this._scaleAlgorithm, this._lowCut, this._highCut, this._roi, this._imageHistogram);
        this._scaleLookupTable = imageLookup.getLookupTable();
        this._imageChangeEvent.setNewCutLevels(true);
    }

    public void setLowCut(double lowCut) {
        this.setCutLevels(lowCut, this._highCut, true);
    }

    public void setHighCut(double highCut) {
        this.setCutLevels(this._lowCut, highCut, true);
    }

    public double getLowCut() {
        return this._lowCut;
    }

    public double getHighCut() {
        return this._highCut;
    }

    public void autoSetCutLevels(Rectangle2D.Double region) {
        this.calculateImageStatistics(region);
        this.setCutLevels(this._lowCut, this._highCut, false);
    }

    public void autoSetCutLevels(double percent, Rectangle2D.Double region) {
        this._userSetCutLevels = false;
        double lowCut = this._minValue;
        double highCut = this._maxValue;
        this.calculateImageStatistics(region);
        int dataType = this._rescaledSourceImage.getSampleModel().getDataType();
        int numBins = 2048;
        double n = highCut - lowCut;
        if (n <= 0.0) {
            return;
        }
        if (n < (double)numBins && dataType != 4 && dataType != 5) {
            numBins = (int)n;
        }
        if (numBins <= 0) {
            return;
        }
        Histogram histogram = this._imageHistogram.getHistogram(this._rescaledSourceImage, numBins, this._minValue, this._maxValue, this._roi, this._xPeriod, this._yPeriod);
        int npixels = 0;
        int[] bins = histogram.getBins(0);
        double binWidth = (this._maxValue - this._minValue) / (double)numBins;
        for (int i = 0; i < numBins; ++i) {
            npixels += bins[i];
        }
        if (npixels > 0) {
            double d;
            double interp;
            int nprev;
            int i;
            int cutoff = (int)((double)npixels * (100.0 - percent) / 100.0 / 2.0);
            npixels = 0;
            for (i = 0; i < numBins; ++i) {
                nprev = npixels;
                if ((npixels += bins[i]) < cutoff) continue;
                lowCut = this._minValue + (double)i * binWidth;
                if (i == 0) break;
                interp = (double)(cutoff - nprev) / (double)(npixels - nprev);
                d = this._minValue + (double)(i - 1) * binWidth;
                lowCut = d + (lowCut - d) * interp;
                break;
            }
            npixels = 0;
            for (i = numBins - 1; i > 0; --i) {
                nprev = npixels;
                if ((npixels += bins[i]) < cutoff) continue;
                highCut = this._minValue + (double)i * binWidth;
                if (i == numBins - 1) break;
                interp = (double)(cutoff - nprev) / (double)(npixels - nprev);
                d = this._minValue + (double)(i + 1) * binWidth;
                highCut = d + (d - highCut) * interp;
                break;
            }
        }
        this.setCutLevels(lowCut, highCut, false);
    }

    public boolean isUserSetCutLevels() {
        return this._userSetCutLevels;
    }

    public void setUserSetCutLevels(boolean b) {
        this._userSetCutLevels = b;
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChange(ImageChangeEvent changeEvent) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
        changeEvent.reset();
    }

    public double getMinValue() {
        return this._minValue;
    }

    public double getMaxValue() {
        return this._maxValue;
    }

    public float getBlank() {
        return this._blank;
    }

    public double getAngle() {
        return this._angle;
    }

    public void setAngle(double angle) {
        this._angle = angle;
        this._imageChangeEvent.setNewAngle(true);
        this._updatePending = true;
    }

    public Interpolation getInterpolation() {
        return this._interpolation;
    }

    public void setInterpolation(Interpolation i) {
        this._interpolation = i;
        this._updatePending = true;
    }

    public void toggleFlipX() {
        this._flipX = !this._flipX;
        this._imageChangeEvent.setNewAngle(true);
        this._updatePending = true;
    }

    public void setFlipX(boolean flipX) {
        if (this._flipX != flipX) {
            this._flipX = flipX;
            this._imageChangeEvent.setNewAngle(true);
            this._updatePending = true;
        }
    }

    public boolean getFlipX() {
        return this._flipX;
    }

    public void toggleFlipY() {
        this._flipY = !this._flipY;
        this._imageChangeEvent.setNewAngle(true);
        this._updatePending = true;
    }

    public void setFlipY(boolean flipY) {
        if (this._flipY != flipY) {
            this._flipY = flipY;
            this._imageChangeEvent.setNewAngle(true);
            this._updatePending = true;
        }
    }

    public boolean getFlipY() {
        return this._flipY;
    }

    public void setReverseY(boolean reverseY) {
        if (this._reverseY != reverseY) {
            this._reverseY = reverseY;
            this._imageChangeEvent.setNewAngle(true);
            this._updatePending = true;
        }
    }

    public boolean getReverseY() {
        return this._reverseY;
    }

    public void setInvertedYAxis(boolean invertedYAxis) {
        if (this._invertedYAxis != invertedYAxis) {
            this._invertedYAxis = invertedYAxis;
            this._imageChangeEvent.setNewAngle(true);
            this._updatePending = true;
        }
    }

    public boolean isInvertedYAxis() {
        return this._invertedYAxis;
    }

    public Histogram getHistogram(int size, ROI roi) {
        return this._imageHistogram.getHistogram(this._rescaledSourceImage, size, this._lowCut, this._highCut, roi, this._xPeriod, this._yPeriod);
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public LookupTableJAI getScaleLookupTable() {
        return this._scaleLookupTable;
    }

    public void setScaleAlgorithm(int scaleAlgorithm) {
        this._scaleAlgorithm = scaleAlgorithm;
        ImageLookup imageLookup = new ImageLookup();
        this._shortImage = imageLookup.scale(this._rescaledSourceImage, this._scaleAlgorithm, this._lowCut, this._highCut, this._roi, this._imageHistogram);
        this._scaleLookupTable = imageLookup.getLookupTable();
        this._imageChangeEvent.setNewColormap(true);
        this._updatePending = true;
    }

    public int getScaleAlgorithm() {
        return this._scaleAlgorithm;
    }

    public void setColorLookupTable(String name) {
        this._colormap.setColorLookupTable(name);
        this._imageChangeEvent.setNewColormap(true);
        this._updatePending = true;
    }

    public LookupTableJAI getColorLookupTable() {
        return this._colormap.getColorLookupTable();
    }

    public String getColorLookupTableName() {
        return this._colormap.getColorLookupTableName();
    }

    public String getIntensityLookupTableName() {
        return this._colormap.getIntensityLookupTableName();
    }

    public void setIntensityLookupTable(String name) {
        this._colormap.setIntensityLookupTable(name);
        this._imageChangeEvent.setNewColormap(true);
        this._updatePending = true;
    }

    public void rotateColormap(int amount) {
        this._colormap.rotateColormap(amount);
        this._imageChangeEvent.setNewColormap(true);
        this._updatePending = true;
    }

    public void shiftColormap(int amount) {
        this._colormap.shiftColormap(amount);
        this._imageChangeEvent.setNewColormap(true);
        this._updatePending = true;
    }

    public void scaleColormap(int amount) {
        this._colormap.scaleColormap(amount);
        this._imageChangeEvent.setNewColormap(true);
        this._updatePending = true;
    }

    public void saveColormap() {
        this._colormap.saveColormap();
    }

    public void resetColormap() {
        this._colormap.resetColormap();
        this._imageChangeEvent.setNewColormap(true);
        this._updatePending = true;
    }

    public void setDefaultColormap() {
        this._colormap.setDefaultColormap();
        this.setScaleAlgorithm(0);
        this._imageChangeEvent.setNewColormap(true);
        this._updatePending = true;
    }

    protected void setUpdatePending(boolean b) {
        this._updatePending = b;
    }

    protected boolean isUpdatePending() {
        return this._updatePending;
    }

    static {
        String expectedJAIVersion = "jai-1_1";
        try {
            JAI.getBuildVersion();
        }
        catch (NoSuchMethodError e) {
            DialogUtil.error("Error: Incompatible JAI (Java Advanced Imaging) version. Expected " + expectedJAIVersion);
            System.exit(1);
        }
        ImageCodec.registerCodec(new FITSCodec());
        MinMaxDescriptor.register();
        CutLevelDescriptor.register();
    }
}

