/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import javax.swing.JButton;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.util.I18N;
import jsky.util.Resources;
import jsky.util.gui.GenericToolBar;

public class ImageDisplayToolBar
extends GenericToolBar {
    private static final I18N _I18N = I18N.getInstance(ImageDisplayToolBar.class);
    protected DivaMainImageDisplay imageDisplay;
    protected JButton cutLevelsButton;

    public ImageDisplayToolBar(DivaMainImageDisplay imageDisplay) {
        super(imageDisplay, false);
        this.imageDisplay = imageDisplay;
        this.addToolBarItems();
        this.openButton.setToolTipText(_I18N.getString("imageOpenTip"));
        this.backButton.setToolTipText(_I18N.getString("imageBackTip"));
        this.forwardButton.setToolTipText(_I18N.getString("imageForwardTip"));
    }

    @Override
    protected void addToolBarItems() {
        super.addToolBarItems();
        this.addSeparator();
        this.add(this.makeCutLevelsButton());
    }

    protected JButton makeCutLevelsButton() {
        if (this.cutLevelsButton == null) {
            this.cutLevelsButton = this.makeButton(this.imageDisplay.getCutLevelsAction());
        }
        this.updateButton(this.cutLevelsButton, _I18N.getString("cutLevels"), Resources.getIcon("CutLevels24.gif"));
        return this.cutLevelsButton;
    }

    @Override
    public void update() {
        super.update();
        this.makeCutLevelsButton();
    }
}

