/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jsky.catalog.Catalog;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.CatalogHistoryItem;
import jsky.catalog.gui.CatalogNavigator;
import jsky.catalog.gui.CatalogNavigatorOpener;
import jsky.catalog.gui.CatalogQueryTool;
import jsky.catalog.gui.CatalogTree;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.catalog.gui.TableDisplayTool;
import jsky.catalog.gui.TablePlotter;
import jsky.catalog.skycat.SkycatTable;
import jsky.catalog.vo.VoCatalog;
import jsky.catalog.vo.VoTable;
import jsky.image.gui.MainImageDisplay;
import jsky.image.gui.PickObjectStatistics;
import jsky.navigator.NavigatorImageDisplay;
import jsky.navigator.NavigatorImageDisplayFrame;
import jsky.navigator.NavigatorImageDisplayManager;
import jsky.navigator.NavigatorPickObjectSupport;
import jsky.navigator.NavigatorQueryTool;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ExampleFileFilter;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;
import jsky.util.gui.SwingUtil;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import uk.ac.starlink.table.formats.CsvStarTable;
import uk.ac.starlink.util.URLDataSource;

public class Navigator
extends CatalogNavigator
implements CatalogNavigatorOpener {
    public static final String IMAGE_CACHE = "imageCache";
    private static CacheAccess<Integer, File> imageCache = JCS.getInstance("imageCache");
    private static final I18N _I18N = I18N.getInstance(Navigator.class);
    private static Logger LOG = Logger.getLogger(Navigator.class.getName());
    private NavigatorImageDisplayManager _imageDisplayMgr;
    private JFrame _imageDisplayControlFrame;
    private NavigatorImageDisplay _imageDisplay;
    private NavigatorPickObjectSupport _pickObjectSupport;
    private AbstractAction _imageDisplayAction = new AbstractAction("Image"){
        {
            this.putValue("ShortDescription", _I18N.getString("showImageWin"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Navigator.this.showImageDisplay();
        }
    };

    public Navigator(CatalogTree catalogTree, TablePlotter plotter, MainImageDisplay imageDisplay) {
        super(catalogTree, plotter);
        if (imageDisplay != null) {
            this._imageDisplay = (NavigatorImageDisplay)imageDisplay;
            this._imageDisplayControlFrame = SwingUtil.getFrame((Component)((Object)imageDisplay));
            this.initSymbolPlotter();
        }
    }

    public Navigator(CatalogTree catalogTree, TablePlotter plotter) {
        this(catalogTree, plotter, null);
    }

    public void setImageDisplayManager(NavigatorImageDisplayManager imageDisplayMgr) {
        this._imageDisplayMgr = imageDisplayMgr;
    }

    public MainImageDisplay getImageDisplay() {
        return this._imageDisplay;
    }

    protected void setImageDisplay(NavigatorImageDisplay imageDisplay) {
        this._imageDisplay = imageDisplay;
        this.setImageDisplayControlFrame(imageDisplay.getParentFrame());
        this.notifyNewImageDisplay();
        this.initSymbolPlotter();
    }

    protected void setImageDisplayControlFrame(JFrame imageDisplayControlFrame) {
        this._imageDisplayControlFrame = imageDisplayControlFrame;
    }

    public void setImageDisplayNavigator(Navigator navigator) {
        this._imageDisplay.setNavigator(navigator);
    }

    public Action getImageDisplayAction() {
        return this._imageDisplayAction;
    }

    @Override
    protected CatalogQueryTool makeCatalogQueryTool(Catalog catalog) {
        return new NavigatorQueryTool(catalog, (QueryResultDisplay)this, this._imageDisplay);
    }

    protected void makeImageDisplayControlFrame() {
        if (this._imageDisplayMgr != null) {
            this._imageDisplay = this._imageDisplayMgr.getImageDisplay();
            this._imageDisplayControlFrame = this._imageDisplayMgr.getImageDisplayControlFrame();
        } else {
            this._imageDisplayControlFrame = new NavigatorImageDisplayFrame();
            this._imageDisplayControlFrame.setVisible(true);
            this._imageDisplay = (NavigatorImageDisplay)((NavigatorImageDisplayFrame)this._imageDisplayControlFrame).getImageDisplayControl().getImageDisplay();
        }
        this._imageDisplay.setNavigator(this);
    }

    protected void loadImage(String filename, URL url) {
        this.showImageDisplay();
        this._imageDisplay.setFilename(filename, url);
    }

    public void showImageDisplay() {
        if (this._imageDisplay == null) {
            this.makeImageDisplayControlFrame();
            this.notifyNewImageDisplay();
            this.initSymbolPlotter();
        } else {
            SwingUtil.showFrame(this._imageDisplayControlFrame);
        }
    }

    protected void loadImage(URL url, String contentType) throws IOException {
        Integer hashCode = Objects.hash(url.toString());
        Optional<Object> cachedFile = Optional.empty();
        if (imageCache.get(hashCode) != null) {
            cachedFile = Optional.of(imageCache.get(hashCode));
            URL urlToPreloadedImageFile = ((File)cachedFile.get()).toURI().toURL();
            SwingUtilities.invokeLater(new NavigatorImageLoader(urlToPreloadedImageFile.getPath(), urlToPreloadedImageFile));
        } else {
            File file = null;
            if (url.getProtocol().equals("file")) {
                SwingUtilities.invokeLater(new NavigatorImageLoader(url.getPath(), url));
            } else {
                int bytesRead;
                String dir = Preferences.getPreferences().getCacheDir().getPath();
                String suffix = contentType.endsWith("hfits") ? ".hfits" : (contentType.endsWith("zfits") || contentType.equals("image/x-fits") ? ".fits.gz" : (contentType.endsWith("fits") ? ".fits" : (contentType.startsWith("image/") ? "." + contentType.substring(6) : ".tmp")));
                file = File.createTempFile("jsky", suffix, new File(dir));
                ProgressPanel progressPanel = this.getProgressPanel();
                ProgressBarFilterInputStream in = progressPanel.getLoggedInputStream(url);
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    if (progressPanel.isInterrupted()) {
                        throw new ProgressException("Interrupted");
                    }
                    out.write(buffer, 0, bytesRead);
                }
                in.close();
                out.flush();
                out.close();
                if (!progressPanel.isInterrupted()) {
                    SwingUtilities.invokeLater(new NavigatorImageLoader(file.toString(), url));
                }
            }
            imageCache.put(hashCode, file);
        }
    }

    protected void notifyNewImageDisplay() {
        this.notifyNewImageDisplay(this.getBackStack());
        this.notifyNewImageDisplay(this.getForwStack());
        JComponent queryComponent = this.getQueryComponent();
        if (queryComponent instanceof NavigatorQueryTool) {
            ((NavigatorQueryTool)queryComponent).setImageDisplay(this._imageDisplay);
        }
    }

    protected void notifyNewImageDisplay(Stack<CatalogHistoryItem> stack) {
        int n = stack.size();
        for (int i = 0; i < n; ++i) {
            CatalogHistoryItem item = (CatalogHistoryItem)stack.get(i);
            JComponent comp = item.getQueryComponent();
            if (!(comp instanceof NavigatorQueryTool)) continue;
            ((NavigatorQueryTool)comp).setImageDisplay(this._imageDisplay);
        }
    }

    protected void initSymbolPlotter() {
        TablePlotter plotter = this.getPlotter();
        if (plotter != null) {
            plotter.setCanvasGraphics(this._imageDisplay.getCanvasGraphics());
            plotter.setCoordinateConverter(this._imageDisplay.getCoordinateConverter());
            this._imageDisplay.getNavigatorPane().setPlotter(plotter);
        }
    }

    @Override
    protected JComponent makeURLComponent(URL url, String contentType, String format) throws IOException {
        String filename = url.getFile();
        String protocol = url.getProtocol();
        LOG.info("Display URL: ContentType = " + contentType + ", format = " + format + ", URL = " + url + ", protocol = " + protocol + ", filename = " + filename);
        if (format != null && format.startsWith("image/")) {
            this.loadImage(url, format);
            return this.getResultComponent();
        }
        if ("spectrum/votable".equalsIgnoreCase(format) || "spectrum/fits".equalsIgnoreCase(format) || "text/xml".equalsIgnoreCase(contentType) || filename.endsWith(".xml") || filename.endsWith(".vot")) {
            VoTable table = VoTable.createVoTable(url, null, format);
            table.setCatalog(new VoCatalog(table));
            return this.makeCatalogComponent(table.getCatalog());
        }
        if ("text/csv".equalsIgnoreCase(format)) {
            CsvStarTable starTable = new CsvStarTable(new URLDataSource(url));
            VoTable table = VoTable.createVoTable(starTable, null, Integer.MAX_VALUE);
            table.setCatalog(new VoCatalog(table));
            return this.makeCatalogComponent(table.getCatalog());
        }
        if (filename.toLowerCase().endsWith(".fits") && !"application/xml".equalsIgnoreCase(contentType)) {
            try {
                VoTable table = VoTable.createVoTable(url, null, format);
                table.setCatalog(new VoCatalog(table));
                return this.makeCatalogComponent(table.getCatalog());
            }
            catch (Exception table) {
                // empty catch block
            }
        }
        if ("file".equals(protocol) && (filename.endsWith(".table") || filename.endsWith(".scat") || filename.endsWith(".cat"))) {
            SkycatTable table = new SkycatTable(filename);
            return this.makeCatalogComponent(table.getCatalog());
        }
        if (contentType.startsWith("text/")) {
            return super.makeURLComponent(url, contentType, format);
        }
        this.loadImage(url, contentType);
        return this.getResultComponent();
    }

    @Override
    public void openCatalogWindow() {
    }

    @Override
    public void openCatalogWindow(Catalog cat) {
        if (cat != null) {
            this.setAutoQuery(false);
            this.setQueryResult(cat);
        }
    }

    @Override
    public void openCatalogWindow(String name) {
        Catalog cat = Navigator.getCatalogDirectory(false).findCatalog(name);
        if (cat != null) {
            this.openCatalogWindow(cat);
        }
    }

    @Override
    public void openLocalCatalog() {
        this.open();
    }

    @Override
    public void saveWithImage() {
        JComponent resultComponent = this.getResultComponent();
        if (!(resultComponent instanceof TableDisplayTool)) {
            DialogUtil.error("This operation is only supported for tables");
        } else if (this._imageDisplay == null) {
            DialogUtil.error("No current FITS image.");
        } else {
            TableQueryResult table = ((TableDisplayTool)resultComponent).getTable();
            this._imageDisplay.saveFITSTable(table);
        }
    }

    @Override
    public JFileChooser makeFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        ExampleFileFilter xmlFilter = new ExampleFileFilter(new String[]{"xml", "vot"}, "VOTable XML File");
        fileChooser.addChoosableFileFilter(xmlFilter);
        ExampleFileFilter fitsFilter = new ExampleFileFilter(new String[]{"fit", "fits", "fts"}, "FITS File (with Table Extensions)");
        fileChooser.addChoosableFileFilter(fitsFilter);
        ExampleFileFilter skycatLocalCatalogFilter = new ExampleFileFilter(new String[]{"table", "scat", "cat"}, "Skycat Local Catalog File");
        fileChooser.addChoosableFileFilter(skycatLocalCatalogFilter);
        fileChooser.setFileFilter(xmlFilter);
        return fileChooser;
    }

    public void addPickedObjectToTable(PickObjectStatistics stats, boolean isUpdate) {
        if (this._pickObjectSupport == null) {
            this._pickObjectSupport = new NavigatorPickObjectSupport(this);
        }
        this._pickObjectSupport.addToTable(stats, isUpdate);
    }

    protected class NavigatorImageLoader
    implements Runnable {
        String filename;
        URL url;

        public NavigatorImageLoader(String filename, URL url) {
            this.filename = filename;
            this.url = url;
        }

        @Override
        public void run() {
            Navigator.this.loadImage(this.filename, this.url);
            Navigator.this.showImageDisplay();
        }
    }
}

