/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.datastructures;

import alma.obsprep.datastructures.Node;
import java.util.ArrayList;
import java.util.List;

public class GenericNaryTree<T> {
    private Node<T> root;

    public boolean isEmpty() {
        return this.root == null;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public void setRoot(Node<T> node) {
        this.root = node;
    }

    public boolean exists(T t) {
        return this.find(this.root, t);
    }

    public int size() {
        return this.getNumberOfDescendants(this.root) + 1;
    }

    public int getNumberOfDescendants(Node<T> node) {
        int n = node.getChildren().size();
        for (Node<T> node2 : node.getChildren()) {
            n += this.getNumberOfDescendants(node2);
        }
        return n;
    }

    private boolean find(Node<T> node, T t) {
        boolean bl = false;
        if (node.getData().equals(t)) {
            return true;
        }
        for (Node<T> node2 : node.getChildren()) {
            if (!this.find(node2, t)) continue;
            bl = true;
        }
        return bl;
    }

    public List<Node<T>> getPreOrderTraversal() {
        ArrayList<Node<T>> arrayList = new ArrayList<Node<T>>();
        this.buildPreOrder(this.root, arrayList);
        return arrayList;
    }

    public List<Node<T>> getBreadthFirstPreOrderTraversal() {
        ArrayList<Node<T>> arrayList = new ArrayList<Node<T>>();
        this.buildBreadthFirstPreOrder(this.root, arrayList);
        return arrayList;
    }

    private void buildBreadthFirstPreOrder(Node<T> node, List<Node<T>> list) {
        list.add(node);
        for (Node<T> node2 : node.getChildren()) {
            this.buildBreadthFirstPreOrder(node2, list);
        }
    }

    public List<Node<T>> getPostOrderTraversal() {
        ArrayList<Node<T>> arrayList = new ArrayList<Node<T>>();
        this.buildPostOrder(this.root, arrayList);
        return arrayList;
    }

    private void buildPreOrder(Node<T> node, ArrayList<Node<T>> arrayList) {
        arrayList.add(node);
        for (Node<T> node2 : node.getChildren()) {
            this.buildPreOrder(node2, arrayList);
        }
    }

    private void buildPostOrder(Node<T> node, ArrayList<Node<T>> arrayList) {
        for (Node<T> node2 : node.getChildren()) {
            this.buildPostOrder(node2, arrayList);
        }
        arrayList.add(node);
    }

    public List<Node<T>> getLongestPathFromRootToAnyLeaf() {
        ArrayList<Node<T>> arrayList = null;
        int n = 0;
        for (ArrayList<Node<T>> arrayList2 : this.getPathsFromRootToAnyLeaf()) {
            if (arrayList2.size() <= n) continue;
            n = arrayList2.size();
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public int getHeight() {
        return this.getLongestPathFromRootToAnyLeaf().size();
    }

    public List<ArrayList<Node<T>>> getPathsFromRootToAnyLeaf() {
        ArrayList<ArrayList<Node<T>>> arrayList = new ArrayList<ArrayList<Node<T>>>();
        ArrayList<Node<T>> arrayList2 = new ArrayList<Node<T>>();
        this.getPath(this.root, arrayList2, arrayList);
        return arrayList;
    }

    private void getPath(Node<T> node, ArrayList<Node<T>> arrayList, ArrayList<ArrayList<Node<T>>> arrayList2) {
        int n;
        if (arrayList == null) {
            return;
        }
        arrayList.add(node);
        if (node.getChildren().isEmpty()) {
            arrayList2.add(this.clone(arrayList));
        }
        for (Node<T> node2 : node.getChildren()) {
            this.getPath(node2, arrayList, arrayList2);
        }
        for (int i = n = arrayList.indexOf(node); i < arrayList.size(); ++i) {
            arrayList.remove(n);
        }
    }

    private ArrayList<Node<T>> clone(ArrayList<Node<T>> arrayList) {
        ArrayList<Node<T>> arrayList2 = new ArrayList<Node<T>>();
        for (Node<T> node : arrayList) {
            arrayList2.add(new Node<T>(node));
        }
        return arrayList2;
    }

    public static void main(String[] stringArray) {
        Node<Integer> node = new Node<Integer>(1);
        Node<Integer> node2 = new Node<Integer>(2);
        Node<Integer> node3 = new Node<Integer>(3);
        Node<Integer> node4 = new Node<Integer>(4);
        Node<Integer> node5 = new Node<Integer>(5);
        Node<Integer> node6 = new Node<Integer>(6);
        Node<Integer> node7 = new Node<Integer>(7);
        Node<Integer> node8 = new Node<Integer>(8);
        GenericNaryTree<Integer> genericNaryTree = new GenericNaryTree<Integer>(node);
        node.addChild(node2).addChild(node3);
        node2.addChild(node4).addChild(node5);
        node3.addChild(node6).addChild(node7);
        node7.addChild(node8);
        genericNaryTree.getBreadthFirstPreOrderTraversal().stream().forEach(System.out::println);
    }

    public GenericNaryTree(Node<T> node) {
        this.root = node;
    }
}

