/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.datastructures;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class Node<T> {
    private T data;
    private List<Node<T>> children;
    private Node<T> parent;

    public Node(@NonNull T t) {
        if (t == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = t;
        this.children = new ArrayList<Node<T>>();
    }

    public Node(@NonNull Node<T> node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        this.data = node.getData();
        this.children = new ArrayList<Node<T>>();
    }

    public Node<T> addChild(@NonNull Node<T> node) {
        if (node == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        node.setParent(this);
        this.children.add(node);
        return this;
    }

    public Node<T> addChildAt(int n, @NonNull Node<T> node) {
        if (node == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        node.setParent(this);
        this.children.add(n, node);
        return this;
    }

    public void setChildren(@NonNull List<Node<T>> list) {
        if (list == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        for (Node<T> node : list) {
            node.setParent(this);
        }
        this.children = list;
    }

    public void removeChildren() {
        this.children.clear();
    }

    public Node<T> removeChildAt(int n) {
        return this.children.remove(n);
    }

    public boolean removeChild(@NonNull Node<T> node) {
        if (node == null) {
            throw new NullPointerException("childToBeDeleted is marked non-null but is null");
        }
        List<Node<T>> list = this.getChildren();
        return list.remove(node);
    }

    public Node<T> getChildAt(int n) {
        return this.children.get(n);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        return object instanceof Node && ((Node)object).getData().equals(this.data);
    }

    public String toString() {
        return this.data.toString();
    }

    public T getData() {
        return this.data;
    }

    public List<Node<T>> getChildren() {
        return this.children;
    }

    public Node<T> getParent() {
        return this.parent;
    }

    public void setData(T t) {
        this.data = t;
    }

    public void setParent(Node<T> node) {
        this.parent = node;
    }
}

